/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.dmsdialogs.views.OwToolViewItem;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class OwToolView
extends OwView {
    private static final Logger LOG = OwLogCore.getLogger(OwToolView.class);
    public static final int DEFAULT_ITEM_COLUMNS_COUNT = 3;
    private List m_clickTargets = new ArrayList();
    private int m_columnItemsCount = 3;

    public OwToolView() {
        this(3);
    }

    public OwToolView(int columnItemsCount_p) {
        this.m_columnItemsCount = columnItemsCount_p;
    }

    public int getColumnItemsCount() {
        return this.m_columnItemsCount;
    }

    public abstract Collection getToolItems();

    public String createToolItemClickURL(OwToolViewItem item_p) {
        OwToolClickTarget itemClickTarget = new OwToolClickTarget(item_p);
        try {
            itemClickTarget.attach(this.getContext(), null);
            this.m_clickTargets.add(itemClickTarget);
            return itemClickTarget.createClickEventURL(this.getContext());
        }
        catch (Exception e) {
            LOG.error((Object)"OwToolView.createToolItemTarget : Could not create event URL!", (Throwable)e);
            return "";
        }
    }

    public abstract void invoke(OwToolViewItem var1);

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.detachClickTargets();
        this.serverSideDesignInclude("OwToolView.jsp", w_p);
    }

    private void detachClickTargets() {
        for (OwEventTarget clickTarget : this.m_clickTargets) {
            clickTarget.detach();
        }
        this.m_clickTargets.clear();
    }

    @Override
    public void detach() {
        this.detachClickTargets();
        super.detach();
    }

    public class OwToolClickTarget
    extends OwEventTarget {
        private OwToolViewItem m_item;

        public OwToolClickTarget(OwToolViewItem item_p) {
            this.m_item = item_p;
        }

        public String createClickEventURL(OwAppContext context_p) {
            return context_p.getEventURL(this, "Click", null);
        }

        public void onClick(HttpServletRequest request_p) throws Exception {
            OwToolView.this.invoke(this.m_item);
        }

        @Override
        protected void init() throws Exception {
        }
    }
}

