/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwDefaultComboModel;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectLinksDocument;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectLinksView;
import com.wewebu.ow.server.dmsdialogs.views.OwSplitObjectListView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectLinkRelation;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwVirtualLinkPropertyClasses;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class OwTypedLinksView
extends OwObjectLinksView {
    public static final String LINK_CLASS_ID = "lkclp";
    private Map<String, OwObjectCollection[]> linkObjects;
    private Map<String, OwObjectClass> linkClasses;
    private String currentClassName;

    public OwTypedLinksView(OwObjectLinksDocument document) {
        super(document);
    }

    @Override
    protected String usesFormWithAttributes() {
        return "";
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.setExternalFormTarget(this);
        OwSplitObjectListView typeView = this.createSplitView();
        this.addView(typeView, 1, null);
    }

    protected OwSplitObjectListView getSplitLinksView() throws OwObjectNotFoundException {
        return (OwSplitObjectListView)this.getViewRegion(1);
    }

    @Override
    public String getFilterDisplayName() {
        return this.getContext().localize("OwTypedLinksView.link.class", "Link class");
    }

    @Override
    public boolean isRegion(int iRegion_p) {
        if (2 == iRegion_p) {
            return true;
        }
        return super.isRegion(iRegion_p);
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        if (2 == iRegion_p) {
            Collection<OwObjectClass> classes = this.linkClasses.values();
            Locale locale = this.getContext().getLocale();
            String[] classDisplayNames = new String[this.linkClasses.size()];
            String[] classValues = new String[this.linkClasses.size()];
            int count = 0;
            for (OwObjectClass linkClass : classes) {
                classDisplayNames[count] = linkClass.getDisplayName(locale);
                classValues[count] = linkClass.getClassName();
                ++count;
            }
            OwDefaultComboModel comboModel = new OwDefaultComboModel(false, false, "" + this.currentClassName, classValues, classDisplayNames);
            OwComboboxRenderer renderer = ((OwMainAppContext)this.getContext()).createComboboxRenderer(comboModel, LINK_CLASS_ID, null, null, null);
            renderer.setEnabled(!this.isEmpty());
            if (!classes.isEmpty()) {
                StringBuffer linkClassChanged = new StringBuffer();
                linkClassChanged.append("<script>\n");
                linkClassChanged.append("function linkClassChanged(value) {\n");
                linkClassChanged.append("document.");
                linkClassChanged.append(this.getFormName());
                linkClassChanged.append(".action=\"");
                linkClassChanged.append(this.getEventURL("LinkClassChanged", null));
                linkClassChanged.append("\";document.");
                linkClassChanged.append(this.getFormName());
                linkClassChanged.append(".submit();\n");
                linkClassChanged.append("}\n");
                linkClassChanged.append("</script>\n");
                w_p.write(linkClassChanged.toString());
                renderer.addEvent("onchange", "linkClassChanged()");
            }
            renderer.renderCombo(w_p);
        } else {
            super.renderRegion(w_p, iRegion_p);
        }
    }

    public void onLinkClassChanged(HttpServletRequest request_p) throws Exception {
        String linkClass = request_p.getParameter(LINK_CLASS_ID);
        this.select(linkClass);
    }

    protected void select(String className) throws Exception {
        if (className != null) {
            OwSplitObjectListView linksView = this.getSplitLinksView();
            linksView.getDocument().setSplits(this.linkObjects.get(className));
            this.currentClassName = className;
        }
    }

    @Override
    protected void refresh(OwObjectCollection[] splitLinks) throws Exception {
        super.refresh(splitLinks);
        this.postRefresh(splitLinks);
    }

    protected void postRefresh(OwObjectCollection[] splitLinks) throws Exception {
        OwObjectCollection[] allLinks = splitLinks;
        this.linkObjects = new HashMap<String, OwObjectCollection[]>();
        this.linkClasses = new HashMap<String, OwObjectClass>();
        for (int i = 0; i < allLinks.length; ++i) {
            if (allLinks[i] == null) continue;
            for (OwObject link : allLinks[i]) {
                OwObjectClass linkClass = this.getLinkClass(link);
                OwObjectCollection[] classLinks = this.linkObjects.get(linkClass.getClassName());
                if (classLinks == null) {
                    this.linkClasses.put(linkClass.getClassName(), linkClass);
                    classLinks = new OwObjectCollection[allLinks.length];
                    this.linkObjects.put(linkClass.getClassName(), classLinks);
                }
                if (classLinks[i] == null) {
                    classLinks[i] = new OwStandardObjectCollection();
                }
                classLinks[i].add(link);
            }
        }
        if (!this.linkClasses.containsKey(this.currentClassName) && !this.linkClasses.isEmpty()) {
            this.currentClassName = this.linkClasses.keySet().iterator().next();
        } else if (this.linkClasses.isEmpty()) {
            this.currentClassName = null;
        }
        this.select(this.currentClassName);
    }

    protected OwObjectClass getLinkClass(OwObject object) {
        return object.getObjectClass();
    }

    @Override
    protected Collection<OwFieldColumnInfo> createRelationColumnInfo(OwObjectLinkRelation relation) throws Exception {
        if (this.getDocument().getColumnNames() != null) {
            return super.createRelationColumnInfo(relation);
        }
        Collection<OwFieldColumnInfo> propertyColumnInfo = OwObjectLinkRelation.INBOUND == relation ? this.createColumnInfo(Arrays.asList(OwVirtualLinkPropertyClasses.LINK_SOURCE.getClassName())) : (OwObjectLinkRelation.OUTBOUND == relation ? this.createColumnInfo(Arrays.asList(OwVirtualLinkPropertyClasses.LINK_TARGET.getClassName())) : this.createColumnInfo(Arrays.asList(OwVirtualLinkPropertyClasses.LINK_SOURCE.getClassName(), OwVirtualLinkPropertyClasses.LINK_TARGET.getClassName())));
        return propertyColumnInfo;
    }
}

