/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views.classes;

import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;

public class OwRootClassCfg {
    private String name;
    private boolean includeSubclasses = false;

    protected OwRootClassCfg(String name, boolean includeSubclasses) {
        this.name = name;
        this.includeSubclasses = includeSubclasses;
    }

    public String getName() {
        return this.name;
    }

    public boolean isIncludeSubclasses() {
        return this.includeSubclasses;
    }

    public static OwRootClassCfg fromXml(OwXMLUtil xmlClass) throws OwConfigurationException {
        String className = xmlClass.getSafeTextValue(null);
        if (null == className) {
            OwString errMsg = new OwString("plug.owadddocument.cfg.missingCLassName", "Configuration error <ObjectClassSelection>, the object class is missing.");
            throw new OwConfigurationException(errMsg);
        }
        String includeSubclassesStr = xmlClass.getSafeStringAttributeValue("includeSubClasses", "false");
        boolean includeSubclasses = Boolean.parseBoolean(includeSubclassesStr);
        return new OwRootClassCfg(className, includeSubclasses);
    }
}

