/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardObjectClass;
import com.wewebu.ow.server.ecm.OwStandardProperty;
import com.wewebu.ow.server.ecm.OwStandardPropertyClass;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class OwObjectSkeleton
implements OwObject {
    private static final Logger LOG = OwLogCore.getLogger(OwObjectSkeleton.class);
    protected static final String DMS_PREFIX = "_OW_EMPTY_OBJECT_";
    protected OwPropertyCollection m_PropertyMap;
    protected String m_strMimeType = "undef";
    protected OwObjectClass m_ClassDescription;
    protected Map m_OverrideDefaultValuesMap = null;
    protected String m_DateFormatString;
    protected OwNetwork m_Network;

    public OwObjectSkeleton(OwNetwork network_p, OwObjectClass objectClass_p) throws Exception {
        this.m_ClassDescription = objectClass_p;
        this.refreshProperties();
        this.m_Network = network_p;
    }

    public OwObjectSkeleton(OwNetwork network_p, OwObjectClass objectClass_p, OwXMLUtil overrideDefaultValuesConfig_p) throws Exception {
        this.m_ClassDescription = objectClass_p;
        if (overrideDefaultValuesConfig_p != null) {
            this.m_OverrideDefaultValuesMap = new HashMap();
            for (Element configSubElem : overrideDefaultValuesConfig_p.getSafeNodeList()) {
                if (!configSubElem.getTagName().equals("Property")) continue;
                String propertyClassName = OwXMLDOMUtil.getSafeStringAttributeValue(configSubElem, "name", null);
                String propertyDefaultValue = OwXMLDOMUtil.getElementText(configSubElem);
                String string = propertyDefaultValue = propertyDefaultValue == null ? "" : propertyDefaultValue;
                if (propertyClassName != null) {
                    this.m_OverrideDefaultValuesMap.put(propertyClassName, propertyDefaultValue);
                    continue;
                }
                LOG.error((Object)("OwObjectSkeleton.OwObjectSkeleton: the config node owbootstrap.xml / <EcmAdapter> / <CreationInitialValues> / <ObjectClass name=\"" + (objectClass_p.getClassName() != null ? objectClass_p.getClassName() : "[unknown]") + "\"> / <Property> has no 'name' attribute."));
            }
        }
        this.refreshProperties();
        this.m_Network = network_p;
    }

    @Override
    public String getName() {
        try {
            return this.getProperty(this.getObjectClass().getNamePropertyName()).getValue().toString();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    @Override
    public String getID() {
        return this.getName();
    }

    @Override
    public String getClassName() {
        return this.m_ClassDescription.getClassName();
    }

    @Override
    public OwObjectClass getObjectClass() {
        return this.m_ClassDescription;
    }

    @Override
    public OwObjectCollection getParents() throws Exception {
        return null;
    }

    @Override
    public OwObjectCollection getChilds(int[] iObjectTypes_p, Collection propertyNames_p, OwSort sort_p, int iMaxSize_p, int iVersionSelection_p, OwSearchNode filterCriteria_p) throws Exception {
        return null;
    }

    @Override
    public boolean canFilterChilds() throws Exception {
        return false;
    }

    @Override
    public Collection getFilterProperties(Collection propertynames_p) throws Exception {
        return null;
    }

    @Override
    public OwVersionSeries getVersionSeries() throws Exception {
        return null;
    }

    @Override
    public boolean hasVersionSeries() throws Exception {
        return false;
    }

    @Override
    public OwVersion getVersion() throws Exception {
        return null;
    }

    @Override
    public int getType() {
        return this.m_ClassDescription.getType();
    }

    @Override
    public String getDMSID() throws Exception {
        return DMS_PREFIX;
    }

    @Override
    public OwProperty getProperty(String strPropertyName_p) throws Exception {
        OwProperty prop = this.findProperty(strPropertyName_p);
        if (null == prop) {
            String msg = "OwObjectSkeleton.getProperty: Cannot find the property, propertyName = " + strPropertyName_p;
            LOG.debug((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        return prop;
    }

    protected OwProperty findProperty(String strPropertyName_p) {
        return (OwProperty)this.m_PropertyMap.get(strPropertyName_p);
    }

    @Override
    public OwPropertyCollection getProperties(Collection propertyNames_p) throws Exception {
        return this.m_PropertyMap;
    }

    public OwPropertyCollection getEditableProperties(int iContext_p) throws Exception {
        OwStandardPropertyCollection ret = new OwStandardPropertyCollection();
        for (OwProperty prop : this.getProperties(null).values()) {
            if (prop.isReadOnly(iContext_p) || prop.getPropertyClass().isSystemProperty() || prop.isHidden(iContext_p) || prop.getValue() == null) continue;
            ret.put(prop.getPropertyClass().getClassName(), prop);
        }
        return ret;
    }

    @Override
    public OwPropertyCollection getClonedProperties(Collection strPropertyNames_p) throws Exception {
        return OwStandardPropertyClass.getClonedProperties(this, strPropertyNames_p);
    }

    @Override
    public void setProperties(OwPropertyCollection properties_p) throws Exception {
        for (OwProperty newProperty : properties_p.values()) {
            String strPropertyName = newProperty.getPropertyClass().getClassName();
            this.m_PropertyMap.put(strPropertyName, newProperty);
        }
    }

    @Override
    public boolean canSetProperties(int iContext_p) throws Exception {
        return true;
    }

    @Override
    public boolean canGetProperties(int iContext_p) throws Exception {
        return true;
    }

    @Override
    public boolean canLock() throws Exception {
        return false;
    }

    @Override
    public boolean setLock(boolean fLock_p) throws Exception {
        return false;
    }

    @Override
    public boolean getLock(int iContext_p) throws Exception {
        return false;
    }

    @Override
    public boolean getMyLock(int iContext_p) throws Exception {
        return false;
    }

    @Override
    public String getLockUserID(int iContext_p) throws Exception {
        return null;
    }

    @Override
    public boolean canSetContent(int iContentType_p, int iContext_p) throws Exception {
        return false;
    }

    @Override
    public boolean canGetContent(int iContentType_p, int iContext_p) throws Exception {
        return false;
    }

    @Override
    public String getMIMEType() throws Exception {
        return this.m_strMimeType;
    }

    @Override
    public String getMIMEParameter() throws Exception {
        return "";
    }

    @Override
    public void delete() throws Exception {
    }

    @Override
    public boolean canDelete(int iContext_p) throws Exception {
        return false;
    }

    @Override
    public void removeReference(OwObject oObject_p) throws Exception {
    }

    @Override
    public boolean canRemoveReference(OwObject oObject_p, int iContext_p) throws Exception {
        return false;
    }

    @Override
    public void add(OwObject oObject_p) throws Exception {
    }

    @Override
    public boolean canAdd(OwObject oObject_p, int iContext_p) throws Exception {
        return false;
    }

    @Override
    public void move(OwObject oObject_p, OwObject oldParent_p) throws Exception {
    }

    @Override
    public boolean canMove(OwObject oObject_p, OwObject oldParent_p, int iContext_p) throws Exception {
        return false;
    }

    @Override
    public OwSearchTemplate getSearchTemplate() throws Exception {
        return null;
    }

    @Override
    public Collection getColumnInfoList() throws Exception {
        return null;
    }

    @Override
    public int getPageCount() throws Exception {
        return 0;
    }

    @Override
    public OwResource getResource() throws Exception {
        return null;
    }

    @Override
    public OwPermissionCollection getPermissions() throws Exception {
        return null;
    }

    @Override
    public OwPermissionCollection getClonedPermissions() throws Exception {
        throw new OwNotSupportedException("OwObjectSkeleton.getClonedPermissions: Not implemented.");
    }

    @Override
    public boolean canGetPermissions() throws Exception {
        return false;
    }

    @Override
    public boolean canSetPermissions() throws Exception {
        return false;
    }

    @Override
    public void setPermissions(OwPermissionCollection permissions_p) throws Exception {
        throw new OwNotSupportedException("OwObjectSkeleton.setPermissions: Not implemented.");
    }

    @Override
    public void setContentCollection(OwContentCollection content_p) throws Exception {
    }

    @Override
    public OwContentCollection getContentCollection() throws Exception {
        return null;
    }

    @Override
    public void refreshProperties() throws Exception {
        this.m_PropertyMap = new OwStandardPropertyCollection();
        for (String propertyClassName : this.m_ClassDescription.getPropertyClassNames()) {
            String javaClassName;
            String overrideDefaultValueString;
            OwPropertyClass classDescription = this.m_ClassDescription.getPropertyClass(propertyClassName);
            Object defaultValue = null;
            defaultValue = this.m_OverrideDefaultValuesMap != null ? ((overrideDefaultValueString = (String)this.m_OverrideDefaultValuesMap.get(propertyClassName)) != null ? (overrideDefaultValueString.length() > 0 ? ((javaClassName = classDescription.getJavaClassName()).equals("java.util.Date") ? (overrideDefaultValueString.equals("{today}") ? new Date() : OwStandardPropertyClass.getSkalarValueFromString(overrideDefaultValueString, javaClassName)) : OwStandardPropertyClass.getSkalarValueFromString(overrideDefaultValueString, javaClassName)) : null) : classDescription.getDefaultValue()) : classDescription.getDefaultValue();
            if (defaultValue == null) {
                defaultValue = OwStandardObjectClass.createInitialNullValue(classDescription, false);
            }
            this.m_PropertyMap.put(propertyClassName, this.createNewProperty(defaultValue, classDescription));
        }
    }

    public OwProperty createNewProperty(Object defaultValue_p, OwPropertyClass classDescription_p) {
        return new OwStandardProperty(defaultValue_p, classDescription_p);
    }

    @Override
    public void refreshProperties(Collection props_p) throws Exception {
        this.refreshProperties();
    }

    @Override
    public Object getNativeObject() throws Exception {
        throw new OwObjectNotFoundException("OwObjectSkeleton.getNativeObject: Not implemented or Not supported.");
    }

    @Override
    public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException {
        return this.getProperty(strFieldClassName_p);
    }

    @Override
    public Object getFieldProviderSource() {
        return this;
    }

    @Override
    public int getFieldProviderType() {
        return 1;
    }

    @Override
    public boolean hasContent(int iContext_p) throws Exception {
        return false;
    }

    @Override
    public boolean hasChilds(int[] iObjectTypes_p, int iContext_p) throws Exception {
        return false;
    }

    @Override
    public String getPath() throws Exception {
        throw new OwNotSupportedException("OwObjectSkeleton.getPath: Not implemented.");
    }

    @Override
    public int getChildCount(int[] iObjectTypes_p, int iContext_p) throws Exception {
        return 0;
    }

    @Override
    public void changeClass(String strNewClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p) throws Exception {
        throw new OwInvalidOperationException("OwObjectSkeleton.changeClass: not implemented.");
    }

    @Override
    public boolean canChangeClass() throws Exception {
        return false;
    }

    @Override
    public String getFieldProviderName() {
        return this.getName();
    }

    @Override
    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
        this.getProperty(sName_p).setValue(value_p);
    }

    @Override
    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        try {
            return this.getProperty(sName_p).getValue();
        }
        catch (Exception e) {
            return defaultvalue_p;
        }
    }

    @Override
    public Collection getFields() throws Exception {
        return this.getProperties(null).values();
    }

    @Override
    public OwObject getInstance() throws Exception {
        return this;
    }

    @Override
    public String getResourceID() throws Exception {
        try {
            return this.getResource().getID();
        }
        catch (NullPointerException e) {
            throw new OwObjectNotFoundException("OwObjectSkeleton.getResourceID: Resource Id not found for DMSID = " + this.getDMSID(), (Throwable)e);
        }
    }

    @Override
    public void setProperties(OwPropertyCollection properties_p, Object mode_p) throws Exception {
        this.setProperties(properties_p);
    }
}

