/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwString;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwStandardObjectClass
implements OwObjectClass {
    private static final Logger LOG = OwLogCore.getLogger(OwStandardObjectClass.class);
    protected Map m_PropertyClassesMap;
    protected Collection m_propertyKeyList;
    protected boolean m_fCanCreateNewObject;
    protected String m_strClassName;
    protected String m_strNamePropertyName;
    protected OwObjectClass m_parent;
    protected OwString m_DisplayName;
    protected boolean m_fHidden;
    protected int m_iType;
    protected boolean m_fVersionable;
    protected OwString m_Description;

    public OwStandardObjectClass() {
    }

    public OwStandardObjectClass(String classname_p, int iType_p) {
        this.m_strClassName = classname_p;
        this.m_iType = iType_p;
        this.m_DisplayName = new OwString(classname_p);
        this.m_Description = new OwString(classname_p);
        this.m_PropertyClassesMap = new HashMap();
    }

    public static int getBaseObjectType(int iObjectType_p) {
        return iObjectType_p & 0xF000;
    }

    public static boolean isContainerType(int iObjectType_p) {
        return OwStandardObjectClass.getBaseObjectType(iObjectType_p) == 8192;
    }

    public static boolean isContentType(int iObjectType_p) {
        return OwStandardObjectClass.getBaseObjectType(iObjectType_p) == 4096;
    }

    public static boolean isTupleType(int iObjectType_p) {
        return OwStandardObjectClass.getBaseObjectType(iObjectType_p) == 12288;
    }

    public static boolean isWorkflowObjectType(int iObjectType_p) {
        return OwStandardObjectClass.getBaseObjectType(iObjectType_p) == 16384;
    }

    @Override
    public int getType() {
        return this.m_iType;
    }

    @Override
    public Map getChildNames(OwNetwork network_p, boolean fExcludeHiddenAndNonInstantiable_p) throws Exception {
        return null;
    }

    @Override
    public boolean hasChilds(OwNetwork network_p, boolean fExcludeHiddenAndNonInstantiable_p, int context_p) {
        return false;
    }

    @Override
    public List getChilds(OwNetwork network_p, boolean fExcludeHiddenAndNonInstantiable_p) throws Exception {
        return null;
    }

    @Override
    public String getClassName() {
        return this.m_strClassName;
    }

    public String getID() {
        return this.getClassName();
    }

    @Override
    public String getDisplayName(Locale locale_p) {
        return this.m_DisplayName.getString(locale_p);
    }

    @Override
    public OwPropertyClass getPropertyClass(String strClassName_p) throws Exception {
        OwPropertyClass propertyClassDescription = (OwPropertyClass)this.m_PropertyClassesMap.get(strClassName_p);
        if (null == propertyClassDescription) {
            String msg = "OwStandardObjectClass.getPropertyClass: Cannot find the class for property = " + strClassName_p;
            LOG.debug((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        return propertyClassDescription;
    }

    @Override
    public Collection getPropertyClassNames() throws Exception {
        if (null == this.m_propertyKeyList) {
            return this.m_PropertyClassesMap.keySet();
        }
        return this.m_propertyKeyList;
    }

    @Override
    public String getNamePropertyName() throws Exception {
        return this.m_strNamePropertyName;
    }

    @Override
    public boolean canCreateNewObject() throws Exception {
        return this.m_fCanCreateNewObject;
    }

    @Override
    public boolean hasVersionSeries() throws Exception {
        return this.m_fVersionable;
    }

    @Override
    public String getDescription(Locale locale_p) {
        return this.m_Description.getString(locale_p);
    }

    @Override
    public boolean isHidden() throws Exception {
        return this.m_fHidden;
    }

    @Override
    public OwObjectClass getParent() throws Exception {
        return this.m_parent;
    }

    public String toString() {
        if (this.m_DisplayName != null) {
            return this.m_DisplayName.getString(Locale.getDefault());
        }
        return super.toString();
    }

    @Override
    public List getModes(int operation_p) throws Exception {
        return null;
    }

    public static Object createInitialNullValue(OwFieldDefinition fieldDefinition_p, boolean fArrayInit_p) throws Exception {
        Object[] ret = null;
        if (fieldDefinition_p.isComplex() && (fArrayInit_p || !fieldDefinition_p.isArray())) {
            List subfielddefinitions = fieldDefinition_p.getComplexChildClasses();
            ret = new Object[subfielddefinitions.size()];
            for (int i = 0; i < subfielddefinitions.size(); ++i) {
                ret[i] = OwStandardObjectClass.createInitialNullValue((OwFieldDefinition)subfielddefinitions.get(i), false);
            }
        }
        return ret;
    }
}

