/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm.bpm;

import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemContainer;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public interface OwWorkitemRepository<W extends OwWorkitem>
extends OwRepository<W> {
    public static final String PATH_DELIMITER = "/";
    public static final OwContainerPrefixMapSingleton m_containerprefixmap = new OwContainerPrefixMapSingleton();

    public Collection getWorkitemContainerIDs(boolean var1, int var2) throws Exception;

    public OwWorkitemContainer getWorkitemContainer(String var1, int var2) throws Exception;

    public String getWorkitemContainerName(String var1, int var2) throws Exception;

    public boolean hasContainer(int var1) throws Exception;

    public OwProxyInfo createProxy() throws Exception, OwNotSupportedException;

    public void setProxies(Collection var1, String var2) throws Exception, OwNotSupportedException;

    public Collection getProxies(String var1) throws Exception, OwNotSupportedException;

    public boolean canProxy();

    public Collection getLaunchableWorkflowDescriptions(Collection var1) throws Exception;

    public OwWorkitem createLaunchableItem(OwWorkflowDescription var1, Collection var2) throws Exception;

    public boolean canLaunch();

    public static class OwContainerPrefixMapSingleton {
        private Map m_prefixmap = new HashMap();
        private Map m_typemap = new HashMap();

        public OwContainerPrefixMapSingleton() {
            this.addContainerInfo("proxy", 8229);
            this.addContainerInfo("roster", 8224);
            this.addContainerInfo("tracker", 8230);
            this.addContainerInfo("user", 8226);
            this.addContainerInfo("public", 8225);
            this.addContainerInfo("system", 8227);
            this.addContainerInfo("cross", 8228);
        }

        private void addContainerInfo(String sName_p, int iType_p) {
            this.m_typemap.put(sName_p, iType_p);
            this.m_prefixmap.put(iType_p, sName_p);
        }

        public String getContainerPrefix(int iType_p) throws OwObjectNotFoundException {
            try {
                return "ow_" + (String)this.m_prefixmap.get(iType_p);
            }
            catch (NullPointerException e) {
                throw new OwObjectNotFoundException("OwWorkitemRepository$OwContainerPrefixMapSingleton.getContainerPrefix: Could not find queue name for type = " + iType_p, (Throwable)e);
            }
        }

        public String getContainerMimeType(int iType_p) throws OwObjectNotFoundException {
            try {
                return "ow_workitemcontainer/" + (String)this.m_prefixmap.get(iType_p);
            }
            catch (NullPointerException e) {
                throw new OwObjectNotFoundException("OwWorkitemRepository$OwContainerPrefixMapSingleton.getContainerMimeType: Could not find mimetype for type = " + iType_p, (Throwable)e);
            }
        }

        public int getContainerType(String sContainerPrefix_p) throws OwObjectNotFoundException {
            try {
                return (Integer)this.m_typemap.get(sContainerPrefix_p.substring(3));
            }
            catch (NullPointerException e) {
                throw new OwObjectNotFoundException("OwWorkitemRepository$OwContainerPrefixMapSingleton.getContainerType: Could not find queue type for prefix = " + sContainerPrefix_p, (Throwable)e);
            }
        }

        public Collection getContainerTypes() {
            return this.m_typemap.values();
        }
    }

    public static interface OwProxyInfo {
        public String getProxyPersonID();

        public Date getStarttime();

        public Date getEndtime();

        public boolean getEnabled();

        public void setProxyPersonID(String var1);

        public void setStarttime(Date var1);

        public void setEndtime(Date var1);

        public void setEnabled(boolean var1);
    }
}

