/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm.eaop;

import com.wewebu.ow.server.ecm.eaop.OwAdvice;
import com.wewebu.ow.server.ecm.eaop.OwJoinPointResultCollector;
import com.wewebu.ow.server.ecm.eaop.OwThreadAdviser;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class OwJoinPoint
implements InvocationHandler {
    private static final Logger LOG = OwLogCore.getLogger(OwJoinPoint.class);
    private List<?> advices;
    private OwJoinPointResultCollector resultCollector;

    private static boolean areCompatible(Class<?> adviceClass_p, OwJoinPointResultCollector resultColector_p) throws OwException {
        Method[] methods;
        for (Method method : methods = adviceClass_p.getMethods()) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.getAnnotation(OwAdvice.class) == null || resultColector_p.canCollect(method)) continue;
            LOG.debug((Object)("Incompatible method " + method + " for result collector " + resultColector_p));
            return false;
        }
        return true;
    }

    public static <A> A joinPoint(Class<A> adviceClass_p, OwJoinPointResultCollector resultColector_p) throws OwException {
        if (!OwJoinPoint.areCompatible(adviceClass_p, resultColector_p)) {
            throw new OwInvalidOperationException("Incompatible collector" + resultColector_p + " for advice " + adviceClass_p + ".");
        }
        OwThreadAdviser adviser = OwThreadAdviser.currentAdviser();
        List<A> advices = adviser.get(adviceClass_p);
        advices = advices == null ? Collections.EMPTY_LIST : advices;
        OwJoinPoint point = new OwJoinPoint(advices, resultColector_p);
        return (A)Proxy.newProxyInstance(OwJoinPoint.class.getClassLoader(), new Class[]{adviceClass_p}, (InvocationHandler)point);
    }

    private OwJoinPoint(List<?> advices_p, OwJoinPointResultCollector resultCollector_p) {
        this.advices = advices_p;
        this.resultCollector = resultCollector_p;
    }

    @Override
    public Object invoke(Object proxy_p, Method method_p, Object[] args_p) throws Throwable {
        for (Object advice : this.advices) {
            Object result = method_p.invoke(advice, args_p);
            this.resultCollector.collect(method_p, advice, args_p, result);
        }
        return this.resultCollector.getResult();
    }
}

