/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.fieldctrlimpl;

import com.wewebu.ow.server.app.OwFieldManagerControl;
import com.wewebu.ow.server.app.OwFieldManagerException;
import com.wewebu.ow.server.ecm.OwClass;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.role.OwRoleManagerContext;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwHTMLHelper;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwFieldManagerControlClass
extends OwFieldManagerControl {
    private static final Logger LOG = OwLogCore.getLogger(OwFieldManagerControlClass.class);

    @Override
    public void insertReadOnlyField(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        if (fieldDef_p.isArray()) {
            Object[] values = (Object[])value_p;
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    this.insertSingleReadOnlyField(w_p, fieldDef_p, values[i]);
                    w_p.write("<br>");
                }
            }
        } else {
            this.insertSingleReadOnlyField(w_p, fieldDef_p, value_p);
        }
    }

    protected void insertSingleReadOnlyField(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        OwClass classValue;
        try {
            classValue = (OwClass)value_p;
        }
        catch (ClassCastException cce) {
            throw new OwConfigurationException("OwFieldManagerControlClass can only handle fields of type OwClass.", (Throwable)cce);
        }
        if (null != classValue) {
            OwHTMLHelper.writeSecureHTML(w_p, this.retrieveDisplayName(classValue));
        }
    }

    @Override
    public void insertEditField(Writer w_p, OwFieldDefinition fieldDef_p, OwField field_p, String strID_p) throws Exception {
        OwClass[] classValues = this.fromFieldValue(field_p.getValue(), fieldDef_p);
        if (classValues == null) {
            classValues = new OwClass[]{};
        }
        if (classValues.length > 0) {
            w_p.write("<select class=\"OwFieldControlClass\" size=\"");
            w_p.write("" + classValues.length);
            w_p.write("\"");
            w_p.write(" name=\"");
            w_p.write(strID_p);
            w_p.write("\" id=\"");
            w_p.write(strID_p);
            w_p.write("\" multiple>");
            for (int i = 0; i < classValues.length; ++i) {
                this.insertClassOption(w_p, fieldDef_p, classValues[i], i);
            }
            w_p.write("</select>");
        }
    }

    protected OwClass[] fromFieldValue(Object value_p, OwFieldDefinition fieldDef_p) throws Exception {
        try {
            OwClass[] classesValues = null;
            if (value_p != null) {
                if (fieldDef_p.isArray()) {
                    Object[] values = (Object[])value_p;
                    classesValues = new OwClass[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        classesValues[i] = (OwClass)values[i];
                    }
                } else {
                    classesValues = new OwClass[]{(OwClass)value_p};
                }
            }
            return classesValues;
        }
        catch (ClassCastException cce) {
            throw new OwConfigurationException("OwFieldManagerControlClass can only handle fields of type OwClass.", (Throwable)cce);
        }
    }

    protected Object toFieldValue(OwClass[] classValues_p, OwFieldDefinition fieldDef_p) throws Exception {
        if (classValues_p != null) {
            if (fieldDef_p.isArray()) {
                return classValues_p;
            }
            if (classValues_p.length > 0) {
                return classValues_p[0];
            }
            return null;
        }
        return null;
    }

    protected String retrieveDisplayName(OwClass owClass_p) {
        if (null != owClass_p) {
            OwAppContext context = this.getContext();
            String className = owClass_p.getClassName();
            if (context instanceof OwRoleManagerContext) {
                try {
                    OwRoleManagerContext rmContext = (OwRoleManagerContext)((Object)context);
                    OwNetwork network = rmContext.getNetwork();
                    String resourceName = owClass_p.getResourceName();
                    OwResource resource = network.getResource(resourceName);
                    OwObjectClass objectClass = network.getObjectClass(className, resource);
                    return objectClass.getDisplayName(context.getLocale());
                }
                catch (Exception e) {
                    LOG.debug((Object)("OwFieldManagerControlClass.retrieveDisplayName():Could not find class " + className + " to retrieve display name!Falling back on search template defined name!"), (Throwable)e);
                    return className;
                }
            }
            return className;
        }
        return "";
    }

    protected void insertClassOption(Writer w_p, OwFieldDefinition fieldDef_p, OwClass value_p, int optionIndex_p) throws Exception {
        String option = "";
        boolean selected = false;
        if (null != value_p) {
            option = this.retrieveDisplayName(value_p);
            selected = value_p.isEnabled();
        }
        String optionClass = "OwFieldControlClass_odd";
        if ((Math.abs(optionIndex_p) + 1) % 2 == 0) {
            optionClass = "OwFieldControlClass_even";
        }
        w_p.write("<option class=\"");
        w_p.write(optionClass);
        w_p.write("\"  value=\"");
        OwHTMLHelper.writeSecureHTML(w_p, "" + optionIndex_p);
        w_p.write("\"");
        if (selected) {
            w_p.write(" selected>");
        } else {
            w_p.write(">");
        }
        OwHTMLHelper.writeSecureHTML(w_p, option);
        w_p.write("</option>");
    }

    @Override
    public Object updateField(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        Object retObject = null;
        String[] classSelections = request_p.getParameterValues(strID_p);
        if (classSelections == null) {
            classSelections = new String[]{};
        }
        OwClass[] values = this.fromFieldValue(value_p, fieldDef_p);
        OwClass[] retClasses = new OwClass[values.length];
        for (int i = 0; i < values.length; ++i) {
            OwClass classValue = values[i];
            retClasses[i] = new OwClass(classValue.getObjectType(), classValue.getClassName(), classValue.getBaseClassName(), classValue.getResourceName(), false, classValue.isIncludeSubclasses());
        }
        boolean noClassSelected = true;
        for (int i = 0; i < classSelections.length; ++i) {
            int index = 0;
            try {
                index = Integer.parseInt(classSelections[i]);
                if (index >= 0 && index < retClasses.length) {
                    noClassSelected = false;
                    OwClass classRetValue = retClasses[index];
                    retClasses[index] = new OwClass(classRetValue.getObjectType(), classRetValue.getClassName(), classRetValue.getBaseClassName(), classRetValue.getResourceName(), true, classRetValue.isIncludeSubclasses());
                    continue;
                }
                LOG.error((Object)("OwFieldManagerControlClass.updateField() : Invalid update index : " + index + ". Indexes greater than 0 and less than " + retClasses.length + " expected!"));
                continue;
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)"OwFieldManagerControlClass.updateField(): NumberFormatException", (Throwable)nfe);
            }
        }
        retObject = this.toFieldValue(retClasses, fieldDef_p);
        if (fieldDef_p.isRequired() && (noClassSelected || retObject == null || retObject.toString().length() == 0)) {
            throw new OwFieldManagerException(this.getContext().localize("app.OwStandardFieldManager.requiredfield", "Das Feld ist erforderlich und muss einen Wert erhalten."));
        }
        return retObject;
    }
}

