/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.fieldctrlimpl;

import com.wewebu.ow.server.app.OwClipboard;
import com.wewebu.ow.server.app.OwClipboardContentOwObject;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwFieldManagerControl;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwUnresolvedReference;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Node;

public class OwFieldManagerControlImage
extends OwFieldManagerControl {
    private static final String QUERY_KEY_ID = "id";
    public static final String CONF_LINK = "BrokenImage";
    private String brokenLink;

    @Override
    public void init(OwFieldManager fieldmanager_p, Node configNode_p) throws Exception {
        super.init(fieldmanager_p, configNode_p);
        OwStandardXMLUtil util = new OwStandardXMLUtil(configNode_p);
        this.brokenLink = util.getSafeTextValue(CONF_LINK, "/images/doc_warning_48.png");
    }

    public void renderImage(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        if (fieldDef_p.getJavaClassName().equals("com.wewebu.ow.server.ecm.OwObjectReference") || fieldDef_p.getJavaClassName().equals("com.wewebu.ow.server.ecm.OwObject")) {
            if (null != value_p) {
                OwObjectReference object = (OwObjectReference)value_p;
                StringBuilder strImageUploadURL = new StringBuilder(this.getContext().getBaseURL());
                String reason = null;
                if (object instanceof OwUnresolvedReference) {
                    strImageUploadURL.append(this.getBrokenLink());
                    reason = ((OwUnresolvedReference)object).getUnresolvedReason();
                    reason = OwHTMLHelper.encodeToSecureHTML(reason);
                } else {
                    strImageUploadURL.append("/getContent?");
                    strImageUploadURL.append("dmsid");
                    strImageUploadURL.append("=");
                    strImageUploadURL.append(OwAppContext.encodeURL(object.getDMSID()));
                }
                w_p.write("<img src=\"");
                w_p.write(strImageUploadURL.toString());
                w_p.write("\" alt=\"");
                if (reason != null) {
                    w_p.write(reason);
                }
                w_p.write("\" title=\"");
                if (reason != null) {
                    w_p.write(reason);
                }
                w_p.write("\" />");
            }
        } else if (null != value_p) {
            w_p.write("<img src=\"");
            w_p.write(this.getContext().getBaseURL());
            w_p.write("/demo/");
            w_p.write(value_p.toString());
            w_p.write("\" alt=\"\" title=\"\"/>");
        }
    }

    @Override
    public void insertReadOnlyField(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        this.renderImage(w_p, fieldDef_p, value_p);
    }

    @Override
    public void insertEditField(Writer w_p, OwFieldDefinition fieldDef_p, OwField field_p, String strID_p) throws Exception {
        String pasteClipboardObjectTooltip;
        OwObject obj;
        this.renderImage(w_p, fieldDef_p, field_p.getValue());
        boolean renderDisable = true;
        OwClipboard clipboard = ((OwMainAppContext)this.getContext()).getClipboard();
        if (1 == clipboard.getContentType() && clipboard.getContent().size() == 1 && (obj = ((OwClipboardContentOwObject)clipboard.getContent().get(0)).getObject()).getMIMEType().startsWith("image")) {
            pasteClipboardObjectTooltip = this.getContext().localize("app.OwStandardFieldManager.pasteimage", "Paste an image from the clipboard.");
            w_p.write("<a title=\"");
            w_p.write(pasteClipboardObjectTooltip);
            w_p.write("\" href=\"");
            w_p.write(this.getFormEventURL("SetImage", "id=" + strID_p));
            w_p.write("\">");
            w_p.write("<img style=\"vertical-align:top;border:0px none;margin:1px 2px;\" alt=\"");
            w_p.write(pasteClipboardObjectTooltip);
            w_p.write("\" title=\"");
            w_p.write(pasteClipboardObjectTooltip);
            w_p.write("\"  src=\"");
            w_p.write(this.getContext().getDesignURL());
            w_p.write("/images/plug/owpaste/add_paste.png\">");
            w_p.write("</a>");
            renderDisable = false;
        }
        if (renderDisable) {
            pasteClipboardObjectTooltip = clipboard.getContent().size() > 1 ? this.getContext().localize("app.OwStandardFieldManager.howtopastimage.onlyone", "Please copy only one image to the clipboard. Then you can paste it using the paste icon.") : this.getContext().localize("app.OwStandardFieldManager.howtopastimage", "Please copy an image to the clipboard first. Then you can paste it using the paste icon.");
            w_p.write("<img style=\"vertical-align:top;border:0px none;margin:1px 2px;\" alt=\"");
            w_p.write(pasteClipboardObjectTooltip);
            w_p.write("\" title=\"");
            w_p.write(pasteClipboardObjectTooltip);
            w_p.write("\" src=\"");
            w_p.write(this.getContext().getDesignURL());
            w_p.write("/images/plug/owpaste/add_paste_disabled.png\">");
        }
    }

    public void onSetImage(HttpServletRequest request_p) throws Exception {
        OwClipboard clipboard = ((OwMainAppContext)this.getContext()).getClipboard();
        OwField field = this.getFieldManager().getField(request_p.getParameter(QUERY_KEY_ID));
        field.setValue(((OwClipboardContentOwObject)clipboard.getContent().get(0)).getObject());
    }

    @Override
    public Object updateField(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        return value_p;
    }

    protected String getBrokenLink() {
        return this.brokenLink;
    }
}

