/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.fieldctrlimpl;

import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwFieldManagerControl;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwSettingsProperty;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwString;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwFieldManagerControlNote
extends OwFieldManagerControl {
    private static final int SHORTEN_THRESHOLD = 200;
    private static final Logger LOG = OwLogCore.getLogger(OwFieldManagerControlNote.class);
    private Map m_errorCauseMap = new HashMap();

    protected void insertTextArea(Writer w_p, OwFieldDefinition fieldDef_p, String value_p, String errorCause_p, String strID_p) throws Exception {
        w_p.write("         <textarea ");
        w_p.write("id=\"");
        OwHTMLHelper.writeSecureHTML(w_p, strID_p);
        w_p.write("\" title=\"");
        OwHTMLHelper.writeSecureHTML(w_p, fieldDef_p.getDescription(this.getContext().getLocale()));
        w_p.write("\" cols=\"40\" rows=\"5\" class=\"OwInputControl OwInputControlMultiString OwInputControl_");
        w_p.write(fieldDef_p.getClassName());
        w_p.write("\" name=\"");
        OwHTMLHelper.writeSecureHTML(w_p, strID_p);
        w_p.write("\" onblur=\"onFieldManagerFieldExit('");
        OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(fieldDef_p.getClassName()));
        w_p.write("','");
        OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(fieldDef_p.getJavaClassName()));
        w_p.write("','");
        OwFieldProvider fieldProvider = this.getFieldManager().getFieldProvider();
        if (fieldProvider != null) {
            OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(Integer.toString(fieldProvider.getFieldProviderType())));
            w_p.write("','");
            OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(fieldProvider.getFieldProviderName()));
            w_p.write("','");
        }
        OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(strID_p));
        w_p.write("',this.value)\" onkeydown=\"event.cancelBubble=true\">");
        OwHTMLHelper.writeSecureHTML(w_p, errorCause_p);
        if (value_p != null) {
            OwHTMLHelper.writeSecureHTML(w_p, value_p);
        }
        w_p.write("</textarea>");
    }

    protected void insertPersistedEditField(Writer w_p, OwFieldDefinition fieldDef_p, OwField field_p, String strID_p) throws Exception {
        String value;
        boolean showNewNotesAtTheEnd = this.shouldShowNewNotesAtTheEndOfField();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwFieldManagerControlNote.insertPersistedEditField: Show new notes at the end of the field: " + showNewNotesAtTheEnd));
        }
        String error = this.getFieldManager().getSafeFieldError(field_p);
        String errorCause = "";
        if (error != null && error.length() > 0 && (value = (String)this.m_errorCauseMap.get(strID_p)) != null) {
            errorCause = value;
            this.m_errorCauseMap.remove(strID_p);
        }
        this.insertTextArea(w_p, fieldDef_p, null, errorCause, strID_p);
        String oldNotes = (String)field_p.getValue();
        OwNoteDataModel noteDataModel = new OwNoteDataModel(this.getContext().getLocale(), oldNotes, showNewNotesAtTheEnd);
        if (!noteDataModel.isNullContent()) {
            w_p.write("         <input type=\"hidden\" name=\"" + this.getHiddenNotesControlId(strID_p) + "\" value=\"");
            OwHTMLHelper.writeSecureHTML(w_p, noteDataModel.getTrimmedText());
            w_p.write("\"/>");
            this.renderNotesContent(w_p, noteDataModel, showNewNotesAtTheEnd);
        }
    }

    protected void insertVolatileEditField(Writer w_p, OwFieldDefinition fieldDef_p, OwField field_p, String strID_p) throws Exception {
        String value;
        String error = this.getFieldManager().getSafeFieldError(field_p);
        String errorCause = "";
        if (error != null && error.length() > 0 && (value = (String)this.m_errorCauseMap.get(strID_p)) != null) {
            errorCause = value;
            this.m_errorCauseMap.remove(strID_p);
        }
        String oldNote = (String)field_p.getValue();
        this.insertTextArea(w_p, fieldDef_p, oldNote, errorCause, strID_p);
    }

    protected boolean isVolatileNote() {
        OwFieldManager fieldManager = this.getFieldManager();
        return fieldManager.isFieldProviderType(2);
    }

    @Override
    public void insertEditField(Writer w_p, OwFieldDefinition fieldDef_p, OwField field_p, String strID_p) throws Exception {
        if (this.isVolatileNote()) {
            this.insertVolatileEditField(w_p, fieldDef_p, field_p, strID_p);
        } else {
            this.insertPersistedEditField(w_p, fieldDef_p, field_p, strID_p);
        }
    }

    private boolean shouldShowNewNotesAtTheEndOfField() throws Exception {
        boolean showNewNotesAtTheEnd = true;
        OwSettingsProperty prop = ((OwMainAppContext)this.getContext()).getConfiguration().getSettings().getProperty("com.wewebu.ow.Workdesk", "DisplayNewNoteAtTheEnd");
        if (prop != null) {
            showNewNotesAtTheEnd = (Boolean)prop.getValue();
        }
        return showNewNotesAtTheEnd;
    }

    private void renderNotesContent(Writer w_p, OwNoteDataModel noteDataModel_p, boolean showNewNotesAtTheEnd_p) throws IOException {
        String notesContainerStyle = "notesContainer";
        String noteHeaderStyle = "noteHeader";
        String noteContentStyle = "noteContent";
        String noteResumeeStyle = "noteResumee";
        if (this.getFieldManager().isFieldProviderType(128)) {
            notesContainerStyle = "notesContainer_short";
            noteHeaderStyle = "noteHeader_short";
            noteContentStyle = "noteContent_short";
        }
        w_p.write("     <div class=\"" + notesContainerStyle + "\">\n");
        List notes = noteDataModel_p.getNotes();
        if (noteDataModel_p.shouldShortenNotes()) {
            notes = noteDataModel_p.getShortenedNotes();
            if (showNewNotesAtTheEnd_p) {
                this.appendNoteNotDisplayedSymbol(w_p, noteDataModel_p, noteResumeeStyle);
            }
        }
        for (int i = 0; i < notes.size(); ++i) {
            w_p.write("     <div class=\"" + noteHeaderStyle + "\"> \n");
            OwNote note = (OwNote)notes.get(i);
            OwHTMLHelper.writeSecureHTML(w_p, note.getHeader(), true);
            w_p.write("     </div>");
            w_p.write("     <div class=\"" + noteContentStyle + "\">\n");
            String[] lines = note.getContentLines();
            for (int j = 0; j < lines.length; ++j) {
                OwHTMLHelper.writeSecureHTML(w_p, lines[j], true);
                w_p.write("<br/>\n");
            }
            w_p.write("     </div>\n");
        }
        if (!showNewNotesAtTheEnd_p && noteDataModel_p.shouldShortenNotes()) {
            this.appendNoteNotDisplayedSymbol(w_p, noteDataModel_p, noteResumeeStyle);
        }
        w_p.write("     </div>\n");
    }

    private void appendNoteNotDisplayedSymbol(Writer w_p, OwNoteDataModel noteDataModel_p, String noteResumeeStyle_p) throws IOException {
        if (!noteDataModel_p.isLastNoteShortened() || noteDataModel_p.getNumberOfNotes() > 1) {
            w_p.write("<div class=\"" + noteResumeeStyle_p + "\">");
            w_p.write("...");
            w_p.write("</div>");
        }
    }

    private String getHiddenNotesControlId(String strID_p) {
        return strID_p + "_hidden";
    }

    @Override
    public void insertReadOnlyField(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        String oldNotes = (String)value_p;
        boolean showNewNotesAtTheEnd = this.shouldShowNewNotesAtTheEndOfField();
        OwNoteDataModel noteDataModel = new OwNoteDataModel(this.getContext().getLocale(), oldNotes, showNewNotesAtTheEnd);
        if (!this.getFieldManager().isFieldProviderType(128)) {
            this.renderNotesContent(w_p, noteDataModel, showNewNotesAtTheEnd);
        } else {
            noteDataModel.setShortenThreshold(200);
            this.renderNotesContent(w_p, noteDataModel, showNewNotesAtTheEnd);
        }
    }

    protected Object updatePersistedField(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        String noteToBeAppended = request_p.getParameter(strID_p);
        String oldNotes = request_p.getParameter(strID_p + "_hidden");
        String resultValue = null;
        if (noteToBeAppended != null && noteToBeAppended.length() != 0) {
            OwNoteDataModel noteDataModel = new OwNoteDataModel(this.getContext().getLocale(), oldNotes);
            if (fieldDef_p != null && fieldDef_p.getMaxValue() != null && fieldDef_p.getMaxValue() instanceof Integer) {
                noteDataModel.setMaxSize((Integer)fieldDef_p.getMaxValue());
            }
            if (noteToBeAppended.length() > 0) {
                try {
                    String currentUser = ((OwMainAppContext)this.getContext()).getNetwork().getCredentials().getUserInfo().getUserLongName();
                    SimpleDateFormat dateFormat = new SimpleDateFormat(((OwMainAppContext)this.getContext()).getDateFormatString());
                    String timestamp = dateFormat.format(new Date());
                    OwNote note = new OwNote(this.getContext().getLocale(), currentUser, timestamp, noteToBeAppended);
                    noteDataModel.appendNote(note);
                }
                catch (Exception e) {
                    this.m_errorCauseMap.put(strID_p, noteToBeAppended);
                    throw e;
                }
            }
            resultValue = noteDataModel.getTrimmedText();
        } else if (oldNotes != null) {
            OwNoteDataModel noteDataModel = new OwNoteDataModel(this.getContext().getLocale(), oldNotes);
            resultValue = noteDataModel.getTrimmedText();
        }
        return resultValue;
    }

    protected Object updateVolatileField(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        String theNote = request_p.getParameter(strID_p);
        return theNote;
    }

    @Override
    public Object updateField(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        if (this.isVolatileNote()) {
            return this.updateVolatileField(request_p, fieldDef_p, value_p, strID_p);
        }
        return this.updatePersistedField(request_p, fieldDef_p, value_p, strID_p);
    }

    public static class OwNoteDataModel {
        public static final String NOTE_DELIMITER = "\n ";
        public static final String NOTE_DELIMITER_REGEXP = "\\n +";
        private static final String OLD_NOTE_DELIMITER = "\\n\\n";
        private static final int NO_MAX_SIZE_SET = Integer.MIN_VALUE;
        private String m_noteRawContent;
        private List m_notes;
        private int m_maxSize = Integer.MIN_VALUE;
        private int m_shortenThreshold = Integer.MIN_VALUE;
        private Locale m_locale;
        private boolean m_isLastNoteShortened = false;
        private boolean m_showNewNotesAtTheEnd = true;
        private boolean isNullContent = false;

        public OwNoteDataModel(Locale locale_p, String noteContent_p) throws OwNoteException {
            this.m_locale = locale_p;
            this.m_noteRawContent = noteContent_p;
            this.m_notes = new LinkedList();
            boolean bl = this.isNullContent = noteContent_p == null;
            if (this.m_noteRawContent != null && this.m_noteRawContent.trim().length() != 0) {
                this.buildNotes();
            }
        }

        public OwNoteDataModel(Locale locale_p, String noteContent_p, boolean showNewNotesAtTheEnd_p) throws OwNoteException {
            this(locale_p, noteContent_p);
            this.m_showNewNotesAtTheEnd = showNewNotesAtTheEnd_p;
        }

        public String getNoteRawContent() {
            return this.m_noteRawContent;
        }

        private void buildNotes() throws OwNoteException {
            block14: {
                String[] lines;
                if (this.m_noteRawContent == null) break block14;
                Pattern p = Pattern.compile("[A-Z0-9._%-]+@[A-Z0-9._%-]+\\.[A-Z0-9._%-]+\\, [0-9._%-]", 2);
                Matcher m = p.matcher(this.m_noteRawContent);
                boolean isOldStyle = m.find();
                if (!isOldStyle) {
                    this.m_noteRawContent = this.m_noteRawContent.replaceAll("[\\n\\n\\n]+", "\n");
                }
                String[] rawNotes = this.m_noteRawContent.split(OLD_NOTE_DELIMITER);
                if (!isOldStyle && (lines = this.m_noteRawContent.split("\\n")).length > 0) {
                    int atPosition = lines[0].indexOf("@");
                    int commaPosition = lines[0].indexOf(",");
                    int columnPosition = lines[0].indexOf(":");
                    if (atPosition < commaPosition && commaPosition < columnPosition && lines[0].endsWith(":")) {
                        isOldStyle = true;
                    }
                }
                if (isOldStyle) {
                    this.m_noteRawContent = this.m_noteRawContent.replaceAll(NOTE_DELIMITER_REGEXP, "\n");
                    rawNotes = this.m_noteRawContent.split(OLD_NOTE_DELIMITER);
                }
                if (!isOldStyle) {
                    rawNotes = this.m_noteRawContent.split(NOTE_DELIMITER_REGEXP);
                    for (int i = 0; i < rawNotes.length; ++i) {
                        String rtNote = rawNotes[i];
                        if (rtNote.isEmpty()) continue;
                        OwNote note = OwNote.buildNote(this.m_locale, rawNotes[i]);
                        this.m_notes.add(note);
                    }
                } else {
                    int i;
                    LinkedList<String> mergedNotes = new LinkedList<String>();
                    for (i = 0; i < rawNotes.length; ++i) {
                        if (rawNotes[i].indexOf(64) != -1 && rawNotes[i].indexOf(":") != -1) {
                            mergedNotes.add(rawNotes[i]);
                            continue;
                        }
                        if (mergedNotes.isEmpty()) {
                            mergedNotes.add(rawNotes[i]);
                            continue;
                        }
                        String lastNote = (String)mergedNotes.get(mergedNotes.size() - 1);
                        lastNote = lastNote + "\n" + rawNotes[i];
                        mergedNotes.set(mergedNotes.size() - 1, lastNote);
                    }
                    for (i = 0; i < mergedNotes.size(); ++i) {
                        try {
                            OwNote note = OwNote.buildNoteFromOldContent(this.m_locale, (String)mergedNotes.get(i));
                            this.m_notes.add(note);
                            continue;
                        }
                        catch (OwNoteException e) {
                            if (!this.m_notes.isEmpty()) {
                                OwNote lastNote = (OwNote)this.m_notes.get(this.m_notes.size() - 1);
                                lastNote.appendContent(rawNotes[i]);
                                continue;
                            }
                            throw e;
                        }
                    }
                }
            }
        }

        public boolean isNullContent() {
            return this.isNullContent;
        }

        public void appendNote(OwNote note_p) throws OwNoteException {
            boolean shouldAddNote = true;
            if (this.m_maxSize != Integer.MIN_VALUE) {
                int possibleSize;
                if (note_p.getSize() > this.m_maxSize) {
                    shouldAddNote = false;
                }
                if (shouldAddNote && (possibleSize = this.getSize() + note_p.getSize()) > this.m_maxSize) {
                    do {
                        this.m_notes.remove(0);
                    } while ((possibleSize = this.getSize() + note_p.getSize()) > this.m_maxSize);
                }
            }
            if (!shouldAddNote) {
                throw new OwNoteException(OwString.localize1(this.m_locale, "app.OwFieldManagerControlNote.note_is_too_big", "The text of the note is too long by %1 characters.", "" + Math.abs(this.m_maxSize - note_p.getSize() - this.getSize())));
            }
            this.m_notes.add(note_p);
            this.isNullContent = false;
        }

        public int getSize() {
            return this.getTrimmedText().length();
        }

        public List getNotes() {
            LinkedList result = new LinkedList();
            for (Object object : this.m_notes) {
                result.add(object);
            }
            if (!this.m_showNewNotesAtTheEnd) {
                Collections.reverse(result);
            }
            return result;
        }

        public String getTrimmedText() {
            StringBuffer buff = new StringBuffer();
            for (OwNote note : this.m_notes) {
                buff.append(note.toString());
            }
            return buff.toString();
        }

        public int getNumberOfNotes() {
            return this.m_notes.size();
        }

        public OwNote getNote(int index_p) {
            return index_p < 0 || index_p > this.getNotes().size() - 1 ? null : (OwNote)this.getNotes().get(index_p);
        }

        public boolean isLastNoteShortened() {
            return this.m_isLastNoteShortened;
        }

        public String toString() {
            return this.getTrimmedText();
        }

        public void setMaxSize(int maxSize_p) {
            if (maxSize_p < 0) {
                throw new IllegalArgumentException(OwString.localize(this.m_locale, "app.OwFieldManagerControlNote.invalid_note_maxsize", "The note content size is invalid."));
            }
            this.m_maxSize = maxSize_p;
        }

        public void setShortenThreshold(int shortenThreshold_p) {
            if (shortenThreshold_p < 0) {
                throw new IllegalArgumentException(OwString.localize(this.m_locale, "app.OwFieldManagerControlNote.invalid_note_threshold", "The maximal size of chars a note can have (threshold) is invalid."));
            }
            this.m_shortenThreshold = shortenThreshold_p;
        }

        public boolean shouldShortenNotes() {
            boolean result = false;
            if (this.m_shortenThreshold != Integer.MIN_VALUE && this.getSize() > this.m_shortenThreshold) {
                result = true;
            }
            return result;
        }

        public List getShortenedNotes() {
            OwNote note;
            LinkedList<OwNote> result = new LinkedList<OwNote>();
            List currentNotes = this.m_notes;
            int size = 0;
            for (int i = currentNotes.size() - 1; i >= 0 && (size += (note = (OwNote)currentNotes.get(i)).getSize()) <= this.m_shortenThreshold; --i) {
                result.add(note);
            }
            if (result.isEmpty() && !currentNotes.isEmpty()) {
                OwNote lastNote = (OwNote)currentNotes.get(currentNotes.size() - 1);
                lastNote.setShouldShortenNote(true);
                lastNote.setShortenThreshold(this.m_shortenThreshold);
                this.m_isLastNoteShortened = true;
                result.add(lastNote);
            }
            if (this.m_showNewNotesAtTheEnd) {
                Collections.reverse(result);
            }
            return result;
        }
    }

    public static class OwNote {
        private String m_user;
        private String m_timestamp;
        private String m_content;
        private Locale m_locale;
        private boolean m_shouldShortenNote;
        private int m_shortenThreshold_p;

        public OwNote(Locale locale_p, String user_p, String timestamp_p, String content_p) {
            this.m_locale = locale_p;
            if (user_p == null || timestamp_p == null) {
                throw new IllegalArgumentException(OwString.localize(this.m_locale, "app.OwFieldManagerControlNote.cannot_create_note", "Cannot create note. The user and/or the time stamp should not be null."));
            }
            this.m_user = user_p;
            this.m_timestamp = timestamp_p;
            this.m_content = content_p.replaceAll("\\n +", "\n");
            this.m_content = this.m_content.replaceAll("\\n+", "\n");
            this.m_content = this.m_content.replaceAll("[\\r\\n]+", "\n");
            if (this.m_content.endsWith("\n")) {
                this.m_content = this.m_content.substring(0, this.m_content.length() - 1);
            }
            if (this.m_content.startsWith("\n")) {
                this.m_content = this.m_content.length() > 1 ? this.m_content.substring(1) : "";
            }
        }

        public boolean equals(Object o_p) {
            if (o_p instanceof OwNote) {
                OwNote convertedNote = (OwNote)o_p;
                return this.m_user.equals(convertedNote.m_user) && this.m_timestamp.equals(convertedNote.m_timestamp);
            }
            return false;
        }

        public int hashCode() {
            return this.m_user.hashCode() + this.m_timestamp.hashCode();
        }

        public String getFormatedNote() {
            StringBuffer formatedNote = new StringBuffer(this.m_user);
            formatedNote.append("\n");
            formatedNote.append(this.m_timestamp);
            formatedNote.append("\n");
            formatedNote.append(this.m_content);
            formatedNote.append("\n ");
            return formatedNote.toString();
        }

        public String getHeader() {
            return this.m_user + "\n" + this.m_timestamp + "\n";
        }

        public int getSize() {
            return this.getFormatedNote().length();
        }

        public void appendContent(String content_p) {
            if (content_p != null) {
                this.m_content = this.m_content + "\n" + content_p;
            }
        }

        public String[] getContentLines() {
            String content = this.m_content;
            if (this.m_shouldShortenNote && this.m_shortenThreshold_p >= 1 && this.m_shortenThreshold_p < this.m_content.length()) {
                String shortenedContent = this.m_content.substring(0, this.m_shortenThreshold_p - 1);
                content = shortenedContent + "\n...";
            }
            String[] result = content.split("\n");
            return result;
        }

        public static OwNote buildNote(Locale locale_p, String rawNoteText_p) throws OwNoteException {
            if (rawNoteText_p == null) {
                throw new IllegalArgumentException(OwString.localize(locale_p, "app.OwFieldManagerControlNote.invalid_note_content", "The note content should not be null."));
            }
            rawNoteText_p = rawNoteText_p.replaceAll("\\n +", "\n");
            rawNoteText_p = rawNoteText_p.replaceAll("\\n+", "\n");
            rawNoteText_p = rawNoteText_p.replaceAll("[\\r\\n]+", "\n");
            String[] noteItems = rawNoteText_p.split("\n");
            String user = "";
            String date = "";
            String noteContent = "";
            if (noteItems.length > 1) {
                if (noteItems.length <= 2) {
                    user = noteItems[0];
                    date = noteItems[1];
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("OwFieldManagerControlNote.buildNote: Unable to recongnize the m_user and m_timestamp pattern. We will create a note with empty m_user and m_timestamp! Note Text:" + rawNoteText_p));
                    }
                } else {
                    user = noteItems[0];
                    date = noteItems[1];
                    String noteHeader = noteItems[0] + "\n" + noteItems[1] + "\n";
                    if (noteHeader.length() > rawNoteText_p.length()) {
                        user = "";
                        date = "";
                        noteContent = rawNoteText_p;
                    } else {
                        noteContent = rawNoteText_p.substring(noteHeader.length());
                    }
                }
            } else {
                noteContent = rawNoteText_p;
            }
            return new OwNote(locale_p, user, date, noteContent);
        }

        public static OwNote buildNoteFromOldContent(Locale locale_p, String rawNoteText_p) throws OwNoteException {
            if (rawNoteText_p == null) {
                throw new IllegalArgumentException(OwString.localize(locale_p, "app.OwFieldManagerControlNote.invalid_note_content", "The note content should not be null."));
            }
            rawNoteText_p = rawNoteText_p.replaceAll("\\n +", "\n");
            rawNoteText_p = rawNoteText_p.replaceAll("\\n+", "\n");
            rawNoteText_p = rawNoteText_p.replaceAll("[\\r\\n]+", "\n");
            String[] noteItems = rawNoteText_p.split("\n");
            String user = "";
            String timestamp = "";
            String noteContent = "";
            if (noteItems.length < 2) {
                noteContent = rawNoteText_p;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("OwFieldManagerControlNote.buildNoteFromOldContent: Unable to recongnize the m_user and m_timestamp pattern. We will create a note with empty m_user and m_timestamp! Note Text:" + rawNoteText_p));
                }
            } else {
                String header = noteItems[0];
                String[] tokens = header.split(",");
                if (tokens.length == 2) {
                    user = tokens[0].trim();
                    timestamp = tokens[1].trim().substring(0, tokens[1].lastIndexOf(":") - 1);
                }
                noteContent = rawNoteText_p;
                if (rawNoteText_p.indexOf(header) >= 0 && header.length() < rawNoteText_p.length()) {
                    noteContent = rawNoteText_p.substring(header.length() + 1);
                } else {
                    user = "";
                    timestamp = "";
                }
            }
            return new OwNote(locale_p, user, timestamp, noteContent);
        }

        public String toString() {
            return this.getFormatedNote();
        }

        public void setShouldShortenNote(boolean shouldShortNote_p) {
            this.m_shouldShortenNote = shouldShortNote_p;
        }

        public void setShortenThreshold(int threshold_p) {
            this.m_shortenThreshold_p = threshold_p;
        }
    }

    public static class OwNoteException
    extends OwException {
        private static final long serialVersionUID = -2878894039716647164L;

        public OwNoteException(String strMessage_p) {
            super(strMessage_p);
        }

        @Override
        public String getModulName() {
            return "OECM";
        }
    }
}

