/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.fieldctrlimpl;

import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwDefaultComboItem;
import com.wewebu.ow.server.app.OwDefaultComboModel;
import com.wewebu.ow.server.app.OwFieldManagerControl;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.fieldctrlimpl.OwNextDaysDate;
import com.wewebu.ow.server.fieldctrlimpl.OwRelativeDate;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwString1;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwNextDaysDateControl
extends OwFieldManagerControl {
    private static final Logger LOG = OwLogCore.getLogger(OwNextDaysDateControl.class);
    private DateFormat m_DateFormat;
    private static final Map TRANSLATION_KEYS = new LinkedHashMap();
    private static final Map DEFAULT_TRANSLATION_VALUES = new LinkedHashMap();

    private static void addKeyValue(int value_p, String translationKey_p, String defaultTranslationValue_p) {
        Integer intValue = value_p;
        TRANSLATION_KEYS.put(intValue, translationKey_p);
        DEFAULT_TRANSLATION_VALUES.put(intValue, defaultTranslationValue_p);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.m_DateFormat = new SimpleDateFormat(((OwMainAppContext)this.getContext()).getDateFormatString());
    }

    @Override
    public void insertEditField(Writer w_p, OwFieldDefinition fieldDef_p, OwField field_p, String strID_p) throws Exception {
        int iSelectedKey;
        block6: {
            iSelectedKey = 0;
            try {
                Object value = field_p.getValue();
                if (value == null) {
                    OwFieldDefinition fieldDefinition = field_p.getFieldDefinition();
                    value = fieldDefinition.getDefaultValue();
                }
                if (value != null && value instanceof OwRelativeDate) {
                    iSelectedKey = ((OwRelativeDate)value).getSelectedKey();
                    break block6;
                }
                if (value == null) break block6;
                if (value instanceof Date) {
                    Date dateValue = (Date)value;
                    OwNextDaysDate nextDaysValue = new OwNextDaysDate(dateValue.getTime());
                    iSelectedKey = nextDaysValue.getSelectedKey();
                    break block6;
                }
                OwAppContext context = this.getContext();
                OwFieldDefinition definition = field_p.getFieldDefinition();
                String message = "Incompatible field value class " + value.getClass() + " for field " + definition.getClassName() + " with name " + definition.getDisplayName(context.getLocale());
                LOG.error((Object)("OwNextDaysDateControl.insertEditField(): " + message));
                throw new OwInvalidOperationException(message);
            }
            catch (Exception e) {
                OwAppContext context = this.getContext();
                OwFieldDefinition definition = field_p.getFieldDefinition();
                LOG.error((Object)"OwNextDaysDateControl.insertEditField(): could not create edit field", (Throwable)e);
                throw new OwInvalidOperationException(new OwString1("app.OwFieldManager.errorForField", "Error for field %1:", definition.getDisplayName(context.getLocale())), (Throwable)e);
            }
        }
        LinkedList<OwDefaultComboItem> items = new LinkedList<OwDefaultComboItem>();
        Set keys = TRANSLATION_KEYS.keySet();
        for (Integer key : keys) {
            String tranlationKey = (String)TRANSLATION_KEYS.get(key);
            String defaultValue = (String)DEFAULT_TRANSLATION_VALUES.get(key);
            String displayValue = this.getContext().localize(tranlationKey, defaultValue);
            items.add(new OwDefaultComboItem(key.toString(), displayValue));
        }
        OwDefaultComboModel model = new OwDefaultComboModel(false, false, "" + iSelectedKey, items);
        OwComboboxRenderer renderer = ((OwMainAppContext)this.getContext()).createComboboxRenderer(model, strID_p, null, null, null);
        renderer.renderCombo(w_p);
    }

    @Override
    public void insertReadOnlyField(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        if (null != value_p) {
            w_p.write(this.m_DateFormat.format((Date)value_p));
        }
    }

    @Override
    public Object updateField(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        int iKey = Integer.parseInt(request_p.getParameter(strID_p));
        return new OwNextDaysDate(iKey);
    }

    static {
        OwNextDaysDateControl.addKeyValue(0, "fieldctrlimpl.OwNextDaysDateControl.nexttoday", "today");
        OwNextDaysDateControl.addKeyValue(7, "fieldctrlimpl.OwNextDaysDateControl.nextoneday", "tomorrow");
        OwNextDaysDateControl.addKeyValue(8, "fieldctrlimpl.OwNextDaysDateControl.nexttwodays", "next two days");
        OwNextDaysDateControl.addKeyValue(9, "fieldctrlimpl.OwNextDaysDateControl.nextoneweek", "next week");
        OwNextDaysDateControl.addKeyValue(10, "fieldctrlimpl.OwNextDaysDateControl.nexttwoweeks", "next two weeks");
        OwNextDaysDateControl.addKeyValue(11, "fieldctrlimpl.OwNextDaysDateControl.next30days", "next 30 days");
        OwNextDaysDateControl.addKeyValue(12, "fieldctrlimpl.OwNextDaysDateControl.next90days", "next 90 days");
    }
}

