/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.fieldctrlimpl;

import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwDateTimeUtil;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwRelativeDate
extends Date {
    private static final Logger LOG = OwLogCore.getLogger(OwRelativeDate.class);
    public static final int KEY_EMPTY_FIELD = -1;
    public static final int KEY_TODAY = 0;
    public static final int KEY_LAST_ONE_DAY = 1;
    public static final int KEY_LAST_TWO_DAYS = 2;
    public static final int KEY_LAST_ONE_WEEK = 3;
    public static final int KEY_LAST_TWO_WEEKS = 4;
    public static final int KEY_LAST_30_DAYS = 5;
    public static final int KEY_LAST_90_DAYS = 6;
    public static final int KEY_NEXT_ONE_DAY = 7;
    public static final int KEY_NEXT_TWO_DAYS = 8;
    public static final int KEY_NEXT_ONE_WEEK = 9;
    public static final int KEY_NEXT_TWO_WEEKS = 10;
    public static final int KEY_NEXT_30_DAYS = 11;
    public static final int KEY_NEXT_90_DAYS = 12;
    private static final long serialVersionUID = 178353404736157334L;
    private static final Map STRING_TRANSLATION_KEYS = new LinkedHashMap();
    private int m_iSelectedKey = 0;

    private static final String normalizeStringValue(String value_p) {
        value_p = value_p == null ? "" : value_p.trim().toLowerCase();
        return value_p.replaceAll("\\s+", " ");
    }

    public static OwRelativeDate fromString(String string_p) throws OwInvalidOperationException {
        Integer intValue = (Integer)STRING_TRANSLATION_KEYS.get(OwRelativeDate.normalizeStringValue(string_p));
        if (intValue != null) {
            return new OwRelativeDate(intValue);
        }
        LOG.error((Object)("OwRelativeDate.fromString(): Invalid OwRelativeDate string : " + string_p));
        throw new OwInvalidOperationException("Invalid relative-date string : " + string_p);
    }

    public OwRelativeDate(int iKey_p) {
        this.m_iSelectedKey = iKey_p;
        switch (iKey_p) {
            case 0: {
                this.setTimeInPast(0);
                break;
            }
            case 7: {
                this.setTimeInFuture(1);
                break;
            }
            case 8: {
                this.setTimeInFuture(2);
                break;
            }
            case 9: {
                this.setTimeInFuture(7);
                break;
            }
            case 10: {
                this.setTimeInFuture(14);
                break;
            }
            case 11: {
                this.setTimeInFuture(30);
                break;
            }
            case 12: {
                this.setTimeInFuture(90);
                break;
            }
            case 1: {
                this.setTimeInPast(1);
                break;
            }
            case 2: {
                this.setTimeInPast(2);
                break;
            }
            case 3: {
                this.setTimeInPast(7);
                break;
            }
            case 4: {
                this.setTimeInPast(14);
                break;
            }
            case 5: {
                this.setTimeInPast(30);
                break;
            }
            case 6: {
                this.setTimeInPast(90);
            }
        }
    }

    public OwRelativeDate(long timestamp_p) {
        long today = System.currentTimeMillis();
        long days = (timestamp_p - today) / 86400000L;
        if (days <= 0L) {
            if ((days = -days) == 0L) {
                this.m_iSelectedKey = 0;
                this.setTimeInPast(0);
            } else if (days == 1L) {
                this.m_iSelectedKey = 1;
                this.setTimeInPast(1);
            } else if (days == 2L) {
                this.m_iSelectedKey = 2;
                this.setTimeInPast(2);
            } else if (days > 2L && days <= 7L) {
                this.m_iSelectedKey = 3;
                this.setTimeInPast(7);
            } else if (days > 7L && days <= 14L) {
                this.m_iSelectedKey = 4;
                this.setTimeInPast(14);
            } else if (days > 14L && days <= 30L) {
                this.m_iSelectedKey = 5;
                this.setTimeInPast(30);
            } else if (days > 30L) {
                this.m_iSelectedKey = 6;
                this.setTimeInPast(90);
            }
        } else if (days == 1L) {
            this.m_iSelectedKey = 7;
            this.setTimeInFuture(1);
        } else if (days == 2L) {
            this.m_iSelectedKey = 8;
            this.setTimeInFuture(2);
        } else if (days > 2L && days <= 7L) {
            this.m_iSelectedKey = 9;
            this.setTimeInFuture(7);
        } else if (days > 7L && days <= 14L) {
            this.m_iSelectedKey = 10;
            this.setTimeInFuture(14);
        } else if (days > 14L && days <= 30L) {
            this.m_iSelectedKey = 11;
            this.setTimeInFuture(30);
        } else if (days > 30L) {
            this.m_iSelectedKey = 12;
            this.setTimeInFuture(90);
        }
    }

    private void setTimeInFuture(int days_p) {
        Date d = new Date();
        d = OwDateTimeUtil.setBeginOfDayTime(d);
        d = OwDateTimeUtil.offsetDay(d, days_p, true);
        this.setTime(d.getTime());
    }

    private void setTimeInPast(int days_p) {
        Date d = new Date();
        d = OwDateTimeUtil.setBeginOfDayTime(d);
        d = OwDateTimeUtil.offsetDay(d, -days_p, true);
        this.setTime(d.getTime());
    }

    public int getSelectedKey() {
        return this.m_iSelectedKey;
    }

    static {
        STRING_TRANSLATION_KEYS.put(OwRelativeDate.normalizeStringValue("today"), 0);
        STRING_TRANSLATION_KEYS.put(OwRelativeDate.normalizeStringValue("tomorrow"), 7);
        STRING_TRANSLATION_KEYS.put(OwRelativeDate.normalizeStringValue("next two days"), 8);
        STRING_TRANSLATION_KEYS.put(OwRelativeDate.normalizeStringValue("next week"), 9);
        STRING_TRANSLATION_KEYS.put(OwRelativeDate.normalizeStringValue("next two weeks"), 10);
        STRING_TRANSLATION_KEYS.put(OwRelativeDate.normalizeStringValue("next 30 days"), 11);
        STRING_TRANSLATION_KEYS.put(OwRelativeDate.normalizeStringValue("next 90 days"), 12);
        STRING_TRANSLATION_KEYS.put(OwRelativeDate.normalizeStringValue("yesterday"), 1);
        STRING_TRANSLATION_KEYS.put(OwRelativeDate.normalizeStringValue("last two days"), 2);
        STRING_TRANSLATION_KEYS.put(OwRelativeDate.normalizeStringValue("last week"), 3);
        STRING_TRANSLATION_KEYS.put(OwRelativeDate.normalizeStringValue("last two weeks"), 4);
        STRING_TRANSLATION_KEYS.put(OwRelativeDate.normalizeStringValue("last 30 days"), 5);
        STRING_TRANSLATION_KEYS.put(OwRelativeDate.normalizeStringValue("last 90 days"), 6);
    }
}

