/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.fieldctrlimpl.dynamic;

import com.wewebu.ow.server.app.OwComboItem;
import com.wewebu.ow.server.app.OwDefaultComboItem;
import com.wewebu.ow.server.ecm.OwRepositoryContext;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.fieldctrlimpl.dynamic.OwDependentComboboxDataHandler;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwDataSourceUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.InvalidResultSetAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public class OwDBDependentComboboxDataHandler
implements OwDependentComboboxDataHandler {
    private static final Logger LOG = OwLogCore.getLogger(OwDBDependentComboboxDataHandler.class);
    protected static final String EL_DATA_SOURCE = "DataSource";
    protected static final String AT_SELECT_ALL = "selectAll";
    protected static final String EL_QUERY = "Query";
    protected static final String EL_PROPERTY = "Property";
    protected static final String AT_PROP_QUERY_NAME = "queryName";
    protected static final String AT_PROP_OPERATOR = "operator";
    private OwXMLUtil conf;
    private JdbcTemplate template;
    private String query;
    private Map<String, OwWherePropDefinition> dependentData;
    private OwAppContext context;
    private boolean selectAll;

    @Override
    public void init(OwAppContext context, OwXMLUtil configuration) throws OwException {
        OwXMLUtil queryConf;
        this.setConf(configuration);
        this.context = context;
        String dataSourceName = this.getConf().getSafeTextValue(EL_DATA_SOURCE, null);
        if (dataSourceName != null) {
            DataSource dataSource = OwDataSourceUtil.retrieveDataSource(dataSourceName);
            this.setTemplate(OwDataSourceUtil.createJdbcTemplate(dataSource));
        } else {
            OwRepositoryContext repoCtx = context.getRegisteredInterface(OwRepositoryContext.class);
            if (repoCtx != null) {
                this.setTemplate(repoCtx.getJDBCTemplate());
            }
        }
        if (this.getTemplate() == null) {
            throw new OwConfigurationException("OwDBDependentComboboxDataHandler.init: No JDBC connection available, check config node = DataSource");
        }
        try {
            queryConf = this.getConf().getSubUtil(EL_QUERY);
            this.query = this.getConf().getSafeTextValue(EL_QUERY, null);
        }
        catch (Exception e) {
            throw new OwConfigurationException("OwDBDependentComboboxDataHandler.init: Missing query definition, check configuration of node = Query", (Throwable)e);
        }
        if (this.query == null) {
            throw new OwConfigurationException("OwDBDependentComboboxDataHandler.init: Missing query definition, check configuration of node = Query");
        }
        this.selectAll = queryConf.getSafeBooleanAttributeValue(AT_SELECT_ALL, false);
        Iterator propIt = this.getConf().getSafeUtilList(EL_PROPERTY).iterator();
        this.dependentData = new LinkedHashMap<String, OwWherePropDefinition>();
        while (propIt.hasNext()) {
            OwXMLUtil propUtil = (OwXMLUtil)propIt.next();
            String fieldMapping = propUtil.getSafeTextValue(null);
            if (fieldMapping != null) {
                String queryName = propUtil.getSafeStringAttributeValue(AT_PROP_QUERY_NAME, fieldMapping);
                String operator = propUtil.getSafeStringAttributeValue(AT_PROP_OPERATOR, "=");
                this.dependentData.put(fieldMapping, new OwWherePropDefinition(fieldMapping, operator, queryName));
                continue;
            }
            LOG.info((Object)"OwDBDependentComboboxDataHandler.init: Could not read whereProp configuration");
        }
    }

    @Override
    public List<OwComboItem> getData(OwFieldProvider fieldProvider) throws OwException {
        LinkedList<OwComboItem> result = new LinkedList<OwComboItem>();
        LinkedHashMap<String, OwWherePropDefinition> whereDef = new LinkedHashMap<String, OwWherePropDefinition>();
        for (Map.Entry<String, OwWherePropDefinition> prop : this.dependentData.entrySet()) {
            try {
                OwField field = fieldProvider.getField(prop.getKey());
                Object value = field.getValue();
                if (value == null) continue;
                OwWherePropDefinition copy = (OwWherePropDefinition)prop.getValue().clone();
                copy.setValue(value);
                whereDef.put(prop.getKey(), copy);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)("Could not retrieve from provider field with id = " + prop), (Throwable)e);
                    continue;
                }
                LOG.warn((Object)("OwDBDependentComboboxDataHandler.getData: Could not retrieve from provider field with id = " + prop));
            }
        }
        if (!whereDef.isEmpty() || this.selectAll()) {
            String fullQuery = this.createFullQuery(this.query, whereDef);
            this.processRequest(fullQuery, whereDef, result);
        }
        return result;
    }

    protected void processRequest(String query, Map<String, OwWherePropDefinition> whereProps, List<OwComboItem> result) throws OwException {
        ArrayList<Object> values = new ArrayList<Object>();
        for (OwWherePropDefinition whereProp : whereProps.values()) {
            values.add(whereProp.getValue());
        }
        SqlRowSet rowSet = this.getTemplate().queryForRowSet(query, values.toArray());
        if (rowSet.first()) {
            SqlRowSetMetaData rowInfo = rowSet.getMetaData();
            int valueIdx = 1;
            int labelIdx = 1;
            if (rowInfo.getColumnCount() > 1) {
                labelIdx = valueIdx + 1;
                LOG.info((Object)"OwDBDependentComboboxDataHandler.processRequest: contains more than two columns, only first two will be used for value and label representation");
            }
            try {
                do {
                    String value = rowSet.getString(valueIdx);
                    String label = this.getContext().localize("owlabel." + value, rowSet.getString(labelIdx));
                    OwDefaultComboItem item = new OwDefaultComboItem(value, label);
                    result.add(item);
                } while (rowSet.next());
            }
            catch (InvalidResultSetAccessException accessEx) {
                LOG.error((Object)"Cannot process result set", (Throwable)accessEx);
                throw new OwServerException("Could not process resulting set", (Throwable)accessEx);
            }
        }
    }

    protected String createFullQuery(String query, Map<String, OwWherePropDefinition> whereProps) throws OwException {
        StringBuilder fullQuery = new StringBuilder(query);
        if (!whereProps.isEmpty()) {
            fullQuery.append(" WHERE ");
            Iterator<Map.Entry<String, OwWherePropDefinition>> it = whereProps.entrySet().iterator();
            while (it.hasNext()) {
                OwWherePropDefinition field = it.next().getValue();
                fullQuery.append("( ");
                if (field.getOperator().contains("%s")) {
                    fullQuery.append(String.format(field.getOperator(), field.getQueryName()));
                } else {
                    fullQuery.append(field.getQueryName()).append(" ").append(field.getOperator());
                    fullQuery.append(" ?");
                }
                fullQuery.append(" )");
                if (!it.hasNext()) continue;
                fullQuery.append(" AND ");
            }
        }
        return fullQuery.toString();
    }

    protected OwAppContext getContext() {
        return this.context;
    }

    protected JdbcTemplate getTemplate() {
        return this.template;
    }

    protected void setTemplate(JdbcTemplate template) {
        this.template = template;
    }

    protected OwXMLUtil getConf() {
        return this.conf;
    }

    protected void setConf(OwXMLUtil conf) {
        this.conf = conf;
    }

    @Override
    public List<String> getDependentFieldIds() {
        return new LinkedList<String>(this.dependentData.keySet());
    }

    public boolean selectAll() {
        return this.selectAll;
    }

    public static class OwWherePropDefinition
    implements Cloneable {
        private String queryName;
        private String operator;
        private String fieldMapping;
        private Object value;

        public OwWherePropDefinition(String fieldName, String operator, String queryName) {
            this.queryName = queryName;
            this.operator = operator;
            this.fieldMapping = fieldName;
        }

        public String getQueryName() {
            return this.queryName;
        }

        public String getOperator() {
            return this.operator;
        }

        public String getFieldMapping() {
            return this.fieldMapping;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Object clone() {
            return new OwWherePropDefinition(this.getFieldMapping(), this.getOperator(), this.getQueryName());
        }
    }
}

