/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.fieldimpl.filter;

import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwWildCardDefinition;
import com.wewebu.ow.server.fieldimpl.filter.OwAbstractComparator;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwString;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class OwStringComparator
extends OwAbstractComparator<String> {
    private static final Logger LOG = OwLogCore.getLogger(OwStringComparator.class);

    @Override
    protected boolean matchBetween(OwSearchCriteria filter, String value) {
        return false;
    }

    @Override
    protected boolean matchLessEquals(OwSearchCriteria filter, String value) {
        return false;
    }

    @Override
    protected boolean matchGreaterEquals(OwSearchCriteria filter, String value) {
        return false;
    }

    @Override
    protected boolean matchLess(OwSearchCriteria filter, String value) {
        return false;
    }

    @Override
    protected boolean matchGreater(OwSearchCriteria filter, String value) {
        return false;
    }

    @Override
    protected boolean matchLike(OwSearchCriteria filter, String value) {
        if (filter.getValue() == null || value == null) {
            return filter.getValue() == value;
        }
        StringBuffer val = new StringBuffer((String)filter.getValue());
        OwString.replaceAll(val, ".", "\\.");
        if (filter.getWildCardDefinitions() != null) {
            for (OwWildCardDefinition def : filter.getWildCardDefinitions()) {
                if (def.getType() == 1) {
                    OwString.replaceAll(val, def.getWildCard(), ".*");
                    continue;
                }
                if (def.getType() != 2) continue;
                OwString.replaceAll(val, def.getWildCard(), "\\w");
            }
        }
        if (val.indexOf(".*") < 0) {
            val.append(".*");
            val.insert(0, ".*");
        }
        if (LOG.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer("OwStringComparator.matchLike: defined filter was [");
            msg.append(filter.getValue());
            msg.append("], pattern used for filtering is [");
            msg.append(val);
            LOG.debug((Object)msg.append("]"));
        }
        Pattern p = Pattern.compile(val.toString());
        Matcher m = p.matcher(value);
        return m.matches();
    }

    @Override
    protected boolean matchEquals(OwSearchCriteria filter, String value) {
        String val = (String)filter.getValue();
        if (val == null && value == null) {
            return true;
        }
        if (val != null) {
            return val.equals(value);
        }
        return value.equals(val);
    }
}

