/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.history;

import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.history.OwHistoryObjectChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class OwStandardHistoryObjectChangeEvent
implements OwHistoryObjectChangeEvent {
    private OwObjectReference m_object;
    private Collection m_objects;
    private OwObjectReference m_parent;

    public OwStandardHistoryObjectChangeEvent(OwObjectReference object_p, OwObjectReference parent_p) {
        this.m_object = object_p;
        this.m_parent = parent_p;
    }

    public OwStandardHistoryObjectChangeEvent(Collection objects_p, OwObjectReference parent_p) {
        this.m_objects = objects_p;
        this.m_parent = parent_p;
    }

    @Override
    public String getSummary() throws Exception {
        StringBuffer retString = new StringBuffer();
        if (null != this.m_parent) {
            retString.append(this.m_parent.getName());
            retString.append(": ");
        }
        if (null != this.m_object) {
            retString = retString.append(this.m_object.getName());
        } else if (null != this.m_objects) {
            Iterator it = this.m_objects.iterator();
            while (it.hasNext()) {
                OwObjectReference ref = (OwObjectReference)it.next();
                retString.append(ref.getName());
                if (!it.hasNext()) continue;
                retString.append(", ");
            }
        }
        return retString.toString();
    }

    @Override
    public OwObjectReference getParent() throws Exception {
        return this.m_parent;
    }

    @Override
    public Collection getAffectedObjects() throws Exception {
        if (this.m_object != null) {
            ArrayList<OwObjectReference> retList = new ArrayList<OwObjectReference>();
            retList.add(this.m_object);
            return retList;
        }
        return this.m_objects;
    }
}

