/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.history;

import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.history.OwHistoryObjectDeleteEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class OwStandardHistoryObjectDeleteEvent
implements OwHistoryObjectDeleteEvent {
    private String m_name;
    private Collection m_objectnames;
    private OwObjectReference m_parent;

    public OwStandardHistoryObjectDeleteEvent(String name_p, OwObjectReference parent_p) throws Exception {
        if (name_p == null) {
            throw new NullPointerException("objectnames_p may not be null");
        }
        this.m_name = name_p;
        this.m_parent = parent_p;
    }

    public OwStandardHistoryObjectDeleteEvent(Collection objectnames_p, OwObjectReference parent_p) throws Exception {
        if (objectnames_p == null) {
            throw new NullPointerException("objectnames_p may not be null");
        }
        this.m_objectnames = new ArrayList(objectnames_p.size());
        for (String name : objectnames_p) {
            this.m_objectnames.add(name);
        }
        this.m_parent = parent_p;
    }

    @Override
    public Collection getAffectedObjectNames() throws Exception {
        if (null != this.m_objectnames) {
            return this.m_objectnames;
        }
        if (this.m_name != null) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(this.m_name);
            return ret;
        }
        return null;
    }

    @Override
    public OwObjectReference getParent() throws Exception {
        return this.m_parent;
    }

    @Override
    public String getSummary() throws Exception {
        StringBuffer retString = new StringBuffer();
        if (null != this.m_parent) {
            retString.append(this.m_parent.getName());
            retString.append(": ");
        }
        if (null != this.m_name) {
            retString.append(this.m_name);
        } else if (null != this.m_objectnames) {
            Iterator it = this.m_objectnames.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                retString.append(name);
                if (!it.hasNext()) continue;
                retString.append(", ");
            }
        }
        return retString.toString();
    }
}

