/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.log;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class OwLogCoreBase {
    private static Logger LOG = Logger.getLogger(OwLogCoreBase.class);
    private static Boolean m_useclassLogger = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean readClassLoggerSettings() {
        boolean useClassLogger = false;
        String resource = "/owlog.properties";
        Properties properties = new Properties();
        InputStream resourceAsStream = null;
        String prop = null;
        try {
            resourceAsStream = OwLogCoreBase.class.getResourceAsStream(resource);
            if (resourceAsStream == null) {
                resource = "owlog.properties";
                resourceAsStream = OwLogCoreBase.class.getClassLoader().getResourceAsStream(resource);
            }
            if (resourceAsStream == null) {
                LOG.info((Object)("OwLog settings (package or class logger) file not found: " + resource + " , useClassLogger = " + useClassLogger));
            } else {
                properties.load(resourceAsStream);
                prop = properties.getProperty("use.class.logger");
                if (prop != null && prop.equals("true")) {
                    useClassLogger = true;
                }
            }
        }
        catch (IOException e) {
            LOG.info((Object)("Exception reading the OwLog settings (package or class logger), resource = " + resource + " , useClassLogger = " + useClassLogger), (Throwable)e);
        }
        finally {
            if (resourceAsStream != null) {
                try {
                    resourceAsStream.close();
                }
                catch (IOException e) {}
                resourceAsStream = null;
            }
        }
        return useClassLogger;
    }

    public static synchronized boolean isUseClassLogger() {
        if (m_useclassLogger == null) {
            m_useclassLogger = OwLogCoreBase.readClassLoggerSettings() ? Boolean.TRUE : Boolean.FALSE;
        }
        return m_useclassLogger;
    }

    public static synchronized void reInitializeClassLoggerSettings() {
        m_useclassLogger = null;
    }
}

