/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.servlets;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.ecm.OwFileObject;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.history.OwStandardHistoryObjectChangeEvent;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.servlets.OwAbstractUpload;
import com.wewebu.ow.server.servlets.download.OwHttpContentDisposition;
import com.wewebu.ow.server.util.OwStreamUtil;
import com.wewebu.ow.server.util.OwString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.perf4j.log4j.Log4JStopWatch;
import org.w3c.dom.Node;

public class OwGetContent
extends OwAbstractUpload {
    private static final long serialVersionUID = 8503295237612126309L;
    private static final Logger LOG = OwLogCore.getLogger(OwGetContent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void processRequest(HttpServletRequest request_p, HttpServletResponse response_p) throws ServletException, IOException {
        OwContentElement contentelement;
        block57: {
            Log4JStopWatch stopWatchGetContent = new Log4JStopWatch("OwGetContent", request_p.getParameter("dmsid"));
            HttpSession Session = request_p.getSession();
            OwMainAppContext context = (OwMainAppContext)Session.getAttribute("ow_Context");
            contentelement = null;
            OutputStream out = null;
            InputStream xslInputStream = null;
            InputStream in = null;
            try {
                if (context != null && context.isLogin()) {
                    Transformer transformer;
                    TransformerFactory factory;
                    String strDwlMode = request_p.getParameter("dwlmode");
                    String strDMSID = request_p.getParameter("dmsid");
                    String strContentType = request_p.getParameter("cttyp");
                    String strPage = request_p.getParameter("page");
                    String strXSLTransformatorURL = request_p.getParameter("xsltrans");
                    String strXSLTransformatorEncoding = request_p.getParameter("xslencode");
                    int iDwlMode = 1;
                    if (null != strDwlMode) {
                        iDwlMode = Integer.parseInt(strDwlMode);
                    }
                    int iContentType = 1;
                    if (strContentType != null) {
                        iContentType = Integer.parseInt(strContentType);
                    }
                    int iPage = 1;
                    if (strPage != null) {
                        iPage = Integer.parseInt(strPage);
                    }
                    OwObject downloadObject = null;
                    if (strDMSID.equals("owmimemanagerfilepreview")) {
                        String fullpath = (String)request_p.getSession().getAttribute("OwMimeManager_FilePreview");
                        String fileName = (String)request_p.getSession().getAttribute("OwMimeManager_FileName");
                        String mimeType = (String)request_p.getSession().getAttribute("OwMimeManager_MIMEType");
                        File localFile = new File(fullpath);
                        downloadObject = mimeType != null ? new OwFileObject(context.getNetwork(), localFile, fileName, mimeType) : new OwFileObject(context.getNetwork(), localFile);
                    } else {
                        downloadObject = context.getNetwork().getObjectFromDMSID(strDMSID, false);
                    }
                    stopWatchGetContent.lap("findObject");
                    if (!downloadObject.canGetContent(iContentType, 2)) {
                        String strName = context.localize("app.OwMimeManager.undefname", "[undefiniert]");
                        try {
                            strName = downloadObject.getName().toString();
                            return;
                        }
                        catch (NullPointerException e) {
                            LOG.debug((Object)("You have no permission for accessing this document, documentname = " + strName), (Throwable)e);
                            response_p.getWriter().write(context.localize("servlets.OwGetContent.noaccess", "You have no permission for accessing this document:" + strName));
                            return;
                        }
                    }
                    OwContentCollection contentCollection = downloadObject.getContentCollection();
                    contentelement = contentCollection.getContentElement(iContentType, iPage);
                    if (strXSLTransformatorURL != null) {
                        strXSLTransformatorURL = OwString.replaceAll(strXSLTransformatorURL, "{basedir}", context.getBasePath() + "/");
                        strXSLTransformatorURL = OwString.replaceAll(strXSLTransformatorURL, "{baseurl}", context.getBaseURL() + "/");
                        URL xslUrl = null;
                        xslUrl = !strXSLTransformatorURL.toLowerCase().startsWith("http") ? new URL("file", null, strXSLTransformatorURL) : new URL(strXSLTransformatorURL);
                        xslInputStream = xslUrl.openStream();
                        if (contentelement.getContentRepresentation() == 2) {
                            response_p.setContentType(contentelement.getMIMEType());
                            this.addContentDisposition(request_p, response_p, downloadObject, contentelement, iPage, iDwlMode, iContentType);
                            factory = TransformerFactory.newInstance();
                            out = response_p.getOutputStream();
                            transformer = factory.newTransformer(new StreamSource(xslInputStream));
                            transformer.transform(new StreamSource(new InputStreamReader(contentelement.getContentStream(null), strXSLTransformatorEncoding)), new StreamResult(out));
                            stopWatchGetContent.lap("retrieveAndServeContent:XSL_STREAM");
                        } else {
                            if (contentelement.getContentRepresentation() != 8) {
                                String msg = "OwGetContent.processRequest: Cannot transform content, must be DOM Object or XML Stream.";
                                LOG.error((Object)msg);
                                throw new OwInvalidOperationException(msg);
                            }
                            response_p.setContentType(contentelement.getMIMEType());
                            this.addContentDisposition(request_p, response_p, downloadObject, contentelement, iPage, iDwlMode, iContentType);
                            Node contentNode = (Node)contentelement.getContentObject();
                            TransformerFactory factory2 = TransformerFactory.newInstance();
                            out = response_p.getOutputStream();
                            Transformer transformer2 = factory2.newTransformer(new StreamSource(xslInputStream));
                            transformer2.transform(new DOMSource(contentNode), new StreamResult(out));
                            stopWatchGetContent.lap("retrieveAndServeContent:XSL_OBJECT");
                        }
                    } else if (contentelement.getContentRepresentation() == 4) {
                        PrintWriter writer = response_p.getWriter();
                        writer.write("<html>\n<body>\n" + context.localize("servlets.OwGetContent.uploadlink", "You can load the document here:"));
                        writer.write("<a href=\"" + contentelement.getContentURL() + "\">" + contentelement.getContentURL() + "</a>");
                        writer.write("</body>\n</html>\n");
                        stopWatchGetContent.lap("retrieveAndServeContent:URL");
                    } else if (contentelement.getContentRepresentation() == 2) {
                        if (contentelement.isInputStreamNative()) {
                            in = contentelement.getContentStream(null);
                            response_p.setContentType(contentelement.getMIMEType());
                            this.addContentDisposition(request_p, response_p, downloadObject, contentelement, iPage, iDwlMode, iContentType);
                            out = response_p.getOutputStream();
                            OwStreamUtil.upload(in, out, true);
                        } else {
                            response_p.setContentType(contentelement.getMIMEType());
                            this.addContentDisposition(request_p, response_p, downloadObject, contentelement, iPage, iDwlMode, iContentType);
                            out = response_p.getOutputStream();
                            contentelement.getContentStream(out);
                        }
                        stopWatchGetContent.lap("retrieveAndServeContent:STREAM");
                    } else {
                        if (contentelement.getContentRepresentation() != 8) throw new OwInvalidOperationException("OwGetContent.processRequest: Unknown content.");
                        response_p.setContentType(contentelement.getMIMEType());
                        this.addContentDisposition(request_p, response_p, downloadObject, contentelement, iPage, iDwlMode, iContentType);
                        Node contentNode = (Node)contentelement.getContentObject();
                        factory = TransformerFactory.newInstance();
                        out = response_p.getOutputStream();
                        transformer = factory.newTransformer();
                        transformer.transform(new DOMSource(contentNode), new StreamResult(out));
                        stopWatchGetContent.lap("retrieveAndServeContent:OBJECT");
                    }
                    if (iContentType == 1 && !strDMSID.equals("owmimemanagerfilepreview")) {
                        context.getHistoryManager().addEvent(6, "download", new OwStandardHistoryObjectChangeEvent(downloadObject, null), 1);
                    }
                    break block57;
                }
                PrintWriter writer = response_p.getWriter();
                response_p.setStatus(403);
                response_p.flushBuffer();
                writer.write("<html><head><title>FORBIDDEN ACCESS HTTP-CODE ");
                writer.write(Integer.toString(403));
                writer.write("</title></head><body><h1>ACCESS FORBIDDEN</h1><p>");
                if (context != null) {
                    writer.write(context.localize("servlets.OwGetContent.notlogedin", "ERROR: The document cannot be shown without authentication."));
                } else {
                    writer.write("ERROR: You don't have the permission to view the document, please login to get permission");
                }
                writer.write("</p></body></html>");
                response_p.flushBuffer();
                stopWatchGetContent.lap("retrieveAndServeContent:FORBIDEN");
            }
            catch (Exception e) {
                stopWatchGetContent.lap("failed retrieveAndServeContent", e.getMessage());
                LOG.error((Object)"OwGetContent.processRequest: Error processing the request.", (Throwable)e);
            }
            finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException e) {
                        LOG.debug((Object)"OwGetContent finally block failed ", (Throwable)e);
                    }
                    out = null;
                }
                if (xslInputStream != null) {
                    try {
                        xslInputStream.close();
                    }
                    catch (IOException e) {
                        LOG.debug((Object)"OwGetContent finally block failed ", (Throwable)e);
                    }
                    xslInputStream = null;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LOG.debug((Object)"OwGetContent finally block failed ", (Throwable)e);
                    }
                    in = null;
                }
            }
        }
        if (null == contentelement) return;
        contentelement.releaseResources();
    }

    private void addContentDisposition(HttpServletRequest request_p, HttpServletResponse response_p, OwObject obj_p, OwContentElement content_p, int iPage_p, int iDwlMode_p, int iContentType_p) throws Exception {
        String fileName = this.createFileName(obj_p.getName(), content_p);
        OwHttpContentDisposition contentDisposition = null;
        contentDisposition = iDwlMode_p == 2 ? OwHttpContentDisposition.forRequest(request_p, fileName, OwHttpContentDisposition.OwElementType.ATTACHMENT) : OwHttpContentDisposition.forRequest(request_p, fileName, OwHttpContentDisposition.OwElementType.INLINE);
        response_p.addHeader("Content-Disposition", contentDisposition.toString());
    }

    public String getServletInfo() {
        return "Upload Servlet to retrieve content from the archiv for Alfresco Workdesk.";
    }
}

