/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.servlets;

import com.wewebu.ow.server.app.OwUserOperationDispatch;
import com.wewebu.ow.server.app.OwUserOperationEvent;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.role.OwRoleManagerContext;
import com.wewebu.ow.server.ui.OwAppContext;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.log4j.Logger;

public class OwRequestListener
implements ServletRequestListener,
HttpSessionAttributeListener {
    private static final Logger LOG = OwLogCore.getLogger(OwRequestListener.class);
    protected static final String PREPARE = "owd.prepare";
    protected static final String REQ_PROC_START = "owd.req.start";
    private static List<String> lst = new LinkedList<String>();

    public void requestDestroyed(ServletRequestEvent sre) {
        Long startTime;
        HttpServletRequest req;
        if (sre.getServletRequest() instanceof HttpServletRequest && (req = (HttpServletRequest)sre.getServletRequest()).getSession(false) != null && Boolean.TRUE.equals(req.getAttribute(PREPARE))) {
            OwAppContext context = (OwAppContext)req.getSession(false).getAttribute("ow_Context");
            this.dispatch(OwUserOperationEvent.OwUserOperationType.STOP, context, req.getContextPath());
        }
        if (LOG.isTraceEnabled() && (startTime = (Long)sre.getServletRequest().getAttribute(REQ_PROC_START)) != null) {
            LOG.trace((Object)new StringBuilder("OwRequestListener.requestDestroyed: Request process time (ms) = ").append(System.currentTimeMillis() - startTime));
        }
    }

    public void requestInitialized(ServletRequestEvent sre) {
        if (sre.getServletRequest() instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)sre.getServletRequest();
            if (req.getSession(false) != null && this.isNotificationPath(req.getServletPath())) {
                sre.getServletRequest().setAttribute(PREPARE, (Object)Boolean.TRUE);
                OwAppContext context = (OwAppContext)req.getSession(false).getAttribute("ow_Context");
                this.dispatch(OwUserOperationEvent.OwUserOperationType.START, context, req.getContextPath());
            } else {
                sre.getServletRequest().setAttribute(PREPARE, (Object)Boolean.FALSE);
            }
        }
        if (LOG.isTraceEnabled()) {
            sre.getServletRequest().setAttribute(REQ_PROC_START, (Object)System.currentTimeMillis());
        }
    }

    private void dispatch(OwUserOperationEvent.OwUserOperationType opType, OwAppContext ctx, String appCtx) {
        if (ctx != null) {
            try {
                OwCredentials credentials;
                OwNetwork network = ctx.getRegisteredInterface(OwRoleManagerContext.class).getNetwork();
                OwUserInfo user = null;
                if (network != null && (credentials = network.getCredentials()) != null) {
                    user = credentials.getUserInfo();
                }
                opType.fireAndForget(ctx.getRegisteredInterface(OwUserOperationDispatch.class), user, appCtx);
            }
            catch (Exception e) {
                LOG.error((Object)"Could not dispatch operation-started event.", (Throwable)e);
            }
        }
    }

    protected boolean isNotificationPath(String servletPath) {
        if (servletPath != null) {
            for (String skip : lst) {
                if (!servletPath.startsWith(skip)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void attributeAdded(HttpSessionBindingEvent sbEv) {
        if ("ow_Context".equals(sbEv.getName())) {
            OwAppContext context = (OwAppContext)sbEv.getValue();
            context.getHttpRequest().setAttribute(PREPARE, (Object)Boolean.TRUE);
            this.dispatch(OwUserOperationEvent.OwUserOperationType.START, context, "");
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent sbEv) {
    }

    public void attributeReplaced(HttpSessionBindingEvent sbEv) {
    }

    static {
        lst.add("/js");
        lst.add("/designs");
        lst.add("/applets");
        lst.add("/help");
    }
}

