/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.ao.OwAOProvider;
import com.wewebu.ow.server.app.OwGlobalRegistryContext;
import com.wewebu.ow.server.conf.OwBaseInitializer;
import com.wewebu.ow.server.conf.OwBaseUserInfo;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.servlets.OwServletBaseInitializer;
import com.wewebu.ow.server.ui.OwBaseView;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwDialogManager;
import com.wewebu.ow.server.ui.OwDocument;
import com.wewebu.ow.server.ui.OwEventDescription;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwKeyAction;
import com.wewebu.ow.server.ui.OwKeyEvent;
import com.wewebu.ow.server.ui.OwKeySetting;
import com.wewebu.ow.server.ui.OwMouseAction;
import com.wewebu.ow.server.ui.OwMouseEventDescription;
import com.wewebu.ow.server.ui.OwMouseSetting;
import com.wewebu.ow.server.ui.OwPendingSessionException;
import com.wewebu.ow.server.ui.OwStaticKeySettingsConfiguration;
import com.wewebu.ow.server.ui.OwStaticMouseSettingsConfiguration;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.ui.OwWebApplication;
import com.wewebu.ow.server.ui.viewer.OwInfoProviderRegistry;
import com.wewebu.ow.server.util.OwRequestContext;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwTimeZoneInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public abstract class OwAppContext
extends OwEventTarget
implements OwGlobalRegistryContext {
    private static final String TIME_ZONE = "TIME_ZONE";
    public static final String AJAX_REQUEST_TYPE = "AJAX_REQUEST_TYPE";
    public static final String FULLJS_MARKER = "fulljs:";
    private static final Logger LOG = OwLogCore.getLogger(OwAppContext.class);
    public static final int KEYBOARD_KEY_RETURN = 13;
    public static final int KEYBOARD_KEY_ESC = 27;
    public static final int KEYBOARD_KEY_F1 = 112;
    public static final int KEYBOARD_KEY_F2 = 113;
    public static final int KEYBOARD_KEY_F3 = 114;
    public static final int KEYBOARD_KEY_F4 = 115;
    public static final int KEYBOARD_KEY_F5 = 116;
    public static final int KEYBOARD_KEY_F6 = 117;
    public static final int KEYBOARD_KEY_F7 = 118;
    public static final int KEYBOARD_KEY_F8 = 119;
    public static final int KEYBOARD_KEY_F9 = 120;
    public static final int KEYBOARD_KEY_F10 = 121;
    public static final int KEYBOARD_KEY_F11 = 122;
    public static final int KEYBOARD_KEY_F12 = 123;
    public static final int KEYBOARD_KEY_INS = 45;
    public static final int KEYBOARD_KEY_DEL = 46;
    public static final int KEYBOARD_KEY_POS1 = 36;
    public static final int KEYBOARD_KEY_END = 35;
    public static final int KEYBOARD_KEY_UP = 38;
    public static final int KEYBOARD_KEY_DN = 40;
    public static final int KEYBOARD_KEY_LEFT = 37;
    public static final int KEYBOARD_KEY_RIGHT = 39;
    public static final int KEYBOARD_KEY_PAGE_UP = 33;
    public static final int KEYBOARD_KEY_PAGE_DN = 34;
    public static final int KEYBOARD_KEY_SPACE = 32;
    public static final int KEYBOARD_CTRLKEY_NONE = 0;
    public static final int KEYBOARD_CTRLKEY_SHIFT = 256;
    public static final int KEYBOARD_CTRLKEY_CTRL = 512;
    public static final int KEYBOARD_CTRLKEY_ALT = 1024;
    public static final int KEYBOARD_CTRLKEY_META = 2048;
    public static final String SELECTED_ANCHOR = "selected";
    public static final String MAIN_VIEW_TARGET_ID = "ow_MainView";
    public static final String LOGIN_VIEW_TARGET_ID = "ow_LoginView";
    private static final String DEFAULT_OWAPPSEC = String.valueOf(6);
    public static final String TIME_ZONE_ID_PARAMETER_NAME = "tzID";
    public static final String TIME_ZONE_TRANSITIONS_PARAMETER_NAME = "tzDSTrans";
    public static final String TIME_ZONE_TIME_PARAMETER_NAME = "tzTime";
    public static final String TIME_ZONE_OFFSET_PARAMETER_NAME = "tzOffset";
    public static final String TIME_ZONE_DAYLIGHTSAVINGS_PARAMETER_NAME = "tzDS";
    public static final String TIME_ZONE_NORTHERN_HEMISPHERE_PARAMETER_NAME = "tzNHS";
    public static final String PREPARED_REQUEST_URL = "prepRqURL";
    private ConcurrentHashMap<Class<?>, Object> register;
    protected ServletContext m_ServletContext;
    private String m_strJSPPage;
    private String m_strBaseURL;
    private String m_strBasePath;
    private String m_sServerURL;
    private OwTimeZoneInfo clientTimeZoneInfo = null;
    private static final String EVENT_NAME = "owappevn";
    public static final String INTERNAL_REQUEST_TARGET_ID = "owappiid";
    public static final String EXTERNAL_REQUEST_TARGET_ID = "owappeid";
    private static final String SECURITY_KEY = "owappsec";
    private HashMap<String, OwEventTarget> m_EventTargetMap = new HashMap();
    private HashMap<String, OwEventTarget> m_RequestTargetMap = new HashMap();
    private String m_ExternalRequestQueryString;
    private String m_strCurrentRequestSecurityKey;
    private int m_iKeyGenerator = 0;
    private Set<String> m_jsincludes = new HashSet<String>();
    private final Random m_Random = new Random();
    private Set<OwKeyEvent> m_KeyBoardEvents;
    private Set<OwMouseEventDescription> m_mouseEventDescriptions = new HashSet<OwMouseEventDescription>();
    private boolean m_fPendingSession = false;
    private OwBaseInitializer baseInitializer;
    public static final String RESOURCE_CLASSPATH_PREFIX = "lib#";
    public static final String RESOURCE_DEPLOYMENT_PREFIX = "deploy#";
    public static final String RESOURCE_FILE_PATH_PARAM = "OwResourceFilePath";
    public static final String RESOURCE_FILE_PATH_ENVIRONMENT_VAR_NAME_PARAM = "OwResourceFilePathEnvironmentVarName";
    public static final String CONFIG_STREAM_NAME_PREFIX = "ow";
    public static final String CONFIG_JNDI_SUFFIX = "JNDI";
    private String m_strFocusElementID;
    private String m_DEBUG_current_request_TargetID = "";
    public String m_DEBUG_ActivateViewID = "";
    public String m_DEBUG_NavigationTargetID = "";
    public String m_DEBUG_NavigationEvent = "";

    public OwAppContext() {
        this.generateNewCurrentRequestSecurityKey();
        this.register = new ConcurrentHashMap();
        this.registerInterface(OwGlobalRegistryContext.class, this);
    }

    public Collection<OwKeyEvent> getKeyEvents() {
        return this.m_KeyBoardEvents;
    }

    public synchronized Collection<? extends OwEventDescription> getEventDescriptions() {
        LinkedList<OwMouseEventDescription> allDescriptions = new LinkedList<OwMouseEventDescription>(this.m_mouseEventDescriptions);
        if (this.getKeyEvents() != null) {
            allDescriptions.addAll(0, this.getKeyEvents());
        }
        return allDescriptions;
    }

    public synchronized void registerMouseAction(String actionId, OwString description) throws OwException {
        OwStaticMouseSettingsConfiguration settingsConfiguration = OwStaticMouseSettingsConfiguration.getInstance();
        OwMouseSetting keySetting = settingsConfiguration.getSetting(actionId);
        OwMouseAction mouseAction = keySetting.createAction(description);
        mouseAction.register(this);
    }

    public synchronized void registerMouseEventDescription(OwMouseEventDescription mouseEventDescription) {
        this.m_mouseEventDescriptions.add(mouseEventDescription);
    }

    public void registerKeyEvent(int iKeyCode_p, int iCtrlKey_p, String strEventURL_p, String description_p) throws Exception {
        this.registerKeyFormEvent(iKeyCode_p, iCtrlKey_p, strEventURL_p, null, description_p);
    }

    public synchronized void registerKeyFormEvent(int iKeyCode_p, int iCtrlKey_p, String strEventURL_p, String strFormName_p, String description_p) {
        this.registerKeyEvent(new OwKeyEvent(iKeyCode_p, iCtrlKey_p, strEventURL_p, strFormName_p, description_p));
    }

    public synchronized void registerKeyEvent(OwKeyEvent keyEvent) {
        if (this.m_KeyBoardEvents == null) {
            this.m_KeyBoardEvents = new LinkedHashSet<OwKeyEvent>();
        }
        this.m_KeyBoardEvents.add(keyEvent);
    }

    public synchronized void registerKeyAction(OwKeyAction action) throws OwException {
        action.register(this);
    }

    public synchronized void registerKeyAction(String actionId, String strEventURL, String description) throws OwException {
        this.registerKeyAction(actionId, strEventURL, null, description);
    }

    public synchronized void registerKeyAction(String actionId, String strEventURL, String strFormName, String description) throws OwException {
        OwStaticKeySettingsConfiguration keySettingsConfiguration = OwStaticKeySettingsConfiguration.getInstance();
        OwKeySetting keySetting = keySettingsConfiguration.getSetting(actionId);
        OwKeyAction keyAction = keySetting.createAction(strEventURL, strFormName, description);
        keyAction.register(this);
    }

    public void activateView(String strTargetID_p) throws Exception {
        OwEventTarget Target = this.getEventTarget(strTargetID_p);
        if (Target != null && Target instanceof OwView) {
            ((OwView)Target).activate();
        }
    }

    public abstract OwDialogManager getDialogManager();

    public void closeAllDialogs() throws Exception {
        this.getDialogManager().closeAllDialogs();
    }

    public void openDialog(OwDialog dialogView_p, OwDialog.OwDialogListener listener_p) throws Exception {
        this.getDialogManager().openDialog(dialogView_p, listener_p);
    }

    public void init(OwAppContext oldcontext_p) throws Exception {
        this.attach(this, "OwAppContext");
    }

    public int getTargetCount() {
        return this.m_EventTargetMap.size();
    }

    public HttpServletRequest getHttpRequest() {
        return OwRequestContext.getLocalThreadRequest();
    }

    public HttpServletResponse getHttpResponse() {
        return OwRequestContext.getLocalThreadResponse();
    }

    public ServletContext getHttpServletContext() {
        return this.m_ServletContext;
    }

    public HttpSession getHttpSession() {
        return OwRequestContext.getLocalThreadRequest().getSession();
    }

    public void endRequest() {
        this.m_fPendingSession = false;
    }

    public void beginRequest() throws OwPendingSessionException {
        if (this.m_fPendingSession) {
            throw new OwPendingSessionException("OwAppContext.beginRequest: Prevent concurrent requests.");
        }
        this.m_fPendingSession = true;
        this.clearEvents();
    }

    protected OwBaseInitializer createBaseInitializer(ServletContext context_p) {
        return new OwServletBaseInitializer(context_p);
    }

    public void setRequest(ServletContext context_p, HttpServletRequest request_p, HttpServletResponse response_p) {
        this.m_ServletContext = context_p;
        this.m_sServerURL = this.createServerUrl(request_p);
        if (!this.isAjaxRequest()) {
            this.m_strJSPPage = this.createJspPageUrl(request_p);
            this.m_strBaseURL = this.createBaseUrl(request_p);
        }
        this.baseInitializer = this.createBaseInitializer(context_p);
        this.m_strBasePath = this.baseInitializer.getBasePath();
    }

    @Deprecated
    public static void setLocalThreadRequest(HttpServletRequest request_p) {
    }

    @Deprecated
    public static void setLocalThreadResponse(HttpServletResponse response_p) {
    }

    public void serverSideInclude(String path_p, Writer w_p) throws Exception {
        if (w_p != null) {
            w_p.write("\n<!-- Start JSP [File: ");
            w_p.write(path_p);
            w_p.write("] -->\n\n");
            w_p.flush();
        }
        RequestDispatcher rd = this.m_ServletContext.getRequestDispatcher("/" + path_p);
        rd.include((ServletRequest)OwRequestContext.getLocalThreadRequest(), (ServletResponse)OwRequestContext.getLocalThreadResponse());
        if (w_p != null) {
            w_p.write("\n<!-- End JSP [File: ");
            w_p.write(path_p);
            w_p.write("] -->\n\n");
        }
    }

    public String getInitParameter(String strParamName_p) {
        return this.baseInitializer.getInitParameter(strParamName_p);
    }

    public OwEventTarget getEventTarget(String strName_p) {
        return this.m_EventTargetMap.get(strName_p);
    }

    public void removeTarget(OwEventTarget target_p) {
        this.removeTarget(target_p.getID());
    }

    public void removeTarget(String strID_p) {
        this.m_EventTargetMap.remove(strID_p);
        this.m_RequestTargetMap.remove(strID_p);
    }

    public void registerRequestTarget(OwEventTarget target_p) throws OwException {
        if (null == this.m_EventTargetMap.get(target_p.getID())) {
            throw new OwInvalidOperationException("Can not register request target, register as event target first: " + target_p.getID() + ", " + target_p.toString());
        }
        this.m_RequestTargetMap.put(target_p.getID(), target_p);
    }

    public void unregisterRequestTarget(OwEventTarget target_p) throws OwException {
        if (null == this.m_EventTargetMap.get(target_p.getID())) {
            throw new OwInvalidOperationException("Can not unregister request target, register as event target first: " + target_p.getID() + ", " + target_p.toString());
        }
        this.m_RequestTargetMap.remove(target_p.getID());
    }

    public String registerTarget(OwEventTarget target_p, String strName_p) throws Exception {
        String strKey = strName_p;
        if (strKey == null) {
            ++this.m_iKeyGenerator;
            strKey = String.valueOf(this.m_iKeyGenerator);
        }
        if (this.m_EventTargetMap.get(strKey) != null) {
            throw new Exception("TargetKey already defined: " + strKey);
        }
        this.m_EventTargetMap.put(strKey, target_p);
        return strKey;
    }

    public String getJSPPageURL() {
        return this.m_strJSPPage;
    }

    public InputStream getXMLConfigDoc(String strName_p) throws Exception {
        return this.baseInitializer.getXMLConfigDoc(strName_p);
    }

    public URL getConfigURL(String strName_p) throws Exception {
        return this.baseInitializer.getConfigURL(strName_p);
    }

    protected abstract URL getAppContextResource(String var1);

    public String getBaseURL() {
        return this.m_strBaseURL;
    }

    public String getServerURL() {
        return this.m_sServerURL;
    }

    public String getBasePath() {
        return this.m_strBasePath;
    }

    private void generateNewCurrentRequestSecurityKey() {
        this.m_strCurrentRequestSecurityKey = Boolean.getBoolean("owd.owappsec.disabled") ? DEFAULT_OWAPPSEC : Integer.toHexString(this.m_Random.nextInt());
    }

    public String getFormEventURL(OwEventTarget target_p, String strEventName_p, String strAdditionalParameters_p, String strFormName_p) {
        return OwAppContext.createSubmitLink(strFormName_p, this.getEventURL(target_p, strEventName_p, strAdditionalParameters_p));
    }

    public String getFormEventFunction(OwEventTarget target_p, String strEventName_p, String strAdditionalParameters_p, String strFormName_p) {
        return OwAppContext.createSubmitFunction(strFormName_p, this.getEventURL(target_p, strEventName_p, strAdditionalParameters_p));
    }

    public String getAjaxEventURL(OwEventTarget target_p, String strEventName_p, String strAdditionalParameters_p) {
        StringBuilder buf = new StringBuilder(255);
        buf.append(this.getBaseURL());
        buf.append("/owajax.jsp");
        buf.append("?");
        buf.append(EVENT_NAME);
        buf.append("=");
        buf.append(strEventName_p);
        buf.append("&");
        buf.append(INTERNAL_REQUEST_TARGET_ID);
        buf.append("=");
        buf.append(target_p.getID());
        if (strAdditionalParameters_p != null) {
            buf.append("&");
            buf.append(strAdditionalParameters_p);
        }
        return buf.toString();
    }

    public String getEventURL(OwEventTarget target_p, String strEventName_p, String strAdditionalParameters_p) {
        StringBuilder buf = new StringBuilder(this.getBaseEventURL(target_p, strEventName_p));
        if (this.m_ExternalRequestQueryString != null) {
            buf.append("&");
            buf.append(this.m_ExternalRequestQueryString);
        }
        if (strAdditionalParameters_p != null) {
            buf.append("&");
            buf.append(strAdditionalParameters_p);
        }
        return buf.toString();
    }

    protected StringBuffer getBaseEventURL(OwEventTarget target_p, String strEventName_p) {
        StringBuffer buf = new StringBuffer(255);
        buf.append(this.getJSPPageURL());
        buf.append("?");
        buf.append(EVENT_NAME);
        buf.append("=");
        buf.append(strEventName_p);
        buf.append("&");
        buf.append(INTERNAL_REQUEST_TARGET_ID);
        buf.append("=");
        buf.append(target_p.getID());
        buf.append("&");
        buf.append(SECURITY_KEY);
        buf.append("=");
        buf.append(this.m_strCurrentRequestSecurityKey);
        return buf;
    }

    public String getInfiniteEventURL(OwEventTarget target_p, String strEventName_p, String strAdditionalParameters_p) {
        StringBuilder buf = new StringBuilder(255);
        buf.append(this.getJSPPageURL());
        buf.append("?");
        buf.append(EVENT_NAME);
        buf.append("=");
        buf.append(strEventName_p);
        buf.append("&amp;");
        buf.append(INTERNAL_REQUEST_TARGET_ID);
        buf.append("=");
        buf.append(target_p.getID());
        if (this.m_ExternalRequestQueryString != null) {
            buf.append("&amp;");
            buf.append(this.m_ExternalRequestQueryString);
        }
        if (strAdditionalParameters_p != null) {
            buf.append("&amp;");
            buf.append(strAdditionalParameters_p);
        }
        return buf.toString();
    }

    public void handleAjaxRequest(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        OwEventTarget target;
        String targetID = request_p.getParameter(INTERNAL_REQUEST_TARGET_ID);
        String ajaxEventName = request_p.getParameter(EVENT_NAME);
        if (null != ajaxEventName && targetID != null && (target = this.m_EventTargetMap.get(targetID)) != null) {
            Method method = target.getClass().getMethod("onAjax" + ajaxEventName, HttpServletRequest.class, HttpServletResponse.class);
            method.invoke((Object)target, request_p, response_p);
        }
    }

    public boolean handleRequest(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        OwEventTarget Target;
        String targetID;
        this.m_jsincludes = new HashSet<String>();
        Iterator<OwEventTarget> it = this.m_RequestTargetMap.values().iterator();
        while (it.hasNext()) {
            if (it.next().onRequest(request_p, response_p)) continue;
            return false;
        }
        if (this.isExternalTargetRequest(request_p) && this.handleExternalTargetRequest(request_p, response_p)) {
            return true;
        }
        String strSecKey = request_p.getParameter(SECURITY_KEY);
        if (strSecKey != null && !strSecKey.equals(this.m_strCurrentRequestSecurityKey)) {
            return true;
        }
        String eventName = request_p.getParameter(EVENT_NAME);
        this.m_DEBUG_current_request_TargetID = targetID = request_p.getParameter(INTERNAL_REQUEST_TARGET_ID);
        if (eventName != null && targetID != null && (Target = this.m_EventTargetMap.get(targetID)) != null) {
            if (this.isFormRequest(request_p)) {
                Target.onFormEvent(request_p);
            }
            Method method = Target.getClass().getMethod("on" + eventName, HttpServletRequest.class);
            method.invoke((Object)Target, request_p);
        }
        this.generateNewCurrentRequestSecurityKey();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleExternalTargetRequest(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        if (this.isLogin()) {
            String strExternalRequestTargetID = request_p.getParameter(EXTERNAL_REQUEST_TARGET_ID);
            if (this.m_EventTargetMap.size() > 3) {
                block8: {
                    try {
                        OwEventTarget target = this.m_EventTargetMap.get(strExternalRequestTargetID);
                        if (target != null) {
                            target.onExternalRequest(request_p, response_p);
                            break block8;
                        }
                        throw new OwInvalidOperationException(OwString.localize1(this.getLocale(), "app.OwAppContext.InvalidExternalRequest", "OwAppContext.handleRequest: External Event Handler, targetId = '%1' not defined or not allowed in RoleManager.", strExternalRequestTargetID));
                    }
                    finally {
                        this.m_ExternalRequestQueryString = null;
                    }
                }
                return true;
            }
            return false;
        }
        if (this.m_ExternalRequestQueryString == null) {
            this.m_ExternalRequestQueryString = request_p.getQueryString();
            if (this.m_ExternalRequestQueryString == null) {
                this.m_ExternalRequestQueryString = (String)request_p.getAttribute("javax.servlet.forward.query_string");
            }
        }
        return false;
    }

    protected boolean isFormRequest(HttpServletRequest request_p) {
        return request_p.getMethod().equalsIgnoreCase("post");
    }

    public void broadcast(OwEventTarget caller_p, int iCode_p) throws Exception {
        Iterator<OwEventTarget> it = this.m_EventTargetMap.values().iterator();
        while (it.hasNext()) {
            try {
                OwDocument doc = (OwDocument)it.next();
                doc.update(caller_p, iCode_p, null);
            }
            catch (ClassCastException e) {}
        }
    }

    public void setFocusControlID(String strElementID_p) {
        this.m_strFocusElementID = strElementID_p;
    }

    public String getFocusControlID() {
        return this.m_strFocusElementID;
    }

    public void clearFocusControlID() {
        this.m_strFocusElementID = null;
    }

    @Deprecated
    public void renderKeyBoardScript(Writer w_p) throws Exception {
        if (this.m_KeyBoardEvents != null) {
            w_p.write("<script type=\"text/javascript\">\n");
            w_p.write("window.document.onkeydown = onOwKeyEvent;\n");
            w_p.write("function onOwKeyEvent(e)\n");
            w_p.write("{\n");
            w_p.write(" if ( ! e ) e = event;\n");
            w_p.write("var iMaskedCode =  e.keyCode + (e.altKey ? ");
            w_p.write(Integer.toString(1024));
            w_p.write(" : 0) + (e.ctrlKey ? ");
            w_p.write(Integer.toString(512));
            w_p.write(" : 0) + (e.shiftKey ? ");
            w_p.write(Integer.toString(256));
            w_p.write(" : 0);\n");
            w_p.write("switch ( iMaskedCode )\n");
            w_p.write("{\n");
            for (OwKeyEvent keyevent : this.m_KeyBoardEvents) {
                w_p.write("case ");
                w_p.write(Integer.toString(keyevent.getMaskedCode()));
                w_p.write(":\n{\n\t");
                if (keyevent.m_strEventURL != null && keyevent.m_strEventURL.startsWith(FULLJS_MARKER)) {
                    StringBuilder buffer = new StringBuilder(keyevent.m_strEventURL);
                    buffer.delete(0, FULLJS_MARKER.length());
                    w_p.write("var retVal = ");
                    w_p.write(buffer.toString().substring(11));
                    w_p.write("\n;");
                    w_p.write("if (retVal != null && retVal === false) {\n");
                    w_p.write("e.cancelBubble = true;\n");
                    w_p.write("}\n");
                } else {
                    if (keyevent.m_strFormName != null) {
                        w_p.write("document.");
                        w_p.write(keyevent.m_strFormName);
                        w_p.write(".action=\"");
                        w_p.write(keyevent.m_strEventURL);
                        w_p.write("\";\ndocument.");
                        w_p.write(keyevent.m_strFormName);
                        w_p.write(".submit();\n");
                    } else if (keyevent.m_strEventURL.startsWith("javascript:")) {
                        w_p.write("var retVal = ");
                        w_p.write(keyevent.m_strEventURL.substring(11));
                        w_p.write("\n;");
                        w_p.write("if (retVal != null && retVal === false) {\n");
                        w_p.write("e.cancelBubble = true;\n");
                        w_p.write("}\n");
                    } else {
                        w_p.write("navigateHREF(window,\"");
                        w_p.write(keyevent.m_strEventURL);
                        w_p.write("\");\n");
                    }
                    w_p.write("return false;\n");
                }
                w_p.write("}");
                w_p.write("break;\n");
            }
            w_p.write("}\n");
            w_p.write("return true;\n");
            w_p.write("}\n");
            w_p.write("</script>\n");
        }
    }

    private void clearEvents() {
        this.m_KeyBoardEvents = null;
        this.m_mouseEventDescriptions.clear();
    }

    public String localize(String strKey_p, String strText_p) {
        return OwString.localize(this.getLocale(), strKey_p, strText_p);
    }

    public String localize1(String strKey_p, String strText_p, String strAttribute1_p) {
        return OwString.localize1(this.getLocale(), strKey_p, strText_p, strAttribute1_p);
    }

    public String localize2(String strKey_p, String strText_p, String strAttribute1_p, String strAttribute2_p) {
        return OwString.localize2(this.getLocale(), strKey_p, strText_p, strAttribute1_p, strAttribute2_p);
    }

    public String localize3(String strKey_p, String strText_p, String strAttribute1_p, String strAttribute2_p, String strAttribute3_p) {
        return OwString.localize3(this.getLocale(), strKey_p, strText_p, strAttribute1_p, strAttribute2_p, strAttribute3_p);
    }

    public static String encodeURL(String strURL_p) throws UnsupportedEncodingException {
        if (strURL_p == null) {
            return null;
        }
        return URLEncoder.encode(strURL_p, "UTF-8").replaceAll("[:+:]", "%20");
    }

    public static String decodeURL(String strURL_p) throws UnsupportedEncodingException {
        if (strURL_p == null) {
            return null;
        }
        return URLDecoder.decode(strURL_p.replaceAll("%20", "+"), "UTF-8");
    }

    protected static String createSubmitLink(String formName_p, String eventUrl_p) {
        StringBuilder jsFunctionString = new StringBuilder();
        jsFunctionString.append("javascript:document.");
        jsFunctionString.append(formName_p);
        jsFunctionString.append(".action='");
        jsFunctionString.append(eventUrl_p);
        jsFunctionString.append("';document.");
        jsFunctionString.append(formName_p);
        jsFunctionString.append(".submit();");
        return jsFunctionString.toString();
    }

    protected static String createSubmitFunction(String formName_p, String eventUrl_p) {
        StringBuilder jsFunctionString = new StringBuilder();
        jsFunctionString.append("document.");
        jsFunctionString.append(formName_p);
        jsFunctionString.append(".action='");
        jsFunctionString.append(eventUrl_p);
        jsFunctionString.append("';document.");
        jsFunctionString.append(formName_p);
        jsFunctionString.append(".submit();");
        return jsFunctionString.toString();
    }

    public abstract String getSessionDisplayName();

    public OwBaseUserInfo getUserInfo() {
        return null;
    }

    public abstract Locale getLocale();

    public abstract void setLocale(Locale var1);

    public abstract String getDesignDir() throws Exception;

    public abstract String getDesignURL() throws Exception;

    public abstract boolean isLogin() throws Exception;

    public abstract boolean isContainerBasedAuthenticated() throws Exception;

    public void logout() throws Exception {
        HttpServletRequest request = OwRequestContext.getLocalThreadRequest();
        OwWebApplication.invalidateSessionObjects(request);
        HttpSession session = request.getSession(true);
        session.setAttribute(TIME_ZONE, (Object)this.getClientTimeZone());
    }

    public abstract void loginInit() throws Exception;

    public OwBaseView getDialogManagerViewReference() {
        return new OwDialogManagerViewReference(this);
    }

    public void dump(Writer w_p) throws Exception {
        w_p.write("<table cellspacing='0' cellpadding='0' border='1' width='100%'>");
        w_p.write("<tr bgcolor='#aaaaaa'><td class='OwDump'>");
        w_p.write("<b>Session</b>");
        w_p.write("</td></tr>");
        w_p.write("<tr><td class='OwDump'>");
        w_p.write("<b>Designdir:</b> " + this.getDesignDir());
        w_p.write(", <b>BaseURL:</b> " + this.getBaseURL());
        w_p.write(", <b>JSPPageURL:</b> " + this.getJSPPageURL());
        w_p.write("<br>");
        HttpSession Session = OwRequestContext.getLocalThreadRequest().getSession();
        w_p.write("<b>Session.isNew:</b> " + Boolean.valueOf(Session.isNew()).toString());
        w_p.write(", <b>Session.getId:</b> " + Session.getId());
        w_p.write(", <b>Session.getCreatenTime:</b> " + new Date(Session.getCreationTime()).toString());
        w_p.write("</td></tr>");
        w_p.write("</table>");
        if (this.getDialogManager() != null) {
            w_p.write("\n<table cellspacing='0' cellpadding='0' border='1' width='100%'>\n");
            w_p.write("<tr bgcolor='#aaaaaa'><td class='OwDump'>");
            w_p.write("<b>DialogManager</b>");
            w_p.write("</td></tr>\n");
            w_p.write("</table>");
            w_p.write("\n<table cellspacing='0' cellpadding='0' border='1' width='100%'>");
            Iterator itDialog = this.getDialogManager().getIterator();
            while (itDialog.hasNext()) {
                OwDialog Dialog = (OwDialog)itDialog.next();
                w_p.write("<tr><td class='OwDump'>");
                w_p.write("<b>" + Dialog.getClass().toString() + "</b> - ID: " + Dialog.getID());
                if (Dialog.getDocument() != null) {
                    w_p.write(" Doc: " + Dialog.getDocument().toString());
                }
                w_p.write("</td></tr>");
            }
            w_p.write("</table>");
        }
        w_p.write("\n<table cellspacing='0' cellpadding='0' border='1' width='100%'>\n");
        w_p.write("<tr bgcolor='#aaaaaa'><td class='OwDump'>");
        w_p.write("<b>Target Count: " + String.valueOf(this.m_EventTargetMap.size()) + "</b>");
        w_p.write("</td></tr>\n");
        w_p.write("</table>");
        w_p.write("\n<table cellspacing='0' cellpadding='0' border='1' width='100%'>\n");
        w_p.write("<tr bgcolor='#aaaaaa'>");
        w_p.write("<td class='OwDump' bgcolor='#ff6666'>Request Target: " + this.m_DEBUG_current_request_TargetID + "</td>");
        w_p.write("<td class='OwDump' bgcolor='#66ff66'>Activated View: " + this.m_DEBUG_ActivateViewID + "</td>");
        w_p.write("<td class='OwDump' bgcolor='#6666ff'>Navigation Target: " + this.m_DEBUG_NavigationTargetID + " : <b>" + this.m_DEBUG_NavigationEvent + "</b></td>");
        w_p.write("</tr>\n");
        w_p.write("</table>");
        w_p.write("\n<table cellspacing='0' cellpadding='0' border='1' width='100%'>");
        Iterator<OwEventTarget> it = this.m_EventTargetMap.values().iterator();
        int iRowToggle = 0;
        w_p.write("\n<tr>");
        while (it.hasNext()) {
            if (iRowToggle++ % 3 == 0) {
                w_p.write("</tr>\n<tr>");
            }
            OwEventTarget Target = it.next();
            if (null != this.m_DEBUG_current_request_TargetID && this.m_DEBUG_current_request_TargetID.equals(Target.getID())) {
                w_p.write("<td class='OwDump' bgcolor='#ff6666'>");
            } else if (this.m_DEBUG_ActivateViewID.equals(Target.getID())) {
                w_p.write("<td class='OwDump' bgcolor='#66ff66'>");
            } else if (this.m_DEBUG_NavigationTargetID.equals(Target.getID())) {
                w_p.write("<td class='OwDump' bgcolor='#6666ff'>");
            } else {
                w_p.write("<td class='OwDump'>");
            }
            w_p.write(Target.getID());
            w_p.write("<br>" + Target.getClass().toString());
            w_p.write("</td>");
        }
        w_p.write("</tr>");
        w_p.write("</table>\n\n");
        w_p.write("\n<table cellspacing='0' cellpadding='0' border='1' width='100%'>\n");
        w_p.write("<tr bgcolor='#aaaaaa'><td class='OwDump'>");
        w_p.write("<b>View Tree</b>");
        w_p.write("</td></tr>\n");
        w_p.write("</table>");
        w_p.write("\n<table cellspacing='0' cellpadding='0' border='1' width='100%'>");
        OwView MainView = (OwView)this.m_EventTargetMap.get(MAIN_VIEW_TARGET_ID);
        this.DumpViewNode(w_p, MainView, 0);
        w_p.write("</table>");
        this.m_DEBUG_current_request_TargetID = "";
        this.m_DEBUG_ActivateViewID = "";
        this.m_DEBUG_NavigationTargetID = "";
        this.m_DEBUG_NavigationEvent = "";
    }

    private boolean DumpViewNode(Writer w_p, OwView view_p, int iTab_p) throws Exception {
        if (view_p != null) {
            w_p.write("<tr>");
            if (null != this.m_DEBUG_current_request_TargetID && this.m_DEBUG_current_request_TargetID.equals(view_p.getID())) {
                w_p.write("<td class='OwDump' bgcolor='#ff6666'>");
            } else if (this.m_DEBUG_ActivateViewID.equals(view_p.getID())) {
                w_p.write("<td class='OwDump' bgcolor='#66ff66'>");
            } else if (this.m_DEBUG_NavigationTargetID.equals(view_p.getID())) {
                w_p.write("<td class='OwDump' bgcolor='#6666ff'>");
            } else {
                w_p.write("<td class='OwDump'>");
            }
            for (int i = 0; i < iTab_p; ++i) {
                w_p.write("&nbsp;");
            }
            w_p.write("<b>" + view_p.getClass().toString() + "</b> - ID: " + view_p.getID());
            if (view_p.getDocument() != null) {
                w_p.write(" Doc: " + view_p.getDocument().toString());
            }
            w_p.write("</td></tr>");
            Iterator it = view_p.getIterator();
            while (it.hasNext()) {
                this.DumpViewNode(w_p, (OwView)it.next(), iTab_p + 5);
            }
            return true;
        }
        return false;
    }

    public void renderJSInclude(String sJSPath_p, Writer w_p) throws IOException {
        if (!this.m_jsincludes.contains(sJSPath_p)) {
            w_p.write("\n<script type='text/javascript' src='");
            w_p.write(this.getBaseURL());
            w_p.write(sJSPath_p);
            w_p.write("'></script>\n");
            this.m_jsincludes.add(sJSPath_p);
        }
    }

    public void renderJSInclude(String sJSPath_p, boolean useDebug_p, Writer w_p) throws IOException {
        String path = sJSPath_p.toLowerCase();
        if (useDebug_p) {
            StringBuilder buff = new StringBuilder(path);
            int position = buff.lastIndexOf(".js");
            if (position != -1) {
                buff.insert(position, "-debug");
            }
            path = buff.toString();
        }
        if (!this.m_jsincludes.contains(path)) {
            w_p.write("\n<script type='text/javascript' src='");
            w_p.write(this.getBaseURL());
            w_p.write(path);
            w_p.write("'></script>\n");
            this.m_jsincludes.add(path);
        }
        if (useDebug_p && this.m_jsincludes.contains(sJSPath_p)) {
            this.m_jsincludes.remove(sJSPath_p);
        }
    }

    public Object getApplicationAttribute(String key_p) {
        return this.baseInitializer.getApplicationAttribute(key_p);
    }

    public Object setApplicationAttribute(String key_p, Object object_p) {
        return this.baseInitializer.setApplicationAttribute(key_p, object_p);
    }

    public void setAjaxRequest(boolean isAjaxRequest_p) {
        HttpServletRequest request = OwRequestContext.getLocalThreadRequest();
        if (request == null) {
            throw new IllegalStateException("We don't have a request associated with current thread.");
        }
        request.setAttribute(AJAX_REQUEST_TYPE, (Object)isAjaxRequest_p);
    }

    public boolean isAjaxRequest() {
        Boolean requestType;
        boolean result = false;
        HttpServletRequest request = OwRequestContext.getLocalThreadRequest();
        if (request != null && (requestType = (Boolean)request.getAttribute(AJAX_REQUEST_TYPE)) != null) {
            result = requestType;
        }
        return result;
    }

    public abstract OwInfoProviderRegistry getInfoProviderRegistry();

    public boolean isExternalTargetRequest(HttpServletRequest request_p) {
        return request_p.getParameter(EXTERNAL_REQUEST_TARGET_ID) != null;
    }

    public void setClientTimeZoneInfo(OwTimeZoneInfo timeZoneInfo_p) {
        this.clientTimeZoneInfo = timeZoneInfo_p;
        TimeZone timeZone = this.clientTimeZoneInfo.getTimeZone();
        if (timeZone == null) {
            LOG.error((Object)("OwMainAppContext.setClientTimeZoneInfo : Unknown time zone for current client time zone information " + this.clientTimeZoneInfo));
        }
    }

    public OwTimeZoneInfo getClientTimeZoneInfo() {
        return this.clientTimeZoneInfo;
    }

    public TimeZone getClientTimeZone() {
        OwTimeZoneInfo zoneInfo = this.clientTimeZoneInfo;
        if (zoneInfo == null) {
            zoneInfo = new OwTimeZoneInfo();
        }
        TimeZone timeZone = null;
        timeZone = zoneInfo.getTimeZone();
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        return timeZone;
    }

    public boolean prepareRequest(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        OwTimeZoneInfo currentTimeZoneInfo = this.getClientTimeZoneInfo();
        HttpSession session = request_p.getSession();
        String preparedRequestURL = (String)session.getAttribute(PREPARED_REQUEST_URL);
        if (currentTimeZoneInfo == null || preparedRequestURL != null) {
            OwTimeZoneInfo timeZoneInfo;
            if (currentTimeZoneInfo == null) {
                this.setClientTimeZoneInfo(new OwTimeZoneInfo());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("OwAppContext.prepareRequest : default time zone was set to ID=" + this.getClientTimeZone().getID()));
                }
            }
            if ((timeZoneInfo = this.retrieveTimeZoneInfo(request_p)) == null && preparedRequestURL == null) {
                if (!this.isLogin()) {
                    StringBuilder requestURL = new StringBuilder(this.getBaseURL());
                    String queryString = request_p.getQueryString();
                    if (queryString == null) {
                        queryString = (String)request_p.getAttribute("javax.servlet.forward.query_string");
                    }
                    if (queryString != null) {
                        requestURL.append("?");
                        requestURL.append(queryString);
                    }
                    preparedRequestURL = requestURL.toString();
                    session.setAttribute(PREPARED_REQUEST_URL, (Object)preparedRequestURL);
                    LOG.debug((Object)("OwAppContext.prepareRequest : starting time zone forward prepare for " + preparedRequestURL));
                    ServletContext servletContext = session.getServletContext();
                    RequestDispatcher prepareDispatcher = servletContext.getRequestDispatcher("/prepare.jsp");
                    prepareDispatcher.forward((ServletRequest)request_p, (ServletResponse)response_p);
                    return true;
                }
                LOG.warn((Object)"OwAppContext.prepareRequest : logged in session with no time zone was detected!");
            } else if (timeZoneInfo != null) {
                session.removeAttribute(PREPARED_REQUEST_URL);
                this.setClientTimeZoneInfo(timeZoneInfo);
                if (LOG.isDebugEnabled()) {
                    TimeZone dbgZone = timeZoneInfo.getTimeZone();
                    if (dbgZone != null) {
                        LOG.debug((Object)("OwAppContext.prepareRequest : context time zone was set to " + dbgZone.getID() + " == " + dbgZone.getDisplayName()));
                    } else {
                        LOG.debug((Object)("OwAppContext.prepareRequest : context time zone was set to invalid time zone info " + timeZoneInfo.toString()));
                    }
                }
            } else {
                preparedRequestURL = null;
                LOG.warn((Object)"OwAppContext.prepareRequest : unsuccessfull time zone preparation");
            }
        }
        return false;
    }

    private OwTimeZoneInfo retrieveTimeZoneInfo(HttpServletRequest request_p) {
        TimeZone timeZone;
        HttpSession session = request_p.getSession();
        OwTimeZoneInfo timeZoneInfo = null;
        String timeZoneID = request_p.getParameter(TIME_ZONE_ID_PARAMETER_NAME);
        if (timeZoneID != null && timeZoneID.length() > 0) {
            TimeZone zone = TimeZone.getTimeZone(timeZoneID);
            if (zone.getID().equals(timeZoneID)) {
                timeZoneInfo = new OwTimeZoneInfo(zone);
            } else {
                LOG.error((Object)("OwAppContext.retrieveTimeZoneInfo : invalid client time zone ID " + timeZoneID));
            }
        } else if (session != null && (timeZone = (TimeZone)session.getAttribute(TIME_ZONE)) != null) {
            LOG.debug((Object)"Set time zone from session.");
            timeZoneInfo = new OwTimeZoneInfo(timeZone);
        }
        if (timeZoneInfo == null) {
            String timeZoneTimeParam = request_p.getParameter(TIME_ZONE_TIME_PARAMETER_NAME);
            long timeZoneTime = 0L;
            String timeZoneOffsetParam = request_p.getParameter(TIME_ZONE_OFFSET_PARAMETER_NAME);
            int timeZoneOffset = 0;
            String timeZoneDSTParam = request_p.getParameter(TIME_ZONE_DAYLIGHTSAVINGS_PARAMETER_NAME);
            boolean timeZoneDST = true;
            String timeZoneNorthernHemisphereParam = request_p.getParameter(TIME_ZONE_NORTHERN_HEMISPHERE_PARAMETER_NAME);
            boolean timeZoneNorthernHemisphere = true;
            Object[] timeZoneTransitionsParam = request_p.getParameterValues(TIME_ZONE_TRANSITIONS_PARAMETER_NAME);
            if (timeZoneTimeParam == null || timeZoneDSTParam == null || timeZoneOffsetParam == null || timeZoneNorthernHemisphereParam == null) {
                if (LOG.isDebugEnabled()) {
                    String tzInfoParams = "time=" + timeZoneTime + " dst=" + timeZoneDSTParam + " offset=" + timeZoneOffsetParam + " northern=" + timeZoneNorthernHemisphereParam + " transitions=" + Arrays.toString(timeZoneTransitionsParam);
                    LOG.debug((Object)("OwAppContext.retrieveTimeZoneInfo : invalid or no client time zone information parameters " + tzInfoParams));
                }
            } else {
                try {
                    timeZoneTime = Long.parseLong(timeZoneTimeParam);
                    timeZoneOffset = Integer.parseInt(timeZoneOffsetParam) * 60 * 1000;
                    timeZoneDST = Boolean.parseBoolean(timeZoneDSTParam);
                    timeZoneNorthernHemisphere = Boolean.parseBoolean(timeZoneNorthernHemisphereParam);
                    Long[] timeZoneTransitions = new Long[timeZoneTransitionsParam == null ? 0 : timeZoneTransitionsParam.length];
                    for (int i = 0; i < timeZoneTransitions.length; ++i) {
                        timeZoneTransitions[i] = Long.parseLong((String)timeZoneTransitionsParam[i]);
                    }
                    timeZoneInfo = new OwTimeZoneInfo(timeZoneTime, timeZoneOffset, timeZoneDST, timeZoneTransitions, timeZoneNorthernHemisphere);
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)"Error parsing time zone information.", (Throwable)e);
                }
            }
        }
        return timeZoneInfo;
    }

    @Override
    public void registerInterface(Class<?> typeClass, Object object) {
        this.register.put(typeClass, object);
    }

    @Override
    public <T> T getRegisteredInterface(Class<T> typeClass) {
        return (T)this.register.get(typeClass);
    }

    @Override
    public <T> T unregisterInterface(Class<T> typeClass) {
        return (T)this.register.remove(typeClass);
    }

    protected String createServerUrl(HttpServletRequest req_p) {
        StringBuilder server = req_p.isSecure() ? new StringBuilder("https://") : new StringBuilder("http://");
        server.append(req_p.getServerName());
        if (req_p.isSecure() ? req_p.getServerPort() != 443 : req_p.getServerPort() != 80) {
            server.append(":").append(req_p.getServerPort());
        }
        return server.toString();
    }

    protected String createJspPageUrl(HttpServletRequest req_p) {
        return this.getServerURL() + req_p.getRequestURI();
    }

    protected String createBaseUrl(HttpServletRequest req_p) {
        return this.getServerURL() + req_p.getContextPath();
    }

    protected abstract OwAOProvider createAOProvider() throws OwException;

    public OwAOProvider getAOProvider() throws OwException {
        OwAOProvider aoProvider = this.getRegisteredInterface(OwAOProvider.class);
        if (aoProvider == null) {
            aoProvider = this.createAOProvider();
            this.registerInterface(OwAOProvider.class, aoProvider);
        }
        return aoProvider;
    }

    public static class OwDialogManagerViewReference
    implements OwBaseView {
        private OwAppContext m_context;

        public OwDialogManagerViewReference(OwAppContext context_p) {
            this.m_context = context_p;
        }

        @Override
        public boolean isNamedRegion(String strRegion_p) throws Exception {
            try {
                return this.m_context.getDialogManager().isNamedRegion(strRegion_p);
            }
            catch (NullPointerException e) {
                LOG.error((Object)"No dialogmanager available, probably due to missing masterplugins.", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isRegion(int iRegion_p) throws Exception {
            try {
                return this.m_context.getDialogManager().isRegion(iRegion_p);
            }
            catch (NullPointerException e) {
                LOG.error((Object)"No dialogmanager available, probably due to missing masterplugins.", (Throwable)e);
                return false;
            }
        }

        @Override
        public void render(Writer w_p) throws Exception {
            try {
                this.m_context.getDialogManager().render(w_p);
            }
            catch (NullPointerException e) {
                LOG.error((Object)"No dialogmanager available, probably due to missing masterplugins.", (Throwable)e);
            }
        }

        @Override
        public void renderNamedRegion(Writer w_p, String strRegion_p) throws Exception {
            try {
                this.m_context.getDialogManager().renderNamedRegion(w_p, strRegion_p);
            }
            catch (NullPointerException e) {
                LOG.error((Object)"No dialogmanager available, probably due to missing masterplugins.", (Throwable)e);
            }
        }

        @Override
        public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
            try {
                this.m_context.getDialogManager().renderRegion(w_p, iRegion_p);
            }
            catch (NullPointerException e) {
                LOG.error((Object)"No dialogmanager available, probably due to missing masterplugins.", (Throwable)e);
            }
        }

        @Override
        public String getTitle() {
            if (this.m_context.getDialogManager() == null) {
                return "";
            }
            return this.m_context.getDialogManager().getTitle();
        }

        @Override
        public String getBreadcrumbPart() {
            return this.getTitle();
        }
    }
}

