/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.ui.OwEventDescription;
import com.wewebu.ow.server.ui.OwKeyboardDescription;
import com.wewebu.ow.server.ui.ua.OwOSFamily;
import java.util.Locale;

public class OwKeyEvent
implements OwEventDescription {
    private int m_iKeyCode;
    private int m_iCtrlKey;
    String m_strEventURL;
    String m_strFormName;
    private String m_strDescription;

    public OwKeyEvent(int iKeyCode_p, int iCtrlKey_p, String strEventURL_p, String strFormName_p, String description_p) {
        this.m_iKeyCode = iKeyCode_p;
        this.m_iCtrlKey = iCtrlKey_p;
        this.m_strEventURL = strEventURL_p;
        this.m_strFormName = strFormName_p;
        this.m_strDescription = description_p;
    }

    public int getKeyCode() {
        return this.m_iKeyCode;
    }

    public int getCtrlKeyCode() {
        return this.m_iCtrlKey;
    }

    public String getEventURL() {
        return this.m_strEventURL;
    }

    public String getFormName() {
        return this.m_strFormName;
    }

    public String getDescription() {
        return this.m_strDescription;
    }

    public static String getCtrlDescription(Locale locale_p, int iCtrlCode_p) {
        OwKeyboardDescription keyboardDescription = OwKeyboardDescription.getInstance();
        return keyboardDescription.getCtrlDescription(locale_p, iCtrlCode_p);
    }

    public String getKeyDescription(Locale locale, OwOSFamily userAgentFamily) {
        OwKeyboardDescription keyboardDescription = OwKeyboardDescription.getInstance();
        return keyboardDescription.getDescription(this.m_iKeyCode, this.m_iCtrlKey, locale, userAgentFamily);
    }

    @Override
    public String getEventString(Locale locale, OwOSFamily userAgentFamily) {
        return this.getKeyDescription(locale, userAgentFamily);
    }

    public String getKeyDescription(Locale locale_p) {
        return this.getKeyDescription(locale_p, OwOSFamily.UNKNOWN);
    }

    public int getMaskedCode() {
        return this.m_iKeyCode + this.m_iCtrlKey;
    }

    public boolean equals(Object obj_p) {
        boolean result = false;
        if (obj_p != null && obj_p instanceof OwKeyEvent) {
            OwKeyEvent converted = (OwKeyEvent)obj_p;
            if (this.m_iKeyCode == converted.m_iKeyCode && this.m_iCtrlKey == converted.m_iCtrlKey) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return ("" + this.m_iKeyCode + "_" + this.m_iCtrlKey).hashCode();
    }

    @Override
    public String getDescription(Locale locale, OwOSFamily userAgentFamily) {
        return this.getDescription();
    }
}

