/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.ui.OwBaseView;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class OwLayout
extends OwView {
    protected HashMap m_Regions = new HashMap();

    public void addRegion(OwBaseView view_p, int iRegion_p, int iDispatchRegion_p) throws Exception {
        this.m_Regions.put(iRegion_p, new OwDispatchRegion(view_p, iDispatchRegion_p));
    }

    public void addView(OwView view_p, int iRegion_p, String strName_p) throws Exception {
        if (this.getDocument() != null) {
            view_p.setDocument(this.getDocument());
        }
        view_p.attach(this.getContext(), strName_p);
        view_p.setParent(this);
        this.m_Regions.put(iRegion_p, view_p);
    }

    @Override
    public void addView(OwView view_p, String strName_p) throws Exception {
        throw new Exception("addView without Region not allowed in OwLayout, call addView(OwView View_p,int iRegion_p,String strName_p) instead.");
    }

    public void addViewReference(OwBaseView view_p, int iRegion_p) throws Exception {
        this.m_Regions.put(iRegion_p, view_p);
    }

    @Override
    public Iterator getIterator() {
        LinkedList<OwView> retList = new LinkedList<OwView>();
        Iterator it = this.m_Regions.values().iterator();
        while (it.hasNext()) {
            try {
                OwView View = (OwView)it.next();
                retList.add(View);
            }
            catch (ClassCastException classCastException) {}
        }
        return retList.iterator();
    }

    public OwView getViewRegion(int iRegion_p) throws OwObjectNotFoundException {
        try {
            return (OwView)this.m_Regions.get(iRegion_p);
        }
        catch (Exception e) {
            throw new OwObjectNotFoundException("OwLayout.getViewRegion: Region = " + String.valueOf(iRegion_p), (Throwable)e);
        }
    }

    @Override
    public boolean isRegion(int iRegion_p) {
        OwBaseView region = (OwBaseView)this.m_Regions.get(iRegion_p);
        if (region instanceof OwLayoutViewRefrence) {
            OwLayoutViewRefrence reference = (OwLayoutViewRefrence)region;
            return reference.isEnabled();
        }
        return region != null;
    }

    public boolean isRegionMaximized(int iRegion_p) {
        try {
            OwView View = (OwView)this.m_Regions.get(iRegion_p);
            return View.isShowMaximized();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isRegionMinimized(int iRegion_p) {
        try {
            OwView View = (OwView)this.m_Regions.get(iRegion_p);
            return View.isShowMinimized();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isRegionNormal(int iRegion_p) {
        try {
            OwView View = (OwView)this.m_Regions.get(iRegion_p);
            return View.isShowNormal();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void renderNamedRegion(Writer w_p, String strRegion_p) throws Exception {
        this.renderRegion(w_p, Integer.parseInt(strRegion_p));
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        OwBaseView View = (OwBaseView)this.m_Regions.get(iRegion_p);
        if (View != null) {
            View.render(w_p);
        }
    }

    protected static class OwDispatchRegion
    implements OwBaseView {
        private int m_iDispatchRegion;
        private OwBaseView m_View;

        public OwDispatchRegion(OwBaseView view_p, int iDispatchRegion_p) {
            this.m_View = view_p;
            this.m_iDispatchRegion = iDispatchRegion_p;
        }

        @Override
        public boolean isNamedRegion(String strRegion_p) throws Exception {
            throw new OwInvalidOperationException("OwLayout$OwDispatchRegion.renderNamedRegion: renderRegion must not be called in Dispatch Regions");
        }

        @Override
        public boolean isRegion(int iRegion_p) throws Exception {
            return false;
        }

        @Override
        public void render(Writer w_p) throws Exception {
            this.m_View.renderRegion(w_p, this.m_iDispatchRegion);
        }

        @Override
        public String getTitle() {
            return this.m_View == null ? "" : this.m_View.getTitle();
        }

        @Override
        public void renderNamedRegion(Writer w_p, String strRegion_p) throws Exception {
            throw new OwInvalidOperationException("OwLayout$OwDispatchRegion.renderNamedRegion: ...must not be called in Dispatch Regions.");
        }

        @Override
        public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
            throw new OwInvalidOperationException("OwLayout$OwDispatchRegion.renderRegion: ...must not be called in Dispatch Regions.");
        }

        @Override
        public String getBreadcrumbPart() {
            return this.getTitle();
        }
    }

    public static interface OwLayoutViewRefrence
    extends OwBaseView {
        public boolean isEnabled();
    }
}

