/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwNavigationView;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import org.apache.log4j.Logger;

public abstract class OwMenu
extends OwNavigationView {
    protected static final int NO_DEFAULT_BUTTON = Integer.MIN_VALUE;
    protected int defaultButtonIndex = Integer.MIN_VALUE;
    private static Logger LOG = OwLogCore.getLogger(OwMenu.class);

    public boolean isChecked(int iIndex_p) {
        try {
            return this.getCheckedBoxIcon().equals(this.getImage(iIndex_p));
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getCheckedBoxIcon() throws Exception {
        return this.getContext().getDesignURL() + "/images/checked.png";
    }

    private String getUnCheckedBoxIcon() throws Exception {
        return this.getContext().getDesignURL() + "/images/unchecked.png";
    }

    public void check(boolean fEnable_p, int iIndex_p) throws Exception {
        if (fEnable_p) {
            this.setImage(this.getCheckedBoxIcon(), iIndex_p);
        } else {
            this.setImage(this.getUnCheckedBoxIcon(), iIndex_p);
        }
    }

    public void toggleCheck(int iIndex_p) throws Exception {
        this.check(!this.isChecked(iIndex_p), iIndex_p);
    }

    protected void setFormSubmitButton(String strFormName_p, int iButtonIndex_p) throws Exception {
        OwMenuTab CurrentTab = (OwMenuTab)this.m_TabList.get(iButtonIndex_p);
        if (CurrentTab == null) {
            throw new Exception("Button index not defined");
        }
        CurrentTab.m_strFormName = strFormName_p;
    }

    public void setImage(String strImage_p, int iIndex_p) {
        ((OwMenuTab)this.m_TabList.get((int)iIndex_p)).m_Image = strImage_p;
    }

    protected Object getImage(int iIndex_p) {
        return ((OwMenuTab)this.m_TabList.get((int)iIndex_p)).m_Image;
    }

    public int addMenuItem(OwEventTarget target_p, String strTitle_p, String strEvent_p, String strToolTip_p) throws Exception {
        return this.addMenuItem(target_p, strTitle_p, null, strEvent_p, null, strToolTip_p);
    }

    public int addMenuItem(OwEventTarget target_p, String strTitle_p, String strEvent_p, String strToolTip_p, boolean validateForm) throws Exception {
        return this.addMenuItem(target_p, strTitle_p, null, strEvent_p, null, strToolTip_p, validateForm);
    }

    public int addMenuItem(OwEventTarget target_p, String strTitle_p, String strImage_p, String strEvent_p, Object oReason_p, String strToolTip_p) throws Exception {
        return super.addMenuItem(this.createTabInfo(target_p, strTitle_p, strImage_p, oReason_p, strEvent_p, strToolTip_p));
    }

    public int addMenuItem(OwEventTarget target_p, String strTitle_p, String strImage_p, String strEvent_p, Object oReason_p, String strToolTip_p, boolean validateForm) throws Exception {
        OwMenuTab tabInfo = this.createTabInfo(target_p, strTitle_p, strImage_p, oReason_p, strEvent_p, strToolTip_p);
        tabInfo.setValidateForm(validateForm);
        return super.addMenuItem(tabInfo);
    }

    protected OwMenuTab createTabInfo(OwEventTarget target_p, String strTitle_p, String strImage_p, Object oReason_p, String strEvent_p, String strToolTip_p) {
        return new OwMenuTab(target_p, strTitle_p, strImage_p, oReason_p, strEvent_p, strToolTip_p);
    }

    public int addFormMenuItem(OwEventTarget target_p, String strTitle_p, String strEvent_p, String strToolTip_p, String strFormName_p) throws Exception {
        return this.addFormMenuItem(target_p, strTitle_p, null, strEvent_p, null, strToolTip_p, strFormName_p);
    }

    public int addFormMenuItem(OwEventTarget target_p, String strTitle_p, String strEvent_p, String strToolTip_p, String strFormName_p, boolean validateForm) throws Exception {
        return this.addFormMenuItem(target_p, strTitle_p, null, strEvent_p, null, strToolTip_p, strFormName_p, validateForm);
    }

    public int addFormMenuItem(OwEventTarget target_p, String strTitle_p, String strEvent_p, String strToolTip_p) throws Exception {
        return this.addFormMenuItem(target_p, strTitle_p, null, strEvent_p, null, strToolTip_p);
    }

    public int addFormMenuItem(OwEventTarget target_p, String strTitle_p, String strEvent_p, String strToolTip_p, boolean validateForm) throws Exception {
        return this.addFormMenuItem(target_p, strTitle_p, null, strEvent_p, null, strToolTip_p, validateForm);
    }

    public int addFormMenuItem(OwEventTarget target_p, String strTitle_p, String strImage_p, String strEvent_p, Object oReason_p, String strToolTip_p, String strFormName_p) throws Exception {
        int iIndex = this.addMenuItem(target_p, strTitle_p, strImage_p, strEvent_p, oReason_p, strToolTip_p);
        this.setFormSubmitButton(strFormName_p, iIndex);
        return iIndex;
    }

    public int addFormMenuItem(OwEventTarget target_p, String strTitle_p, String strImage_p, String strEvent_p, Object oReason_p, String strToolTip_p, String strFormName_p, boolean validateForm) throws Exception {
        int iIndex = this.addMenuItem(target_p, strTitle_p, strImage_p, strEvent_p, oReason_p, strToolTip_p, validateForm);
        this.setFormSubmitButton(strFormName_p, iIndex);
        return iIndex;
    }

    public int addFormMenuItem(OwEventTarget target_p, String strTitle_p, String strImage_p, String strEvent_p, Object oReason_p, String strToolTip_p) throws Exception {
        int iIndex = this.addMenuItem(target_p, strTitle_p, strImage_p, strEvent_p, oReason_p, strToolTip_p);
        this.setFormSubmitButton(target_p.getFormName(), iIndex);
        return iIndex;
    }

    public int addFormMenuItem(OwEventTarget target_p, String strTitle_p, String strImage_p, String strEvent_p, Object oReason_p, String strToolTip_p, boolean validateForm) throws Exception {
        int iIndex = this.addMenuItem(target_p, strTitle_p, strImage_p, strEvent_p, oReason_p, strToolTip_p, validateForm);
        this.setFormSubmitButton(target_p.getFormName(), iIndex);
        return iIndex;
    }

    public void setDefaultMenuItem(int defaultMenuItemIndex_p) {
        this.defaultButtonIndex = defaultMenuItemIndex_p;
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        super.onRender(w_p);
        if (this.defaultButtonIndex != Integer.MIN_VALUE) {
            if (this.defaultButtonIndex < this.getTabList().size()) {
                OwNavigationView.OwTabInfo tabInfo = (OwNavigationView.OwTabInfo)this.getTabList().get(this.defaultButtonIndex);
                if (!tabInfo.getDisabled()) {
                    this.getContext().registerKeyFormEvent(13, 0, "fulljs:javascript:navigateToMenu();", null, tabInfo.getName());
                    this.serverSideDesignInclude("/OwMenu.jsp", w_p);
                } else {
                    LOG.warn((Object)("OwMenu.onRender: The default menu item event with index: [" + this.defaultButtonIndex + "] cannot be registred for ENTER key because the menu item is disabled."));
                }
            } else {
                LOG.warn((Object)("OwMenu.onRender: The default menu item event with index: [" + this.defaultButtonIndex + "] cannot be registred for ENTER key."));
            }
        }
    }

    public String getMenuEventURL() {
        return this.getNavigateEventURL(this.defaultButtonIndex);
    }

    public class OwMenuTab
    extends OwNavigationView.OwAbstractTabInfo {
        protected OwEventTarget m_Target;
        protected String m_strName;
        protected Object m_Image;
        protected Object m_ReasonObject;
        protected String m_strEventMethod;
        protected boolean m_fDisabled = false;
        protected String m_strToolTip;
        public String m_strFormName;
        private int m_iIndex = 0;

        public OwMenuTab(OwEventTarget target_p, String strTitle_p, String strImage_p, Object oReason_p, String strEvent_p, String strToolTip_p) {
            this.m_Target = target_p;
            this.m_strName = strTitle_p;
            this.m_Image = strImage_p;
            this.m_ReasonObject = oReason_p;
            this.m_strEventMethod = strEvent_p;
            this.m_strToolTip = strToolTip_p;
            this.m_iIndex = OwMenu.this.m_TabList.size();
        }

        @Override
        public boolean getPreviousPanelValid() {
            return OwMenu.this.isPreviousPanelValid(this.m_iIndex);
        }

        @Override
        public boolean getSelected() {
            return OwMenu.this.getNavigationIndex() == this.m_iIndex;
        }

        @Override
        public String getEvent() {
            return OwMenu.this.getNavigateEventURL(this.m_iIndex);
        }

        @Override
        public String getFormEventAction() {
            return OwMenu.this.getNavigationFormAction(this.m_iIndex);
        }

        @Override
        public boolean getLastTab() {
            return OwMenu.this.isLastTabIndex(this.m_iIndex);
        }

        @Override
        public boolean getDelimiter() {
            return false;
        }

        @Override
        public String getFormName() {
            return this.m_strFormName;
        }

        @Override
        public String getName() {
            return this.m_strName;
        }

        @Override
        public String getEventMethod() {
            return this.m_strEventMethod;
        }

        public String getToolTip() {
            return this.m_strToolTip;
        }

        @Override
        public boolean getDisabled() {
            return this.m_fDisabled;
        }

        @Override
        public void setDisabled(boolean fDisabled_p) {
            this.m_fDisabled = fDisabled_p;
        }

        public Object getImage() {
            return this.m_Image;
        }

        @Override
        public Object getReasonObject() {
            return this.m_ReasonObject;
        }

        @Override
        public OwEventTarget getEventTarget() {
            return this.m_Target;
        }

        @Override
        public OwView getView() {
            return null;
        }
    }
}

