/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.ui.OwMouseSetting;
import com.wewebu.ow.server.ui.OwMouseSettingsConfiguration;
import com.wewebu.ow.server.ui.OwOSFamilyMouseSetting;
import com.wewebu.ow.server.ui.ua.OwOSFamily;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OwStaticMouseSettingsConfiguration
implements OwMouseSettingsConfiguration {
    private static OwStaticMouseSettingsConfiguration instance = null;
    private Map<String, OwMouseSetting> mouseSettings = new HashMap<String, OwMouseSetting>();

    public static synchronized OwStaticMouseSettingsConfiguration getInstance() {
        if (instance == null) {
            instance = new OwStaticMouseSettingsConfiguration();
        }
        return instance;
    }

    private OwStaticMouseSettingsConfiguration() {
        OwOSFamilyMouseSetting.OwOSFamilyMouseActionCode osXCMDClick = new OwOSFamilyMouseSetting.OwOSFamilyMouseActionCode(OwOSFamily.OS_X, 0, 2048, 3);
        OwOSFamilyMouseSetting.OwOSFamilyMouseActionCode winCtrlClick = new OwOSFamilyMouseSetting.OwOSFamilyMouseActionCode(OwOSFamily.WINDOWS, 0, 512, 3);
        OwOSFamilyMouseSetting.OwOSFamilyMouseActionCode unknownCtrlClick = new OwOSFamilyMouseSetting.OwOSFamilyMouseActionCode(OwOSFamily.UNKNOWN, 0, 512, 3);
        this.add(new OwOSFamilyMouseSetting("object.list.select.deselect.nonconsecutive", osXCMDClick, winCtrlClick, unknownCtrlClick));
    }

    private void add(OwMouseSetting setting) {
        this.mouseSettings.put(setting.getId(), setting);
    }

    @Override
    public Set<String> getActionIds() {
        return this.mouseSettings.keySet();
    }

    @Override
    public OwMouseSetting getSetting(String actionId) throws OwConfigurationException {
        OwMouseSetting setting = this.mouseSettings.get(actionId);
        if (setting == null) {
            throw new OwConfigurationException("No mouse action setting " + actionId + " found.");
        }
        return setting;
    }
}

