/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui.preview;

import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.ui.preview.OwPreviewContext;
import com.wewebu.ow.server.ui.preview.OwPreviewRenderer;
import com.wewebu.ow.server.util.OwString;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class OwFlashPreviewRenderer
implements OwPreviewRenderer {
    public static final String REQ_ATT_CFG = "FlashPreviewRenderer_cfg";
    private static final String ALLOW_FULLSCREEN = "allowfullscreen";
    private static final String ALLOW_SCRIPTACCESS = "allowScriptAccess";
    private static final String ALLOW_NETWORKING = "allowNetworking";
    private static final String QUALITY = "high";
    private static final String FILE_NAME = "fileName";
    private static final String PAGING = "paging";
    private static final String URL = "url";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String WMODE = "wmode";
    private static final List<String> NON_FLASHVARS_EXTENSION = Arrays.asList("fileName", "paging", "url", "width", "height", "wmode");

    @Override
    public void render(Writer writer, Map<String, String> configuration, OwPreviewContext prevContext) throws OwException, IOException {
        try {
            String fileName = this.createFlashParameter(FILE_NAME, configuration, prevContext, prevContext.getObject().getName());
            String paging = this.createFlashParameter(PAGING, configuration, prevContext, true);
            OwAppContext appContext = prevContext.getAppContext();
            String url = this.createFlashParameter(URL, configuration, prevContext, appContext.getBaseURL() + "/swfpreview?dmsid=" + OwAppContext.encodeURL(prevContext.getObject().getDMSID()));
            String otherFlashVars = this.createOtherFlashParameters(NON_FLASHVARS_EXTENSION, configuration, prevContext);
            String i18n_actualSize = "i18n_actualSize=" + OwAppContext.encodeURL(appContext.localize("OwFlashPreviewRenderer.i18n_actualSize", "Actual Size"));
            String i18n_fitPage = "i18n_fitPage=" + OwAppContext.encodeURL(appContext.localize("OwFlashPreviewRenderer.i18n_fitPage", "Fit Page"));
            String i18n_fitWidth = "i18n_fitWidth=" + OwAppContext.encodeURL(appContext.localize("OwFlashPreviewRenderer.i18n_fitWidth", "Fit Width"));
            String i18n_fitHeight = "i18n_fitHeight=" + OwAppContext.encodeURL(appContext.localize("OwFlashPreviewRenderer.i18n_fitHeight", "Fit Height"));
            String i18n_fullscreen = "i18n_fullscreen=" + OwAppContext.encodeURL(appContext.localize("OwFlashPreviewRenderer.i18n_fullscreen", "Full Screen"));
            String i18n_fullwindow = "i18n_fullwindow=" + OwAppContext.encodeURL(appContext.localize("OwFlashPreviewRenderer.i18n_fullwindow", "Maximize"));
            String i18n_fullwindow_escape = "i18n_fullwindow_escape=" + OwAppContext.encodeURL(appContext.localize("OwFlashPreviewRenderer.i18n_fullwindow_escape", "Press Esc to exit full window mode."));
            String i18n_page = "i18n_page=" + OwAppContext.encodeURL(appContext.localize("OwFlashPreviewRenderer.i18n_page", "Page"));
            String i18n_pageOf = "i18n_pageOf=" + OwAppContext.encodeURL(appContext.localize("OwFlashPreviewRenderer.i18n_pageOf", "of"));
            String flashvars = "\"" + this.createFlashVarsValue(fileName, paging, url, i18n_actualSize, i18n_fitPage, i18n_fitWidth, i18n_fitHeight, i18n_fullscreen, i18n_fullwindow, i18n_fullwindow_escape, i18n_page, i18n_pageOf, otherFlashVars) + "\"";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("flashvars", flashvars);
            String width = this.createValue(WIDTH, configuration, prevContext, "100%", null);
            map.put(WIDTH, width);
            String height = this.createValue(HEIGHT, configuration, prevContext, "600px", null);
            map.put(HEIGHT, height);
            String quality = this.createValue(QUALITY, configuration, prevContext, QUALITY, null);
            map.put("quality", quality);
            String allowNetworking = this.createValue(ALLOW_NETWORKING, configuration, prevContext, "all", null);
            map.put(ALLOW_NETWORKING, allowNetworking);
            String allowScriptAccess = this.createValue(ALLOW_SCRIPTACCESS, configuration, prevContext, "sameDomain", null);
            map.put(ALLOW_SCRIPTACCESS, allowScriptAccess);
            String allowFullScreen = this.createValue(ALLOW_FULLSCREEN, configuration, prevContext, "true", null);
            map.put("allowFullScreen", allowFullScreen);
            String wmode = this.createValue(WMODE, configuration, prevContext, "transparent", null);
            map.put(WMODE, wmode);
            HttpServletRequest httpRequest = appContext.getHttpRequest();
            httpRequest.setAttribute(REQ_ATT_CFG, map);
            appContext.serverSideInclude("/viewer/preview/FlashPreviewRenderer.jsp", writer);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Preview rendering error.", (Throwable)e);
        }
    }

    private String createFlashParameter(String name, Map<String, String> configuration, OwPreviewContext prevContext, Object defaultValue) throws OwInvalidOperationException {
        String value = this.createValue(name, configuration, prevContext, defaultValue, null);
        return name + "=" + value;
    }

    private String createHTMLParameter(String name, Map<String, String> configuration, OwPreviewContext prevContext, Object defaultValue) throws OwInvalidOperationException {
        String value = this.createValue(name, configuration, prevContext, defaultValue, "\"");
        return name + "=" + value;
    }

    private String createValue(String name, Map<String, String> configuration, OwPreviewContext prevContext, Object defaultValue, String quote) throws OwInvalidOperationException {
        try {
            StringBuilder value = new StringBuilder(configuration.containsKey(name) ? configuration.get(name) : defaultValue.toString());
            OwString.replaceAll(value, "{baseurl}", prevContext.getAppContext().getBaseURL());
            OwString.replaceAll(value, "{dmsid}", prevContext.getObject().getDMSID());
            value = new StringBuilder(OwAppContext.encodeURL(value.toString()));
            if (quote != null) {
                return quote + value + quote;
            }
            return value.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new OwInvalidOperationException("Error creating parameter.", (Throwable)e);
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Error creating parameter.", (Throwable)e);
        }
    }

    private String createOtherFlashParameters(List<String> omitNames, Map<String, String> configuration, OwPreviewContext prevContext) throws OwInvalidOperationException {
        Set<String> parameters = configuration.keySet();
        StringBuilder flashParameters = new StringBuilder();
        for (String paramerer : parameters) {
            if (omitNames.contains(paramerer)) continue;
            if (flashParameters.length() > 0) {
                flashParameters.append("&");
            }
            flashParameters.append(this.createFlashParameter(paramerer, configuration, prevContext, null));
        }
        return flashParameters.toString();
    }

    private String createFlashVarsValue(String ... vars) {
        StringBuilder flashVars = new StringBuilder();
        if (vars != null) {
            if (vars.length > 0) {
                flashVars.append(vars[0]);
            }
            for (int i = 1; i < vars.length; ++i) {
                flashVars.append("&");
                flashVars.append(vars[i]);
            }
        }
        return flashVars.toString();
    }
}

