/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui.preview;

import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInaccessibleException;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.ui.preview.OwPreviewContext;
import com.wewebu.ow.server.ui.preview.OwPreviewRenderer;
import com.wewebu.ow.server.util.OwString;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class OwImagePreviewRenderer
implements OwPreviewRenderer {
    @Override
    public void render(Writer writer, Map<String, String> configuration, OwPreviewContext prevContext) throws OwException, IOException {
        String src = configuration.get("url");
        src = OwString.replaceAll(src, "{baseurl}", prevContext.getAppContext().getBaseURL());
        try {
            src = OwString.replaceAll(src, "{dmsid}", OwAppContext.encodeURL(prevContext.getObject().getDMSID()));
        }
        catch (Exception e) {
            throw new OwInaccessibleException(prevContext.getAppContext().localize("OwImagePreviewRenderer.render.err.dmsid", "Could not access DMSID."), (Throwable)e);
        }
        writer.write("<img src=\"");
        writer.write(src);
        writer.write("\" alt=\"");
        writer.write(prevContext.getObject().getName());
        writer.write("\" >");
    }
}

