/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui.preview;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.ui.preview.OwPreviewContext;
import com.wewebu.ow.server.ui.preview.OwPreviewRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class OwNoPreviewRenderer
implements OwPreviewRenderer {
    public static final OwNoPreviewRenderer INSTANCE = new OwNoPreviewRenderer();
    protected OwMimeManager m_MimeManager = new OwMimeManager();

    @Override
    public void render(Writer out, Map<String, String> configuration, OwPreviewContext prevContext) throws OwException, IOException {
        this.m_MimeManager.reset();
        OwMainAppContext context = (OwMainAppContext)prevContext.getAppContext();
        try {
            this.m_MimeManager.attach(context, null);
            this.m_MimeManager.reset();
            String div = "<div class=\"message_download\">" + prevContext.getAppContext().localize("OwNoPreviewRenderer.text", "This document cannot be previewed.") + "<br>";
            out.write(div);
            if (prevContext.getObject().hasContent(2)) {
                this.m_MimeManager.insertHtmlLink(out, prevContext.getAppContext().localize("OwNoPreviewRenderer.textdownload", "Click here to download document."), prevContext.getObject(), null);
            }
            out.write("</div>");
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Error rendering no-preview.", (Throwable)e);
        }
    }
}

