/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui.preview;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.ui.preview.OwFlashPreviewRenderer;
import com.wewebu.ow.server.ui.preview.OwImagePreviewRenderer;
import com.wewebu.ow.server.ui.preview.OwIntegratedPreview;
import com.wewebu.ow.server.ui.preview.OwNoPreviewRenderer;
import com.wewebu.ow.server.ui.preview.OwPreviewContext;
import com.wewebu.ow.server.ui.preview.OwPreviewRenderer;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.service.rendition.OwRenditionService;
import com.wewebu.service.rendition.OwRenditionServiceProvider;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwSimpleIntegratedPreview
extends OwIntegratedPreview
implements OwPreviewContext {
    private static final Logger LOG = OwLogCore.getLogger(OwSimpleIntegratedPreview.class);
    private static final String AT_VALUE = "value";
    private static final String AT_NAME = "name";
    private static final String AT_TYPE = "type";
    private static final String AT_CLASS = "class";
    private static final String ANY_CONTENT_TYPE = "*";
    private static final String EL_CONFIGURATION = "configuration";
    private static final String EL_FILTER = "filter";
    private static final String EL_MIME = "mime";
    private static final String EL_PARAMERTER = "parameter";
    private static final String EL_VIEWER = "viewer";
    private OwXMLUtil configuration;
    private OwObject object;
    private Map<String, OwPreviewRenderer> cachedRenderer = new HashMap<String, OwPreviewRenderer>();
    private Map<String, Map<String, String>> cachedConfig = new HashMap<String, Map<String, String>>();
    private String renditionType;
    private String fullscreen;

    @Override
    protected void init() throws Exception {
        super.init();
        this.renditionType = this.getConfiguration().getSafeStringAttributeValue("rendition", "application/x-shockwave-flash");
        this.fullscreen = this.getConfiguration().getSafeStringAttributeValue("fullScreen", "true");
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        OwRenditionServiceProvider provider = this.getRenditionServiceProvider();
        if (this.getObject() != null) {
            OwRenditionService service = provider.getRendtionService(this.getObject());
            OwPreviewRenderer renderer = this.getNoPreviewRenderer();
            boolean available = service.hasRendition(this.getObject(), this.getRenditionType());
            if (available || service.canCreateRendition(this.getObject(), this.getRenditionType())) {
                List<String> mimeTypes = null;
                try {
                    if (!available) {
                        service.createRendition(this.getObject(), this.getRenditionType());
                    }
                    mimeTypes = service.getRenditionMimeType(this.getObject(), this.getRenditionType());
                }
                catch (OwException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn((Object)"Unable to get/create Rendition for preview", (Throwable)e);
                    }
                    LOG.warn((Object)("OwSimpleIntegratedPreview.onRender(): Unable to get/create Rendition for preview. (" + e.getMessage() + ")"));
                }
                if (mimeTypes != null) {
                    try {
                        renderer = this.getPreviewRenderer(mimeTypes);
                    }
                    catch (OwException ex) {
                        renderer = null;
                        if (LOG.isDebugEnabled()) {
                            LOG.warn((Object)"Unable to get renderer for preview", (Throwable)ex);
                        }
                        LOG.warn((Object)("OwSimpleIntegratedPreview.onRender(): Unable to get renderer for preview. (" + ex.getMessage() + ")"));
                    }
                }
            }
            if (renderer == null) {
                w_p.write(this.getContext().localize("OwSimpleIntegratedPreview.no.renderer.label", "No preview handler available."));
            } else {
                renderer.render(w_p, this.cachedConfig.get(renderer.getClass().getCanonicalName()), this);
            }
        } else {
            w_p.write("No object to handle");
        }
        super.onRender(w_p);
    }

    protected OwPreviewRenderer getPreviewRenderer(List<String> mimeTypes) throws OwException {
        OwPreviewRenderer prevRenderer = null;
        for (String mime : mimeTypes) {
            prevRenderer = this.cachedRenderer.get(mime);
        }
        if (prevRenderer == null) {
            OwXMLUtil rendererConfig = this.findMatchingRendererConfig(mimeTypes);
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (rendererConfig != null) {
                prevRenderer = this.createPreviewRenderer(rendererConfig.getSafeStringAttributeValue(AT_CLASS, null));
                List parameterUtils = rendererConfig.getSafeUtilList(EL_CONFIGURATION, EL_PARAMERTER);
                for (OwXMLUtil parameter : parameterUtils) {
                    String name = parameter.getSafeStringAttributeValue(AT_NAME, null);
                    String value = parameter.getSafeStringAttributeValue(AT_VALUE, null);
                    if (name != null && value != null) {
                        parameters.put(name, value);
                        continue;
                    }
                    throw new OwConfigurationException("Renderer configuration problem, parameter name [" + name + "] and/or value [" + value + "].");
                }
            } else {
                boolean hasConfiguration = this.hasPreviewConfiguration(mimeTypes);
                prevRenderer = !hasConfiguration ? this.getSimpleConfigurationPreviewRanderer(mimeTypes, parameters) : null;
            }
            if (prevRenderer != null) {
                this.cachedConfig.put(prevRenderer.getClass().getCanonicalName(), parameters);
                for (String mime : mimeTypes) {
                    this.cachedRenderer.put(mime, prevRenderer);
                }
            }
        }
        return prevRenderer;
    }

    protected OwXMLUtil findMatchingRendererConfig(List<String> mimeType_p) throws OwConfigurationException {
        List viewers = this.getConfiguration().getSafeUtilList(EL_VIEWER);
        OwXMLUtil anyContentViewer = null;
        for (OwXMLUtil viewer : viewers) {
            List filterMimes = viewer.getSafeUtilList(EL_FILTER, EL_MIME);
            for (OwXMLUtil filter : filterMimes) {
                String mimeType = filter.getSafeStringAttributeValue(AT_TYPE, null);
                if (mimeType == null) continue;
                if (ANY_CONTENT_TYPE.equals(mimeType)) {
                    anyContentViewer = viewer;
                }
                if (!mimeType_p.contains(mimeType)) continue;
                return viewer;
            }
        }
        return anyContentViewer;
    }

    protected OwPreviewRenderer createPreviewRenderer(String rendererClass) throws OwException {
        try {
            Class<?> clazz = Class.forName(rendererClass);
            OwPreviewRenderer newInstance = (OwPreviewRenderer)clazz.newInstance();
            return newInstance;
        }
        catch (ClassNotFoundException e) {
            throw new OwConfigurationException("Could not find configured class: " + rendererClass, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new OwConfigurationException("Cannot instantiate configured class: " + rendererClass, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new OwServerException("Failed to access defined class: " + rendererClass, (Throwable)e);
        }
    }

    protected OwPreviewRenderer getNoPreviewRenderer() {
        return OwNoPreviewRenderer.INSTANCE;
    }

    protected OwRenditionServiceProvider getRenditionServiceProvider() {
        return this.getContext().getRegisteredInterface(OwRenditionServiceProvider.class);
    }

    @Override
    public void setConfiguration(OwXMLUtil configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setObject(OwObject object) {
        this.object = object;
    }

    @Override
    public OwObject getObject() {
        return this.object;
    }

    protected OwXMLUtil getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getRenditionType() {
        return this.renditionType;
    }

    @Override
    public OwAppContext getAppContext() {
        return this.getContext();
    }

    private boolean hasPreviewConfiguration(List<String> mimeType_p) throws OwConfigurationException {
        List viewers = this.getConfiguration().getSafeUtilList(EL_VIEWER);
        boolean hasConfiguration = false;
        if (viewers.size() > 0) {
            hasConfiguration = true;
        }
        return hasConfiguration;
    }

    protected OwPreviewRenderer getSimpleConfigurationPreviewRanderer(List<String> mimeTypes, Map<String, String> parameters) throws OwException {
        OwPreviewRenderer prevRenderer;
        boolean imageRenderer = false;
        for (String mime : mimeTypes) {
            if (!mime.startsWith("image") || mime.endsWith("/tiff") || mime.endsWith("/tif")) continue;
            imageRenderer = true;
            break;
        }
        if (imageRenderer) {
            prevRenderer = this.createPreviewRenderer(OwImagePreviewRenderer.class.getCanonicalName());
            parameters.put("url", "{baseurl}/rendition?dmsid={dmsid}&rendition=" + this.renditionType);
        } else {
            prevRenderer = this.createPreviewRenderer(OwFlashPreviewRenderer.class.getCanonicalName());
            parameters.put("width", "100%");
            parameters.put("height", "600px");
            parameters.put("paging", "true");
            parameters.put("quality", "high");
            parameters.put("show_fullscreen_button", this.fullscreen);
            parameters.put("allowfullscreen", this.fullscreen);
            parameters.put("disable_i18n_input_fix", "false");
            parameters.put("url", "{baseurl}/rendition?dmsid={dmsid}&rendition=" + this.renditionType);
        }
        return prevRenderer;
    }
}

