/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui.viewer;

import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.ui.viewer.OwAnnotInfoEnum;
import com.wewebu.ow.server.ui.viewer.OwAnnotationInfoProvider;
import com.wewebu.ow.server.ui.viewer.OwInfoRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public abstract class OwAbstractAnnotationInfoProvider<T>
implements OwAnnotationInfoProvider {
    @Override
    public void handleRequest(OwInfoRequest req, OutputStream answer) throws OwException, IOException {
        StringBuilder msg = new StringBuilder();
        List<T> lst = this.getAnnotations(req.getParameter("dmsid"));
        if (!lst.isEmpty()) {
            String stag = "<";
            String etag = "</";
            String ctag = ">";
            msg.append(stag).append("permissions").append(ctag);
            for (T annotation : lst) {
                msg.append(stag).append("permission").append(ctag);
                msg.append(stag).append("id").append(ctag);
                msg.append(this.getId(annotation));
                msg.append(etag).append("id").append(ctag);
                for (OwAnnotInfoEnum annoEnum : OwAnnotInfoEnum.values()) {
                    msg.append(stag).append(annoEnum.getType()).append(ctag);
                    msg.append(this.getAnnotationInfo(annotation, annoEnum.getType()));
                    msg.append(etag).append(annoEnum.getType()).append(ctag);
                }
                msg.append(etag).append("permission").append(ctag);
            }
            msg.append(etag).append("permissions").append(ctag);
            this.sendAnswer(answer, msg.toString());
        }
    }

    protected void sendAnswer(OutputStream answerStream, String message) throws UnsupportedEncodingException, IOException {
        answerStream.write(message.toString().getBytes("UTF-8"));
    }

    protected abstract String getId(T var1);

    protected abstract List<T> getAnnotations(String var1);

    protected abstract String getAnnotationInfo(T var1, String var2);
}

