/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui.viewer;

import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.ui.viewer.OwInfoProvider;
import com.wewebu.ow.server.ui.viewer.OwInfoRequest;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class OwAbstractInfoProvider
implements OwInfoProvider {
    @Override
    public void handleRequest(OwInfoRequest request_p, OutputStream answer_p) throws OwException, IOException {
        try {
            Document doc = OwXMLDOMUtil.getDocumentFromInputStream(request_p.getRequestBody());
            Node root = doc.getFirstChild();
            NodeList children = root.getChildNodes();
            StringBuilder answer = new StringBuilder("<?xml version=\"1.0\"?>");
            answer.append("<").append(root.getNodeName()).append(">");
            for (int i = 0; i < children.getLength(); ++i) {
                String ret;
                Node item = children.item(i);
                String tagName = item.getNodeName();
                if (item.getFirstChild().getNodeType() == 3) {
                    tagName = item.getFirstChild().getNodeValue();
                }
                if ((ret = this.process(item)) != null) {
                    answer.append("<").append(tagName).append(">");
                    answer.append(ret);
                    answer.append("</").append(tagName).append(">");
                    continue;
                }
                answer.append("<").append(tagName).append(" />");
            }
            answer.append("</").append(root.getNodeName()).append(">");
            this.sendAnswer(answer.toString(), answer_p);
        }
        catch (SAXException e) {
            throw new OwInvalidOperationException("Invalid XML structure", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new OwServerException("Could not load or instantiate parser from JVM configuration!", (Throwable)e);
        }
    }

    protected void sendAnswer(String answer_p, OutputStream sendStream_p) throws UnsupportedEncodingException, IOException {
        sendStream_p.write(answer_p.getBytes("UTF-8"));
    }

    protected abstract String process(Node var1);
}

