/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import com.wewebu.ow.server.exceptions.OwDataSourceException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwAttributeBag;
import com.wewebu.ow.server.util.OwTableSpec;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class OwStandardDBInvertedAttributeBag
implements OwAttributeBag {
    private static final Logger LOG = OwLogCore.getLogger(OwStandardDBInvertedAttributeBag.class);
    public static final String ATTRIBUTE_USER = "UserName";
    public static final String ATTRIBUTE_BAGNAME = "BagName";
    public static final String ATTRIBUTE_ATTR_NAME = "AttributeName";
    public static final String ATTRIBUTE_ATTR_VALUE = "AttributeValue";
    protected HashMap m_attributes = new HashMap();

    public OwStandardDBInvertedAttributeBag(JdbcTemplate jdbc_p, String bagname_p, String attributename_p, String strTable_p) throws OwDataSourceException {
        if (jdbc_p == null) {
            String msg = "OwStandardDBInvertedAttributeBag is not been initialized with a DB, it cannot be used, jdbc_p == null.";
            throw new OwDataSourceException(msg);
        }
        String statement = "select UserName,AttributeValue from " + strTable_p + " where (" + ATTRIBUTE_BAGNAME + " = ?) and (" + ATTRIBUTE_ATTR_NAME + " = ?)";
        Object[] params = new Object[]{bagname_p, attributename_p};
        jdbc_p.query(statement, params, new RowCallbackHandler(){

            public void processRow(ResultSet rs_p) throws SQLException {
                String attributeUser = rs_p.getString(OwStandardDBInvertedAttributeBag.ATTRIBUTE_USER);
                String attributeValue = rs_p.getString(OwStandardDBInvertedAttributeBag.ATTRIBUTE_ATTR_VALUE);
                OwStandardDBInvertedAttributeBag.this.m_attributes.put(attributeUser, attributeValue);
            }
        });
    }

    public OwStandardDBInvertedAttributeBag(JdbcTemplate jdbc_p, String bagname_p, String attributename_p, OwTableSpec attributeBagTable) throws OwDataSourceException {
        if (jdbc_p == null) {
            String msg = "OwStandardDBInvertedAttributeBag is not been initialized with a DB, it cannot be used, jdbc_p == null.";
            throw new OwDataSourceException(msg);
        }
        Connection connection = null;
        String catalogSeparator = null;
        try {
            connection = jdbc_p.getDataSource().getConnection();
            catalogSeparator = connection.getMetaData().getCatalogSeparator();
            if (catalogSeparator.isEmpty()) {
                catalogSeparator = ".";
            }
        }
        catch (SQLException e) {
            throw new OwDataSourceException("DBAttributeBag initialisation error, cannot read the DB metadata.", (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Could not close connection.", (Throwable)e);
                }
                connection = null;
            }
        }
        String fullyQualifiedName = attributeBagTable.fullyQualifiedName(catalogSeparator);
        String statement = "select UserName,AttributeValue from " + fullyQualifiedName + " where (" + ATTRIBUTE_BAGNAME + " = ?) and (" + ATTRIBUTE_ATTR_NAME + " = ?)";
        Object[] params = new Object[]{bagname_p, attributename_p};
        jdbc_p.query(statement, params, new RowCallbackHandler(){

            public void processRow(ResultSet rs_p) throws SQLException {
                String attributeUser = rs_p.getString(OwStandardDBInvertedAttributeBag.ATTRIBUTE_USER);
                String attributeValue = rs_p.getString(OwStandardDBInvertedAttributeBag.ATTRIBUTE_ATTR_VALUE);
                OwStandardDBInvertedAttributeBag.this.m_attributes.put(attributeUser, attributeValue);
            }
        });
    }

    @Override
    public int attributecount() {
        return this.m_attributes.size();
    }

    @Override
    public Object getAttribute(int index_p) throws Exception {
        throw new OwInvalidOperationException("OwStandardDBInvertedAttributeBag.getAttribute(int iIndex_p): not implemented.");
    }

    @Override
    public Object getAttribute(String strName_p) throws Exception {
        if (!this.m_attributes.containsKey(strName_p)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OwStandardDBAttributeBagWriteableFactory.getAttribute: Object not found Exception, strName_p = " + strName_p));
            }
            throw new OwObjectNotFoundException("OwStandardDBInvertedAttributeBag.getAttribute: strName_p = " + strName_p);
        }
        return this.m_attributes.get(strName_p);
    }

    @Override
    public Collection getAttributeNames() {
        return this.m_attributes.keySet();
    }

    @Override
    public Object getSafeAttribute(String strName_p, Object default_p) {
        if (!this.m_attributes.containsKey(strName_p)) {
            return default_p;
        }
        return this.m_attributes.get(strName_p);
    }

    @Override
    public boolean hasAttribute(String strName_p) {
        return this.m_attributes.containsKey(strName_p);
    }
}

