/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class OwTimeZoneInfo {
    private static final List<String> SOUTHERN_TIMEZONES = Arrays.asList("Pacific/Apia", "Pacific/Easter", "America/Asuncion", "America/Montevideo", "Africa/Windhoek", "Australia/Eucla", "Australia/Adelaide", "Australia/Sydney", "Australia/Lord_Howe", "Pacific/Auckland", "Pacific/Chatham");
    private static final Map<String, Set<Long>> ZONE_TRANSITIONS = OwTimeZoneInfo.findAllDSTTransitions();
    private static Set<Long> DST_TRANSITIONS = null;
    private int offset;
    private boolean observesDaylightSavings;
    private boolean northernHemisphere;
    private long date;
    private TimeZone timeZone = null;
    private Set<Long> transitions = Collections.EMPTY_SET;

    public static Set<Long> findDSTTransitions(TimeZone zone_p) {
        HashSet<Long> transitions = new HashSet<Long>();
        Calendar day = Calendar.getInstance();
        day.set(1, 2011);
        day.set(6, 1);
        day.set(9, 1);
        day.set(11, 15);
        day.set(12, 0);
        day.set(13, 0);
        day.set(14, 0);
        int initialYear = day.get(1);
        while (day.get(1) == initialYear) {
            Calendar nextDay = Calendar.getInstance();
            nextDay.setTimeInMillis(day.getTimeInMillis());
            nextDay.add(6, 1);
            int offset = zone_p.getOffset(day.getTimeInMillis());
            int nextOffset = zone_p.getOffset(nextDay.getTimeInMillis());
            if (offset != nextOffset) {
                transitions.add(day.getTimeInMillis());
            }
            day = nextDay;
        }
        return Collections.unmodifiableSet(transitions);
    }

    private static synchronized Map<String, Set<Long>> findAllDSTTransitions() {
        HashMap<String, Set<Long>> allTransitions = new HashMap<String, Set<Long>>();
        String[] ids = TimeZone.getAvailableIDs();
        for (int i = 0; i < ids.length; ++i) {
            TimeZone zone = TimeZone.getTimeZone(ids[i]);
            Set<Long> zoneTransitions = OwTimeZoneInfo.findDSTTransitions(zone);
            allTransitions.put(zone.getID(), zoneTransitions);
        }
        return Collections.unmodifiableMap(allTransitions);
    }

    public static Set<Long> getZoneDSTTransitions(String timeZoneID_p) {
        return ZONE_TRANSITIONS.get(timeZoneID_p);
    }

    public static synchronized Set<Long> getDSTTrasitions() {
        if (DST_TRANSITIONS == null) {
            HashSet<Long> dstTransitions = new HashSet<Long>();
            Collection<Set<Long>> allZoneTransitions = ZONE_TRANSITIONS.values();
            for (Set<Long> transition : allZoneTransitions) {
                dstTransitions.addAll(transition);
            }
            DST_TRANSITIONS = Collections.unmodifiableSet(dstTransitions);
        }
        return DST_TRANSITIONS;
    }

    public OwTimeZoneInfo() {
        this(TimeZone.getDefault());
    }

    public OwTimeZoneInfo(TimeZone timeZone_p) {
        this(new Date(), timeZone_p);
    }

    public OwTimeZoneInfo(Date reference_p, TimeZone timeZone_p) {
        this.timeZone = timeZone_p;
        this.date = reference_p.getTime();
        this.offset = this.timeZone.getOffset(this.date);
        this.observesDaylightSavings = this.timeZone.getDSTSavings() != 0;
        this.transitions = OwTimeZoneInfo.getZoneDSTTransitions(timeZone_p.getID());
        this.northernHemisphere = OwTimeZoneInfo.isNorthernHemisphere(this.timeZone);
    }

    public OwTimeZoneInfo(long date_p, int offset_p, boolean observesDaylightSavings_p, Long[] transitions_p, boolean northernHemisphere_p) {
        this.offset = offset_p;
        this.observesDaylightSavings = observesDaylightSavings_p;
        this.transitions = new HashSet<Long>(Arrays.asList(transitions_p));
        this.northernHemisphere = northernHemisphere_p;
        this.date = date_p;
    }

    public synchronized TimeZone getTimeZone() {
        if (this.timeZone == null) {
            String[] ids = TimeZone.getAvailableIDs();
            for (int i = 0; i < ids.length; ++i) {
                Set<Long> zoneTransitions;
                int dst;
                TimeZone timeZone = TimeZone.getTimeZone(ids[i]);
                int tzOffset = timeZone.getOffset(this.date);
                if (this.offset != tzOffset || this.observesDaylightSavings != ((dst = timeZone.getDSTSavings()) != 0) || !this.sameTrasitions(this.transitions, zoneTransitions = OwTimeZoneInfo.getZoneDSTTransitions(timeZone.getID())) || this.northernHemisphere != OwTimeZoneInfo.isNorthernHemisphere(timeZone)) continue;
                return timeZone;
            }
        }
        return this.timeZone;
    }

    private static boolean isNorthernHemisphere(TimeZone timeZone) {
        return !SOUTHERN_TIMEZONES.contains(timeZone.getID());
    }

    public boolean isNorthernHemisphere() {
        return this.northernHemisphere;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isObservesDaylightSavings() {
        return this.observesDaylightSavings;
    }

    public int hashCode() {
        return Integer.valueOf(this.offset).hashCode();
    }

    private boolean sameTrasitions(Set<Long> t1_p, Set<Long> t2_p) {
        if (t1_p == null) {
            return t2_p == null;
        }
        if (t2_p == null) {
            return false;
        }
        if (t1_p.size() == t2_p.size()) {
            return t1_p.containsAll(t2_p);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OwTimeZoneInfo) {
            OwTimeZoneInfo info = (OwTimeZoneInfo)obj;
            return this.date == info.date && this.offset == info.offset && this.observesDaylightSavings == info.observesDaylightSavings && this.northernHemisphere == info.northernHemisphere && this.sameTrasitions(this.transitions, info.transitions);
        }
        return false;
    }

    public String toString() {
        TimeZone tz = this.getTimeZone();
        return "OwTimeZoneInfo[date=" + this.date + " offset=" + this.offset + " dst=" + this.observesDaylightSavings + " northern=" + this.northernHemisphere + " tzID=" + (tz == null ? "<unknown>" : tz.getID() + " aka " + tz.getDisplayName()) + "]";
    }
}

