/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.ldap;

import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.ldap.GUID;
import com.wewebu.ow.server.util.ldap.OwBasicLdapSchemaInterpreter;
import com.wewebu.ow.server.util.ldap.OwLDAPGroupInfo;
import com.wewebu.ow.server.util.ldap.OwLdapConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.log4j.Logger;

public class OwADSchemaInterpreter
extends OwBasicLdapSchemaInterpreter {
    private static final Logger LOG = OwLogCore.getLogger(OwADSchemaInterpreter.class);
    private static final String BINARY_ATTRIBUTES_PROPETY = "java.naming.ldap.attributes.binary";
    private static final String DEFAULT_NAME_OBJECTGUID = "objectGUID";

    @Override
    public Collection<String> getAllShortGroupNames(OwLdapConnection connection_p) throws OwAuthenticationException, OwConfigurationException, OwInvalidOperationException {
        String searchBase = connection_p.getProperty("GroupsDirectory", "CN=Users,DC=wewebu-virtual,DC=local");
        return connection_p.searchAttributeValues(searchBase, new String[][]{{"objectCategory", "group"}}, "cn");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getShortGroupNames(OwLdapConnection connection_p) throws OwAuthenticationException, OwConfigurationException, OwInvalidOperationException {
        InitialLdapContext ctx = null;
        ArrayList<String> groupList = new ArrayList<String>();
        try {
            ctx = connection_p.createInitialDirContext();
            String distinguisehName = connection_p.getUserDistinguishedName();
            String attributeNameMemberOf = connection_p.getProperty("AttributeNameMemberOf", "memberof");
            int recursionLevel = connection_p.getRecursionLevel();
            this.getGroups(recursionLevel, distinguisehName, attributeNameMemberOf, groupList, ctx);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
                ctx = null;
            }
        }
        return groupList;
    }

    private void getGroups(int recursionLevel_p, String distinguishedName_p, String attributeNameMemberOf_p, List<String> groupList_p, InitialDirContext ctx_p) throws OwInvalidOperationException, OwAuthenticationException {
        try {
            Attributes attrs = ctx_p.getAttributes(distinguishedName_p);
            Attribute memberOf = attrs.get(attributeNameMemberOf_p);
            if (memberOf == null) {
                return;
            }
            NamingEnumeration<?> groups = memberOf.getAll();
            while (groups.hasMore()) {
                String group = (String)groups.next();
                if (recursionLevel_p > 0) {
                    this.getGroups(recursionLevel_p - 1, group, attributeNameMemberOf_p, groupList_p, ctx_p);
                }
                groupList_p.add(this.extractGroupName(group));
            }
        }
        catch (AuthenticationException e) {
            String msg = "Exception creating InitialDirContext for LDAP. Could not authenticate the user, distinguishedName=" + distinguishedName_p;
            LOG.debug((Object)msg, (Throwable)e);
            throw new OwAuthenticationException(msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Exception getting Groups: attribute=\"" + attributeNameMemberOf_p + "\", recursionLevel=" + recursionLevel_p + ", distinguishedName=" + distinguishedName_p;
            LOG.error((Object)msg, (Throwable)e);
            throw new OwInvalidOperationException(msg, (Throwable)e);
        }
    }

    private String extractGroupName(String group_p) {
        StringTokenizer tokenizer = new StringTokenizer(group_p, ",");
        String groupEntry = tokenizer.nextToken();
        String groupName = groupEntry.substring(3);
        return groupName;
    }

    @Override
    protected String getDisplayNameAttName(OwLdapConnection connection_p) {
        String attDisplayName = connection_p.getProperty("AttributeNameUserDisplayName", "cn");
        return attDisplayName;
    }

    @Override
    public String getUserShortName(OwLdapConnection connection_p) throws OwAuthenticationException, OwConfigurationException, OwInvalidOperationException {
        String shortNameAttribute = connection_p.getProperty("AttributeNameShortName", "samAccountName");
        return connection_p.getUserAttributeValue(shortNameAttribute, true);
    }

    @Override
    public String getUserLongName(OwLdapConnection connection_p) throws OwAuthenticationException, OwConfigurationException, OwInvalidOperationException {
        String longNameAttribute = connection_p.getProperty("AttributeNameLongName", "name");
        return connection_p.getUserAttributeValue(longNameAttribute, true);
    }

    @Override
    public String getUserId(OwLdapConnection connection_p) throws OwAuthenticationException, OwInvalidOperationException, OwConfigurationException {
        String objectGUIDAttribute = this.getObjectIdAttribute(connection_p);
        Object guid = connection_p.getUserAttributeValue(objectGUIDAttribute);
        byte[] asBytes = (byte[])guid;
        String strGUID = this.convertGUID(asBytes);
        return strGUID;
    }

    private String convertGUID(byte[] inArr_p) {
        GUID guid = new GUID(inArr_p);
        return guid.toString();
    }

    private void addBinaryProperty(Properties properties_p, String propertyName_p) {
        String binProperties = (String)properties_p.get(BINARY_ATTRIBUTES_PROPETY);
        if (binProperties == null) {
            binProperties = "";
        }
        binProperties = binProperties + " " + propertyName_p;
        properties_p.put(BINARY_ATTRIBUTES_PROPETY, binProperties);
    }

    @Override
    public void init(Properties ldapProperties_p, Properties adminLdapProperties_p) throws OwConfigurationException {
        this.addBinaryProperty(ldapProperties_p, ldapProperties_p.getProperty("AttributeNameObjectGUID", DEFAULT_NAME_OBJECTGUID));
        this.addBinaryProperty(adminLdapProperties_p, adminLdapProperties_p.getProperty("AttributeNameObjectGUID", DEFAULT_NAME_OBJECTGUID));
    }

    @Override
    protected String getObjectIdAttribute(OwLdapConnection connection_p) {
        String objectGUIDAttribute = connection_p.getProperty("AttributeNameObjectGUID", DEFAULT_NAME_OBJECTGUID);
        return objectGUIDAttribute;
    }

    @Override
    public OwObjectCollection findUserMatching(OwLdapConnection connection, String pattern) throws OwException {
        String searchBase = connection.getProperty("UsersDirectory", "CN=Users,DC=wewebu-virtual,DC=local");
        String filter = "(& (cn=" + pattern + ") (!(groupType=*)) )";
        return connection.searchValuesByFilter(searchBase, filter, "distinguishedName", "cn");
    }

    @Override
    public OwObjectCollection findGroupsMatching(OwLdapConnection connection, String pattern) throws OwException {
        String searchBase = connection.getProperty("GroupsDirectory", "CN=Users,DC=wewebu-virtual,DC=local");
        try {
            NamingEnumeration<SearchResult> answer = connection.search(searchBase, new String[][]{{"cn", pattern}, {"objectCategory", "group"}}, new String[]{"cn"});
            OwStandardObjectCollection groups = new OwStandardObjectCollection();
            while (answer.hasMoreElements()) {
                SearchResult sr = (SearchResult)answer.nextElement();
                String dn = sr.getNameInNamespace();
                String cn = "";
                Attribute cnAtt = sr.getAttributes().get("cn");
                if (null != cnAtt) {
                    cn = (String)cnAtt.get();
                }
                groups.add(new OwLDAPGroupInfo(dn, cn));
            }
            return groups;
        }
        catch (NamingException e) {
            throw new OwInvalidOperationException("Could not search by filter.", (Throwable)e);
        }
    }

    @Override
    public String getRecordId(String dname, OwLdapConnection connection) throws OwException {
        String objectGUIDAttribute = this.getObjectIdAttribute(connection);
        Object guid = connection.getAttributeValue(dname, objectGUIDAttribute);
        byte[] asBytes = (byte[])guid;
        String strGUID = this.convertGUID(asBytes);
        return strGUID;
    }

    @Override
    protected String getUserLoginAttribute(OwLdapConnection connection_p) {
        String userLoginNameAttribute = connection_p.getProperty("loginQueryName", "sAMAccountName");
        return userLoginNameAttribute;
    }
}

