/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.ldap;

import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.ldap.OwLDAPUserInfo;
import com.wewebu.ow.server.util.ldap.OwLdapConnection;
import com.wewebu.ow.server.util.ldap.OwLdapSchemaInterpreter;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.log4j.Logger;

public abstract class OwBasicLdapSchemaInterpreter
implements OwLdapSchemaInterpreter {
    private static final Logger LOG = OwLogCore.getLogger(OwBasicLdapSchemaInterpreter.class);
    protected static final String LOGIN_QUERY_NAME = "loginQueryName";
    protected static final String DISTINGUISHED_NAME = "distinguishedName";
    protected static final String GROUPS_DIRECTORY_PROPERTY = "GroupsDirectory";
    protected static final String LDAP_COUNT_LIMIT_PROPERTY = "LdapCountLimit";
    protected static final String USER_DISPLAY_NAME_PROPERTY = "AttributeNameUserDisplayName";
    protected static final String NAME_MEMBER_OF_PROPERTY = "AttributeNameMemberOf";
    protected static final String NAME_OBJECTGUID_PROPERTY = "AttributeNameObjectGUID";
    protected static final String NAME_SHORTNAME_PROPERTY = "AttributeNameShortName";
    protected static final String NAME_LONGNAME_PROPERTY = "AttributeNameLongName";
    protected static final String GROUPS_OBJECT_CLASS_PROPERTY = "GroupsObjectClass";
    protected static final String GROUP_REFERENCE_ATTRIBUTE_PROPERTY = "GroupReferenceAttribute";
    protected static final String USER_GROUP_REFERENCE_PROPERTY = "UserGroupReference";

    @Override
    public String findDistinguishedNameAnonymously(String user_p, OwLdapConnection connection_p) throws OwAuthenticationException, OwConfigurationException {
        String distinguishedNameAttribute = "distinguishedName:";
        String searchRoot = null;
        NamingEnumeration<SearchResult> answer = null;
        String distinguishedName = null;
        InitialLdapContext ctx = null;
        try {
            ctx = connection_p.createInitialDirContext();
            Properties connectionProperties = connection_p.getProperties();
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setTimeLimit(120000);
            String[] attr = new String[]{DISTINGUISHED_NAME};
            ctls.setReturningAttributes(attr);
            BasicAttributes matchAttrs = new BasicAttributes(true);
            String loginQueryName = (String)connectionProperties.get(LOGIN_QUERY_NAME);
            matchAttrs.put(new BasicAttribute(loginQueryName, user_p));
            searchRoot = (String)connectionProperties.get("UsersDirectory");
            String filter = loginQueryName + "=" + user_p;
            answer = ctx.search(searchRoot, filter, ctls);
            while (answer.hasMoreElements()) {
                SearchResult sr = (SearchResult)answer.nextElement();
                try {
                    distinguishedName = sr.getNameInNamespace();
                    break;
                }
                catch (UnsupportedOperationException ex) {
                    Attributes dnAttrs = sr.getAttributes();
                    if (dnAttrs == null) continue;
                    NamingEnumeration<? extends Attribute> attrEnum = dnAttrs.getAll();
                    while (attrEnum.hasMore()) {
                        BasicAttribute ba = (BasicAttribute)attrEnum.next();
                        String baString = ba.toString();
                        distinguishedName = baString.substring("distinguishedName:".length());
                    }
                }
            }
        }
        catch (NamingException e) {
            String msg = "LDAP Authentication failed. It seems that the \"(UsersDirectory)\" node in owbootstrap.xml is wrong! Maybe the specified domain is wrong = " + searchRoot;
            LOG.error((Object)msg, (Throwable)e);
            throw new OwConfigurationException(msg, (Throwable)e);
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                }
                catch (NamingException e2) {}
                answer = null;
            }
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
                ctx = null;
            }
        }
        if (distinguishedName == null) {
            throw new OwAuthenticationException("OwLdapConnector.findDistinguishedNameAnonymously: LDAP Authentication failed. The user you specified could not be found in the LDAP directory, Username = " + user_p);
        }
        return distinguishedName;
    }

    @Override
    public void init(Properties ldapProperties_p, Properties adminLdapProperties_p) throws OwConfigurationException {
    }

    @Override
    public OwUserInfo findUserByDNAnonymously(String strID_p, OwLdapConnection connection_p) throws OwException {
        String attrNameToFindBy = DISTINGUISHED_NAME;
        return this.findUserBy(strID_p, connection_p, attrNameToFindBy);
    }

    @Override
    public OwUserInfo findUserByIdAnonymously(String strID_p, OwLdapConnection connection_p) throws OwException {
        String attrNameToFindBy = this.getObjectIdAttribute(connection_p);
        return this.findUserBy(strID_p, connection_p, attrNameToFindBy);
    }

    @Override
    public OwUserInfo findUserByLoginAnonymously(String strID_p, OwLdapConnection connection_p) throws OwException {
        String attrNameToFindBy = this.getUserLoginAttribute(connection_p);
        return this.findUserBy(strID_p, connection_p, attrNameToFindBy);
    }

    private OwUserInfo findUserBy(String strID_p, OwLdapConnection connection_p, String attrNameToFindBy) throws OwConfigurationException, OwObjectNotFoundException {
        String searchRoot = null;
        NamingEnumeration<SearchResult> answer = null;
        InitialLdapContext ctx = null;
        try {
            OwUserInfo userInfo;
            ctx = connection_p.createInitialDirContext();
            Properties connectionProperties = connection_p.getProperties();
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setTimeLimit(120000);
            ctls.setReturningAttributes(null);
            searchRoot = (String)connectionProperties.get("UsersDirectory");
            String filter = attrNameToFindBy + "=" + strID_p;
            answer = ctx.search(searchRoot, filter, ctls);
            if (!answer.hasMore()) {
                throw new OwObjectNotFoundException("Could not find user '" + strID_p + "'");
            }
            SearchResult result = answer.next();
            OwUserInfo owUserInfo = userInfo = this.createUserInfo(result, connection_p);
            return owUserInfo;
        }
        catch (NamingException e) {
            String msg = "LDAP search failed.";
            LOG.error((Object)msg, (Throwable)e);
            throw new OwObjectNotFoundException(msg, (Throwable)e);
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                }
                catch (NamingException e2) {}
                answer = null;
            }
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
                ctx = null;
            }
        }
    }

    private OwUserInfo createUserInfo(SearchResult result, OwLdapConnection connection_p) throws NamingException {
        Properties connectionProperties = connection_p.getProperties();
        String userLoginNameAttribute = this.getUserLoginAttribute(connection_p);
        String longNameAttribute = (String)connectionProperties.get(NAME_LONGNAME_PROPERTY);
        String shortNameAttribute = (String)connectionProperties.get(NAME_SHORTNAME_PROPERTY);
        String displayNameAttribute = this.getDisplayNameAttName(connection_p);
        Attribute userLoginNameAttr = result.getAttributes().get(userLoginNameAttribute);
        String userLoginName = (String)userLoginNameAttr.get();
        String longName = (String)this.getSafeAttributeValue(result, longNameAttribute);
        String shortName = (String)this.getSafeAttributeValue(result, shortNameAttribute);
        String displayName = (String)this.getSafeAttributeValue(result, displayNameAttribute);
        String distinguishedName = result.getNameInNamespace();
        return new OwLDAPUserInfo(userLoginName, distinguishedName, displayName, shortName, longName);
    }

    private Object getSafeAttributeValue(SearchResult result, String attributeName) {
        if (attributeName != null) {
            try {
                Attribute attr = result.getAttributes().get(attributeName);
                if (attr != null) {
                    return attr.get();
                }
                LOG.warn((Object)("OwBasicLdapSchemaInterpreter.getSafeAttributeValue: Attribute not available or set, attribute-name = " + attributeName));
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getUserDisplayName(OwLdapConnection connection_p) throws OwAuthenticationException, OwConfigurationException, OwInvalidOperationException {
        String attDisplayName = this.getDisplayNameAttName(connection_p);
        return connection_p.getUserAttributeValue(attDisplayName, true);
    }

    @Override
    public String getUserDisplayName(String dname, OwLdapConnection connection) throws OwException {
        String attDisplayName = this.getDisplayNameAttName(connection);
        Object attributeValue = connection.getAttributeValue(dname, attDisplayName);
        if (null == attributeValue) {
            return null;
        }
        return attributeValue.toString();
    }

    @Override
    public String getUserLongin(String dname, OwLdapConnection connection) throws OwException {
        String attLogin = this.getUserLoginAttribute(connection);
        Object attributeValue = connection.getAttributeValue(dname, attLogin);
        if (null == attributeValue) {
            return null;
        }
        return attributeValue.toString();
    }

    @Override
    public String getRecordId(String dname, OwLdapConnection connection) throws OwException {
        String attIdName = this.getObjectIdAttribute(connection);
        Object attributeValue = connection.getAttributeValue(dname, attIdName);
        if (null == attributeValue) {
            return null;
        }
        return attributeValue.toString();
    }

    protected abstract String getUserLoginAttribute(OwLdapConnection var1);

    protected abstract String getObjectIdAttribute(OwLdapConnection var1);

    protected abstract String getDisplayNameAttName(OwLdapConnection var1);
}

