/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.ldap;

import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.ldap.OwBasicLdapSchemaInterpreter;
import com.wewebu.ow.server.util.ldap.OwLDAPGroupInfo;
import com.wewebu.ow.server.util.ldap.OwLdapConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.log4j.Logger;

public class OwStandardSchemaInterpreter
extends OwBasicLdapSchemaInterpreter {
    private static final Logger LOG = OwLogCore.getLogger(OwStandardSchemaInterpreter.class);
    private static final String UID = "uid";

    @Override
    public Collection<String> getAllShortGroupNames(OwLdapConnection connection_p) throws OwAuthenticationException, OwInvalidOperationException, OwConfigurationException {
        String searchBase = connection_p.getProperty("GroupsDirectory", "ou=groups");
        String groupClass = this.getGroupClass(connection_p);
        return connection_p.searchAttributeValues(searchBase, new String[][]{{"objectClass", groupClass}}, "cn");
    }

    private String getGroupClass(OwLdapConnection connection_p) {
        return connection_p.getProperty("GroupsObjectClass", "posixGroup");
    }

    private String getGroupReferebceAttribute(OwLdapConnection connection_p) {
        return connection_p.getProperty("GroupReferenceAttribute", "memberUid");
    }

    private String getUserGroupReference(OwLdapConnection connection_p) {
        return connection_p.getProperty("UserGroupReference", UID);
    }

    @Override
    public Collection<String> getShortGroupNames(OwLdapConnection connection_p) throws OwAuthenticationException, OwConfigurationException, OwInvalidOperationException {
        String userReference = this.getUserGroupReference(connection_p);
        String initialValue = null;
        initialValue = "!".equals(userReference) ? connection_p.getUserDistinguishedName() : connection_p.getUserAttributeValue(userReference, true);
        String searchBase = connection_p.getProperty("GroupsDirectory", "ou=groups");
        String groupClass = this.getGroupClass(connection_p);
        String referenceAttribute = this.getGroupReferebceAttribute(connection_p);
        InitialLdapContext ctx = null;
        try {
            ctx = connection_p.createInitialDirContext();
            List<String> list = this.searchCompoundGroups(ctx, searchBase, groupClass, referenceAttribute, initialValue, "cn");
            return list;
        }
        catch (NamingException e) {
            String msg = "Error searching for compound groups of " + initialValue;
            LOG.error((Object)msg, (Throwable)e);
            throw new OwInvalidOperationException(msg, (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
                ctx = null;
            }
        }
    }

    @Override
    protected String getDisplayNameAttName(OwLdapConnection connection_p) {
        String attDisplayName = connection_p.getProperty("AttributeNameUserDisplayName", "displayName");
        return attDisplayName;
    }

    @Override
    public String getUserShortName(OwLdapConnection connection_p) throws OwAuthenticationException, OwConfigurationException, OwInvalidOperationException {
        String shortNameAttribute = connection_p.getProperty("AttributeNameShortName", "givenName");
        return connection_p.getUserAttributeValue(shortNameAttribute, true);
    }

    @Override
    public String getUserLongName(OwLdapConnection connection_p) throws OwAuthenticationException, OwConfigurationException, OwInvalidOperationException {
        String longNameAttribute = connection_p.getProperty("AttributeNameLongName", "displayName");
        return connection_p.getUserAttributeValue(longNameAttribute, true);
    }

    @Override
    public String getUserId(OwLdapConnection connection_p) throws OwAuthenticationException, OwInvalidOperationException, OwConfigurationException {
        return connection_p.getUserAttributeValue(this.getObjectIdAttribute(connection_p), true);
    }

    private Attributes createMatchAttributes(String groupClass_p, String referenceAttribute_p, String value_p) {
        BasicAttributes matchAttrs = new BasicAttributes(true);
        matchAttrs.put(new BasicAttribute("objectClass", groupClass_p));
        matchAttrs.put(new BasicAttribute(referenceAttribute_p, value_p));
        return matchAttrs;
    }

    private List<String> searchCompoundGroups(DirContext context_p, String searchBase_p, String groupClass_p, String referenceAttribute_p, String initialValue_p, String groupNameAttribute_p) throws NamingException {
        ArrayList<String> attributeValueList = new ArrayList<String>();
        Stack<Attributes> matchStack = new Stack<Attributes>();
        Attributes initialAttributes = this.createMatchAttributes(groupClass_p, referenceAttribute_p, initialValue_p);
        matchStack.push(initialAttributes);
        while (!matchStack.isEmpty()) {
            Attributes matchAttributes = (Attributes)matchStack.pop();
            NamingEnumeration<SearchResult> answer = context_p.search(searchBase_p, matchAttributes, new String[]{groupNameAttribute_p});
            String answerAttribute = groupNameAttribute_p + ":";
            int answerAttributeLen = answerAttribute.length();
            while (answer.hasMoreElements()) {
                SearchResult sr = (SearchResult)answer.nextElement();
                String groupDn = sr.getNameInNamespace();
                Attributes compoundGroupMatch = this.createMatchAttributes(groupClass_p, referenceAttribute_p, groupDn);
                matchStack.push(compoundGroupMatch);
                Attributes dnAttrs = sr.getAttributes();
                if (dnAttrs == null) continue;
                NamingEnumeration<? extends Attribute> attrEnum = dnAttrs.getAll();
                while (attrEnum.hasMore()) {
                    BasicAttribute ba = (BasicAttribute)attrEnum.next();
                    String baString = ba.toString();
                    baString = baString.substring(answerAttributeLen);
                    attributeValueList.add(baString.trim());
                }
            }
        }
        return attributeValueList;
    }

    @Override
    public OwObjectCollection findUserMatching(OwLdapConnection connection, String pattern) throws OwException {
        String searchBase = connection.getProperty("UsersDirectory", "ou=people,dc=alfresco,dc=local");
        String groupClass = this.getGroupClass(connection);
        String filter = "(& (cn=" + pattern + ") (!(objectClass=" + groupClass + ")) )";
        return connection.searchValuesByFilter(searchBase, filter, "distinguishedName", "cn");
    }

    @Override
    public OwObjectCollection findGroupsMatching(OwLdapConnection connection, String pattern) throws OwException {
        String groupClass = this.getGroupClass(connection);
        String searchBase = connection.getProperty("GroupsDirectory", "ou=groups");
        try {
            NamingEnumeration<SearchResult> answer = connection.search(searchBase, new String[][]{{"cn", pattern}, {"objectClass", groupClass}}, new String[]{"cn"});
            OwStandardObjectCollection groups = new OwStandardObjectCollection();
            while (answer.hasMoreElements()) {
                SearchResult sr = (SearchResult)answer.nextElement();
                String dn = sr.getNameInNamespace();
                String cn = "";
                Attribute cnAtt = sr.getAttributes().get("cn");
                if (null != cnAtt) {
                    cn = (String)cnAtt.get();
                }
                groups.add(new OwLDAPGroupInfo(dn, cn));
            }
            return groups;
        }
        catch (NamingException e) {
            throw new OwInvalidOperationException("Could not search by filter.", (Throwable)e);
        }
    }

    @Override
    protected String getObjectIdAttribute(OwLdapConnection connection_p) {
        String objectGUIDAttribute = connection_p.getProperty("AttributeNameObjectGUID", UID);
        return objectGUIDAttribute;
    }

    @Override
    protected String getUserLoginAttribute(OwLdapConnection connection_p) {
        String userLoginNameAttribute = connection_p.getProperty("loginQueryName", UID);
        return userLoginNameAttribute;
    }
}

