/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.paramcodec;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OwParameterMap {
    private Map m_parameters = new HashMap();

    public OwParameterMap() {
    }

    public OwParameterMap(OwParameterMap parameterMap_p) {
        if (parameterMap_p.m_parameters != null) {
            this.m_parameters.putAll(parameterMap_p.m_parameters);
        }
    }

    public OwParameterMap(Map parameterMap_p) {
        this.m_parameters.putAll(parameterMap_p);
    }

    public synchronized Set getParameterNames() {
        return this.m_parameters.keySet();
    }

    public synchronized String[] getParameterValues(String parameterName_p) {
        return (String[])this.m_parameters.get(parameterName_p);
    }

    public synchronized String getParameter(String parameterName_p) {
        String[] values = (String[])this.m_parameters.get(parameterName_p);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public synchronized void setParameter(String parameterName_p, String value_p) {
        String[] values = (String[])this.m_parameters.get(parameterName_p);
        if (values == null) {
            values = new String[]{value_p};
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[values.length] = value_p;
            values = newValues;
        }
        this.m_parameters.put(parameterName_p, values);
    }

    public Map toRequestParametersMap() {
        return this.m_parameters;
    }

    public synchronized String toRequestQueryString() {
        Set entries = this.m_parameters.entrySet();
        StringBuffer queryString = new StringBuffer();
        for (Map.Entry entry : entries) {
            String parameterName = (String)entry.getKey();
            String[] parameterValues = (String[])entry.getValue();
            if (parameterName == null || parameterValues == null) continue;
            for (int j = 0; j < parameterValues.length; ++j) {
                if (parameterValues[j] == null) continue;
                if (queryString.length() > 0) {
                    queryString.append("&");
                }
                queryString.append(parameterName);
                queryString.append("=");
                queryString.append(parameterValues[j]);
            }
        }
        return queryString.toString();
    }

    public synchronized void addAll(Map cookieMap_p) {
        Set entries = cookieMap_p.entrySet();
        for (Map.Entry entry : entries) {
            String paramName = (String)entry.getKey();
            String[] paramValues = (String[])entry.getValue();
            if (paramValues == null) continue;
            String[] currentValues = (String[])this.m_parameters.get(paramName);
            if (currentValues == null) {
                this.m_parameters.put(paramName, paramValues);
                continue;
            }
            String[] newValues = new String[currentValues.length + paramValues.length];
            System.arraycopy(currentValues, 0, newValues, 0, currentValues.length);
            System.arraycopy(paramValues, 0, newValues, currentValues.length, paramValues.length);
            this.m_parameters.put(paramName, newValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object obj_p) {
        if (obj_p == null) {
            return false;
        }
        Object object = obj_p;
        synchronized (object) {
            if (obj_p instanceof OwParameterMap) {
                OwParameterMap pmObj = (OwParameterMap)obj_p;
                Set objeKs = pmObj.m_parameters.keySet();
                Set thisKs = this.m_parameters.keySet();
                if (objeKs.size() != thisKs.size()) {
                    return false;
                }
                for (String parameterName : objeKs) {
                    String[] thisValues = (String[])this.m_parameters.get(parameterName);
                    String[] objValues = (String[])pmObj.m_parameters.get(parameterName);
                    if (objValues == null || thisValues == null) {
                        if (objValues == thisValues) continue;
                        return false;
                    }
                    if (thisValues.length != objValues.length) {
                        return false;
                    }
                    for (int j = 0; j < objValues.length; ++j) {
                        if (objValues[j] == null && null != thisValues[j]) {
                            return false;
                        }
                        if (objValues[j].equals(thisValues[j])) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }

    public String toString() {
        return this.toRequestQueryString();
    }
}

