/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.upload;

import java.io.IOException;
import javax.servlet.ServletInputStream;

public class OwBufferedServletInputStream
extends ServletInputStream {
    private ServletInputStream in;
    private byte[] buf = new byte[65536];
    private int count;
    private int pos;

    public OwBufferedServletInputStream(ServletInputStream in_p) {
        this.in = in_p;
    }

    private void fill() throws IOException {
        int i = this.in.read(this.buf, 0, this.buf.length);
        if (i > 0) {
            this.pos = 0;
            this.count = i;
        }
    }

    public int readLine(byte[] b_p, int off_p, int len_p) throws IOException {
        int copy;
        int eol;
        int total = 0;
        if (len_p == 0) {
            return 0;
        }
        int avail = this.count - this.pos;
        if (avail <= 0) {
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        if ((eol = OwBufferedServletInputStream.findeol(this.buf, this.pos, copy = Math.min(len_p, avail))) != -1) {
            copy = eol;
        }
        System.arraycopy(this.buf, this.pos, b_p, off_p, copy);
        this.pos += copy;
        total += copy;
        while (total < len_p && eol == -1) {
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return total;
            }
            copy = Math.min(len_p - total, avail);
            eol = OwBufferedServletInputStream.findeol(this.buf, this.pos, copy);
            if (eol != -1) {
                copy = eol;
            }
            System.arraycopy(this.buf, this.pos, b_p, off_p + total, copy);
            this.pos += copy;
            total += copy;
        }
        return total;
    }

    private static int findeol(byte[] b_p, int pos_p, int len_p) {
        int end = pos_p + len_p;
        int i = pos_p;
        while (i < end) {
            if (b_p[i++] != 10) continue;
            return i - pos_p;
        }
        return -1;
    }

    public int read() throws IOException {
        if (this.count <= this.pos) {
            this.fill();
            if (this.count <= this.pos) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public int read(byte[] b_p, int off_p, int len_p) throws IOException {
        int total;
        int copy;
        for (total = 0; total < len_p; total += copy) {
            int avail = this.count - this.pos;
            if (avail <= 0) {
                this.fill();
                avail = this.count - this.pos;
                if (avail <= 0) {
                    if (total > 0) {
                        return total;
                    }
                    return -1;
                }
            }
            copy = Math.min(len_p - total, avail);
            System.arraycopy(this.buf, this.pos, b_p, off_p + total, copy);
            this.pos += copy;
        }
        return total;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

