/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.upload;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

public class OwFileUpStream
extends FilterInputStream {
    private String m_boundary;
    private byte[] m_buf = new byte[65536];
    private int m_count;
    private int m_pos;
    private boolean m_eof;

    public OwFileUpStream(ServletInputStream in_p, String boundary_p) throws IOException {
        super((InputStream)in_p);
        this.m_boundary = boundary_p;
    }

    private void fill() throws IOException {
        if (this.m_eof) {
            return;
        }
        if (this.m_count > 0) {
            if (this.m_count - this.m_pos == 2) {
                System.arraycopy(this.m_buf, this.m_pos, this.m_buf, 0, this.m_count - this.m_pos);
                this.m_count -= this.m_pos;
                this.m_pos = 0;
            } else {
                throw new IllegalStateException("fill() detected illegal buffer state");
            }
        }
        int iread = 0;
        int imaxRead = this.m_buf.length - this.m_boundary.length();
        while (this.m_count < imaxRead) {
            iread = ((ServletInputStream)this.in).readLine(this.m_buf, this.m_count, this.m_buf.length - this.m_count);
            if (iread == -1) {
                throw new IOException("unexpected end of part");
            }
            if (iread >= this.m_boundary.length()) {
                this.m_eof = true;
                for (int i = 0; i < this.m_boundary.length(); ++i) {
                    if (this.m_boundary.charAt(i) == this.m_buf[this.m_count + i]) continue;
                    this.m_eof = false;
                    break;
                }
                if (this.m_eof) break;
            }
            this.m_count += iread;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.m_count - this.m_pos <= 2) {
            this.fill();
            if (this.m_count - this.m_pos <= 2) {
                return -1;
            }
        }
        return this.m_buf[this.m_pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b_p) throws IOException {
        return this.read(b_p, 0, b_p.length);
    }

    @Override
    public int read(byte[] b_p, int off_p, int len_p) throws IOException {
        int itotal = 0;
        if (len_p == 0) {
            return 0;
        }
        int iavail = this.m_count - this.m_pos - 2;
        if (iavail <= 0) {
            this.fill();
            iavail = this.m_count - this.m_pos - 2;
            if (iavail <= 0) {
                return -1;
            }
        }
        int icopy = Math.min(len_p, iavail);
        System.arraycopy(this.m_buf, this.m_pos, b_p, off_p, icopy);
        this.m_pos += icopy;
        itotal += icopy;
        while (itotal < len_p) {
            this.fill();
            iavail = this.m_count - this.m_pos - 2;
            if (iavail <= 0) {
                return itotal;
            }
            icopy = Math.min(len_p - itotal, iavail);
            System.arraycopy(this.m_buf, this.m_pos, b_p, off_p + itotal, icopy);
            this.m_pos += icopy;
            itotal += icopy;
        }
        return itotal;
    }

    @Override
    public int available() throws IOException {
        int iavail = this.m_count - this.m_pos - 2 + this.in.available();
        return iavail < 0 ? 0 : iavail;
    }

    @Override
    public void close() throws IOException {
        if (!this.m_eof) {
            while (this.read(this.m_buf, 0, this.m_buf.length) != -1) {
            }
        }
    }
}

