/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.service.rendition.impl;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwStandardOptionXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.service.rendition.OwConfigurableRenditionService;
import com.wewebu.service.rendition.OwRenditionService;
import com.wewebu.service.rendition.OwRenditionServiceProvider;
import com.wewebu.service.rendition.impl.OwNoRenditionService;
import com.wewebu.service.rendition.impl.OwProviderConfiguration;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class OwSimpleRenditionServiceProvider
implements OwRenditionServiceProvider {
    private static final Logger LOG = OwLogCore.getLogger(OwSimpleRenditionServiceProvider.class);
    private static final String EL_CONFIGURATION = "configuration";
    private static final String EL_SERVICE = "service";
    private static final String AT_CLASS = "class";
    private OwProviderConfiguration providerConfiguration;
    private ConcurrentHashMap<String, OwRenditionService> renditionServices = new ConcurrentHashMap();
    private OwRenditionService fallbackRendtionService;

    public OwSimpleRenditionServiceProvider() {
        this.initFallbackRendtionService();
    }

    @Override
    public OwRenditionService getRendtionService(OwObject obj) throws OwException {
        String key = null;
        try {
            String[] splitDms = obj.getDMSID().split(",");
            key = splitDms[0];
        }
        catch (Exception e) {
            LOG.error((Object)"Could not retrieve DMSID from object", (Throwable)e);
            throw new OwServerException("Cannot get mapping information", (Throwable)e);
        }
        OwRenditionService service = this.renditionServices.get(key);
        if (service == null && (service = this.initRendtionService(key)) == null) {
            service = OwNoRenditionService.INSTANCE;
        }
        return service;
    }

    @Override
    public OwRenditionService getFallbackRendtionService() {
        if (this.fallbackRendtionService != null) {
            return this.fallbackRendtionService;
        }
        return OwNoRenditionService.INSTANCE;
    }

    private synchronized OwProviderConfiguration getProviderConfiguration() throws OwConfigurationException {
        if (this.providerConfiguration == null) {
            OwXMLUtil rootConf = this.readConfiguration(this.getRootConfigurationName());
            this.providerConfiguration = OwProviderConfiguration.fromXML(rootConf);
        }
        return this.providerConfiguration;
    }

    protected String getRootConfigurationName() {
        return "/rendition.xml";
    }

    protected OwRenditionService initRendtionService(String mappingPrefix) throws OwException {
        OwXMLUtil mappingConf = this.getProviderConfiguration().getProviderCfgFor(mappingPrefix);
        OwRenditionService service = null;
        if (mappingConf != null) {
            String externalResource = mappingConf.getSafeStringAttributeValue(EL_CONFIGURATION, null);
            OwXMLUtil serviceConf = null;
            if (externalResource != null) {
                serviceConf = this.readConfiguration(externalResource);
            }
            try {
                serviceConf = serviceConf == null ? mappingConf.getSubUtil(EL_SERVICE) : serviceConf.getSubUtil(EL_SERVICE);
            }
            catch (OwConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Could not read inlined configuration for rendition mapping with dmsprefix = " + mappingPrefix;
                LOG.error((Object)msg, (Throwable)e);
                throw new OwConfigurationException(msg, (Throwable)e);
            }
            String className = serviceConf.getSafeStringAttributeValue(AT_CLASS, null);
            if (className != null) {
                try {
                    service = this.createRenditionService(className);
                }
                catch (OwServerException e) {
                    LOG.error((Object)"Could not create renditionservice, will return NoRendtionService", (Throwable)e);
                    service = OwNoRenditionService.INSTANCE;
                }
                if (this.providerConfiguration != null && service instanceof OwConfigurableRenditionService) {
                    ((OwConfigurableRenditionService)service).init(serviceConf);
                }
                this.renditionServices.put(mappingPrefix, service);
            }
        }
        return service;
    }

    private void initFallbackRendtionService() {
        block6: {
            try {
                OwXMLUtil serviceConf = this.getProviderConfiguration().getFallBackCfg();
                if (null == serviceConf) {
                    return;
                }
                String className = serviceConf.getSafeStringAttributeValue(AT_CLASS, null);
                if (className == null) break block6;
                try {
                    this.fallbackRendtionService = this.createRenditionService(className);
                    if (this.providerConfiguration != null && this.fallbackRendtionService instanceof OwConfigurableRenditionService) {
                        ((OwConfigurableRenditionService)this.fallbackRendtionService).init(serviceConf);
                    }
                }
                catch (OwException e) {
                    LOG.error((Object)"Could not create fallback renditionservice!", (Throwable)e);
                    this.renditionServices = null;
                }
            }
            catch (OwConfigurationException e) {
                LOG.error((Object)"Could not initialize the fallback rendition provider.", (Throwable)e);
            }
        }
    }

    protected OwRenditionService createRenditionService(String fullServiceName) throws OwServerException {
        try {
            Class<?> clazz = Class.forName(fullServiceName);
            OwRenditionService service = (OwRenditionService)clazz.newInstance();
            return service;
        }
        catch (ClassNotFoundException e) {
            throw new OwServerException("Could not find class = " + fullServiceName, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new OwServerException("Cannot create instance for class = " + fullServiceName, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new OwServerException("Access not possible to class = " + fullServiceName, (Throwable)e);
        }
    }

    protected OwXMLUtil readConfiguration(String resourceName) throws OwConfigurationException {
        URL resource = OwSimpleRenditionServiceProvider.class.getResource(resourceName);
        if (resource == null) {
            throw new OwConfigurationException("No such configuration resource " + resourceName);
        }
        InputStream is = null;
        OwStandardOptionXMLUtil config = null;
        try {
            is = resource.openStream();
            config = new OwStandardOptionXMLUtil(is, EL_CONFIGURATION);
            return config;
        }
        catch (OwConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot reaad configuration resource " + resourceName), (Throwable)e);
            throw new OwConfigurationException("Cannot reaad configuration resource.", (Throwable)e);
        }
    }
}

