/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wd.ui.profile;

import com.wewebu.ow.server.app.OwGlobalParametersConfiguration;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwStandardDialog;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.ui.OwSmallSubNavigationView;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.wd.ui.profile.OwChangePasswordView;
import org.alfresco.wd.ui.profile.OwUserProfileView;

public class OwProfileDialog
extends OwStandardDialog {
    public static final String ALLOW_CHANGE_PASSWORD = "AllowChangePassword";
    private OwChangePasswordView changePwdView;

    @Override
    protected void init() throws Exception {
        super.init();
        OwSmallSubNavigationView navView = new OwSmallSubNavigationView(true);
        this.addView(navView, 2, null);
        OwUserProfileView profileInfo = this.createUserProfileView();
        navView.addView(profileInfo, this.getContext().localize("profile.OwProfileDialog.tab.info", "Overview"), null, null, null, this.getContext().localize("profile.OwProfileDialog.tab.info.tooltip", "Show User Information"));
        navView.enable(0, true);
        OwMainAppContext ctx = (OwMainAppContext)this.getContext();
        OwGlobalParametersConfiguration globalParameters = ctx.getConfiguration().getGlobalParameters();
        if (globalParameters.getSafeBoolean(ALLOW_CHANGE_PASSWORD, false)) {
            this.changePwdView = this.createChangePasswordView();
            navView.addView(this.changePwdView, this.getContext().localize("profile.OwProfileDialog.tab.changePwd", "Change Password"), null, null, null, this.getContext().localize("profile.OwProfileDialog.tab.changePwd.tooltip", "Change User Password"));
            navView.enable(1, true);
        }
        navView.navigate(0);
    }

    @Override
    public String getTitle() {
        return this.getContext().localize("profile.OwProfileDialog.title", "My Profile");
    }

    protected OwUserProfileView createUserProfileView() {
        return new OwUserProfileView();
    }

    protected OwChangePasswordView createChangePasswordView() {
        return new OwChangePasswordView();
    }

    @Override
    public void onClose(HttpServletRequest request_p) throws Exception {
        OwAppContext ctx = this.getContext();
        super.onClose(request_p);
        if (this.isPasswordChanged()) {
            ctx.logout();
        }
    }

    protected boolean isPasswordChanged() {
        return this.changePwdView != null && this.changePwdView.isPasswordChanged();
    }
}

