/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owrecord;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDynamicLayoutSettings;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwLoadContext;
import com.wewebu.ow.server.collections.OwPageableObject;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.event.OwEvent;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwLockDeniedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.field.OwPriorityRule;
import com.wewebu.ow.server.field.OwPriorityRuleFactory;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.field.OwStandardFieldColumnInfo;
import com.wewebu.ow.server.history.OwStandardHistoryObjectChangeEvent;
import com.wewebu.ow.server.plug.owrecord.filter.OwFilterObjectCollection;
import com.wewebu.ow.server.plug.owrecord.filter.OwFilterRuntimeException;
import com.wewebu.ow.server.plug.owrecord.filter.OwRecordFilterOperatorHelper;
import com.wewebu.ow.server.plug.owrecord.log.OwLog;
import com.wewebu.ow.server.ui.OwDocument;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwTreeView;
import com.wewebu.ow.server.util.OwAttributeBag;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtilPlaceholderFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwRecordDocument
extends OwMasterDocument
implements OwTreeView.OwTreeViewEventListner,
OwClientRefreshContext,
OwObjectListView.OwObjectListViewEventListner {
    private static final String RECORD_BAG_PREFIX = "_record_";
    private static final Logger LOG = OwLog.getLogger(OwRecordDocument.class);
    public static final String PLUGIN_LIST_ENABLED_ATTRIBUTE = "enable";
    public static final String PLUGIN_DOC_CONFIG_PARAMETER = "docparameter";
    public static final String SETTINGS_PARAM_COLUMN_INFO = "columninfo";
    public static final String SETTINGS_PARAM_SORT = "ColumnSortCriteria";
    public static final String CONFIG_NODE_DOCUMENTFUNCTIONPLUGINS = "DocumentFunctionPlugins";
    public static final String CONFIG_NODE_RECORDFUNCTIONPLUGINS = "RecordFunctionPlugins";
    public static final String CONFIG_NODE_ENABLEDDOCUMENTFUNCTIONS = "EnabledDocumentFunctions";
    protected static final String CONFIG_NODE_SHOWFOLDERS = "DisplayFoldersInResultList";
    protected static final String CONFIG_NODE_PAGEABLE = "pageable";
    protected static final String CONFIG_NODE_CLIENT_FILTER = "ClientFilter";
    public static final String CONFIG_NODE_USE_DYNAMIC_SPLIT = "UseDynamicSplit";
    protected int m_iMaxSize = 50;
    protected OwObject m_RootFolderObject;
    protected OwObject m_SubFolderObject;
    protected OwObject m_subFolderObjectParent;
    protected String m_strSubFolderPath;
    protected OwTreeView m_ResultTreeView;
    private OwObjectListView m_DocumentListView;
    private boolean showFolder;
    private boolean usePaging;
    private boolean clientFilterEnabled;
    private OwSort m_FolderSortCriteria;
    private OwSort m_ColumnSortCriteria;
    protected List m_rulesList;
    private OwDynamicLayoutSettings m_layoutSettings;
    private List m_defaultColumnInfoList;
    private boolean m_enablesearchtemplateview;
    private OwRecordFilterOperatorHelper operatorHelper;

    private void setDocumentListView(OwObjectListView documentListView_p) throws Exception {
        this.m_DocumentListView = documentListView_p;
        this.m_DocumentListView.setEventListner((OwObjectListView.OwObjectListViewEventListner)this);
        this.m_DocumentListView.setRefreshContext((OwClientRefreshContext)this);
    }

    public void enableSearchTemplateView(boolean enablesearchtemplateview_p) {
        this.m_enablesearchtemplateview = enablesearchtemplateview_p;
    }

    public boolean isSearchTemplateViewEnabled() {
        return this.m_enablesearchtemplateview;
    }

    public boolean isPropertyPreviewViewEnabled() {
        return this.getCurrentRootFolder() != null;
    }

    protected Collection getDefaultColumnInfo() throws Exception {
        if (null == this.m_defaultColumnInfoList) {
            List defaultPropertyNameList = (List)this.getSafeSetting(SETTINGS_PARAM_COLUMN_INFO, null);
            if (defaultPropertyNameList != null) {
                this.m_defaultColumnInfoList = new LinkedList();
                Iterator it = defaultPropertyNameList.iterator();
                while (it.hasNext()) {
                    String strPropertyName = (String)it.next();
                    OwFieldDefinition fielddef = null;
                    try {
                        fielddef = ((OwMainAppContext)this.getContext()).getNetwork().getFieldDefinition(strPropertyName, null);
                    }
                    catch (OwObjectNotFoundException e) {
                        LOG.warn((Object)("Could not resolve property for contentlist: " + strPropertyName));
                        it.remove();
                        continue;
                    }
                    this.m_defaultColumnInfoList.add(new OwStandardFieldColumnInfo(fielddef));
                }
            } else {
                this.m_defaultColumnInfoList = new LinkedList();
            }
        }
        return this.m_defaultColumnInfoList;
    }

    public OwSearchTemplate getSearchTemplate() throws Exception {
        OwObject openObject = this.getCurrentSubFolderObject();
        if (openObject != null) {
            return openObject.getSearchTemplate();
        }
        return null;
    }

    protected void init() throws Exception {
        super.init();
        this.m_layoutSettings = this.createLayoutSettings();
        this.m_iMaxSize = this.getConfigNode().getSafeIntegerValue("MaxChildSize", 200);
        this.showFolder = this.getConfigNode().getSafeBooleanValue(CONFIG_NODE_SHOWFOLDERS, false);
        this.usePaging = this.getConfigNode().getSafeBooleanValue(CONFIG_NODE_PAGEABLE, false);
        this.clientFilterEnabled = this.getConfigNode().getSafeBooleanValue(CONFIG_NODE_CLIENT_FILTER, true);
        this.setFolderSortCriteria();
        this.operatorHelper = this.createFilterOperatorHelper();
    }

    protected OwDynamicLayoutSettings createLayoutSettings() throws Exception {
        OwDynamicLayoutSettings result = null;
        String prefix = this.getConfiguration().getLayoutConfigurationBagPrefix() + RECORD_BAG_PREFIX + this.getPluginID();
        result = new OwDynamicLayoutSettings(this.isDynamicSplitInUse(), this.getContext(), prefix);
        return result;
    }

    public boolean isDynamicSplitInUse() throws Exception {
        boolean useDynamicSplit = this.getConfiguration().isDynamicSplitInUse();
        useDynamicSplit = this.getConfigNode().getSafeBooleanValue(CONFIG_NODE_USE_DYNAMIC_SPLIT, useDynamicSplit);
        return useDynamicSplit;
    }

    public int getMaxChildSize() {
        return this.m_iMaxSize;
    }

    public void setMaxChildSize(int iMax_p) {
        this.m_iMaxSize = iMax_p;
    }

    public OwObject getCurrentRootFolder() {
        return this.m_RootFolderObject;
    }

    public OwObject getCurrentSubFolderObject() {
        return this.m_SubFolderObject;
    }

    public OwObject getCurrentSubFolderObjectParent() {
        return this.m_subFolderObjectParent;
    }

    public String getCurrentSubFolderPath() {
        return this.m_strSubFolderPath;
    }

    public String getCurrentSubFolderDisplayPath() {
        if (null != this.m_ResultTreeView.getCurrentNode()) {
            return this.m_ResultTreeView.getCurrentNode().getDisplayPath();
        }
        return "";
    }

    public void openFolder(OwObject folder_p, String strSubFolderPath_p) throws Exception {
        String sLockFailedUser = null;
        String rootDMSID = "";
        if (this.m_RootFolderObject != null) {
            try {
                rootDMSID = this.m_RootFolderObject.getDMSID();
            }
            catch (Exception e) {
                LOG.error((Object)"Old root DMSID is invalid !", (Throwable)e);
                this.m_RootFolderObject = null;
            }
        }
        boolean fChanged = false;
        if (this.m_RootFolderObject == null || !folder_p.getDMSID().equals(rootDMSID)) {
            fChanged = true;
            if (this.supportLock()) {
                if (folder_p.canLock()) {
                    folder_p.setLock(true);
                    if (!folder_p.getMyLock(2)) {
                        sLockFailedUser = folder_p.getLockUserID(2);
                    }
                }
                if (null != this.m_RootFolderObject && this.m_RootFolderObject.canLock()) {
                    this.m_RootFolderObject.setLock(false);
                }
            }
        }
        if (strSubFolderPath_p == null) {
            strSubFolderPath_p = "/";
        }
        if (this.m_RootFolderObject != folder_p || !strSubFolderPath_p.equals(this.getCurrentSubFolderPath())) {
            this.m_RootFolderObject = folder_p;
            this.m_strSubFolderPath = strSubFolderPath_p;
            if (this.m_ResultTreeView != null) {
                this.m_ResultTreeView.navigate((Object)folder_p, strSubFolderPath_p);
            }
            this.update((OwEventTarget)this, 5, null);
        }
        if (fChanged) {
            ((OwMainAppContext)this.getContext()).getHistoryManager().addEvent(2, this.getPluginID(), (OwEvent)new OwStandardHistoryObjectChangeEvent((OwObjectReference)this.m_SubFolderObject, (OwObjectReference)this.m_RootFolderObject), 1);
        }
        if (null != sLockFailedUser) {
            throw new OwLockDeniedException((OwString)new OwString1("plug.owrecord.OwRecordDocument.lockedbyanotheruser", "File is currently used by user (%1)!", sLockFailedUser));
        }
    }

    public void setResultTreeView(OwTreeView resultTreeView_p) throws Exception {
        this.m_ResultTreeView = resultTreeView_p;
        this.m_ResultTreeView.setEventListner((OwTreeView.OwTreeViewEventListner)this);
    }

    public Object onDispatch(int iCode_p, Object param1_p, Object param2_p) throws Exception {
        switch (iCode_p) {
            case 1: {
                try {
                    this.openFolder((OwObject)param1_p, (String)param2_p);
                    break;
                }
                catch (OwLockDeniedException e) {
                    throw e;
                }
                finally {
                    this.getMasterView().activate();
                }
            }
        }
        return null;
    }

    public void onTreeViewNavigateFolder(OwTreeView.OwTreeViewNode node_p) throws Exception {
    }

    public void onTreeViewOpenFolder(OwTreeView.OwTreeViewNode node_p) throws Exception {
        this.m_strSubFolderPath = node_p.getPath();
        this.m_SubFolderObject = (OwObject)node_p.getObject();
        this.m_subFolderObjectParent = (OwObject)node_p.getObjectParent();
        OwSearchTemplate st = this.m_SubFolderObject.getSearchTemplate();
        if (null != st) {
            this.m_DocumentListView.setSort(st.getSort(((OwMainAppContext)this.getContext()).getMaxSortCriteriaCount()));
        }
        this.update((OwEventTarget)this, 4, null);
        this.m_DocumentListView.setCurrentPage(0);
    }

    public boolean supportLock() {
        return this.getConfigNode().getSafeBooleanValue("LockObject", true);
    }

    public void update(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
        switch (iCode_p) {
            case 12: {
                this.setDocumentListView((OwObjectListView)param_p);
                break;
            }
            case 9: {
                if (!this.supportLock() || null == this.m_RootFolderObject || !this.m_RootFolderObject.canLock()) break;
                this.m_RootFolderObject.setLock(false);
                break;
            }
            case 11: {
                this.m_RootFolderObject = null;
                this.m_SubFolderObject = null;
                this.m_strSubFolderPath = null;
                this.displayFolderContent();
                this.m_ResultTreeView.navigate(null, null);
                break;
            }
            case 4: {
                if (null != param_p) {
                    this.m_ResultTreeView.refreshNodeForObject(param_p);
                }
                this.m_ResultTreeView.refreshCurrentNode();
                this.displayFolderContent();
                break;
            }
            case 14: {
                this.m_ResultTreeView.navigateUp();
                this.m_ResultTreeView.refreshCurrentNode();
                break;
            }
            case 15: {
                this.m_ResultTreeView.refreshCurrentNode();
                this.displayFolderContent();
                break;
            }
            case 8: {
                this.m_ResultTreeView.refreshCurrentNode();
                OwObject obj = (OwObject)param_p;
                if (null == obj || !this.m_ResultTreeView.canNavigate()) break;
                this.m_ResultTreeView.navigate(this.m_strSubFolderPath + obj.getID() + "/");
                break;
            }
            case 10: {
                this.m_defaultColumnInfoList = null;
            }
        }
        super.update(caller_p, iCode_p, param_p);
    }

    private void displayFolderContent() throws Exception {
        if (null != this.m_SubFolderObject) {
            Collection columnInfoList = this.m_SubFolderObject.getColumnInfoList();
            if (columnInfoList == null || columnInfoList.size() == 0) {
                columnInfoList = this.getDefaultColumnInfo();
                this.setColumnSortCriteria();
            }
            this.m_DocumentListView.setColumnInfo(columnInfoList);
            Collection<OwFieldDefinition> filterpros = this.collectFilterProperties(columnInfoList);
            if (this.m_SubFolderObject.getResource() == null) {
                this.m_DocumentListView.setFilter(OwObjectListView.createFilter(filterpros, (String)"", (OwDocument)this));
            } else {
                this.m_DocumentListView.setFilter(OwObjectListView.createFilter(filterpros, (OwFieldDefinitionProvider)((OwMainAppContext)this.getContext()).getNetwork(), (String)this.m_SubFolderObject.getResourceID(), (String)"", (OwDocument)this));
            }
            if (!this.checkValidSearchCriteria()) {
                this.clearObjectListContent(null);
                return;
            }
            OwLoadContext loadContext = this.getLoadContext();
            this.setObjectListContent(loadContext);
        } else {
            this.clearObjectListContent(null);
        }
    }

    protected OwLoadContext getLoadContext() throws Exception {
        int[] types;
        OwLoadContext loadContext = new OwLoadContext();
        Collection propertyNameList = this.m_DocumentListView.getRetrievalPropertyNames();
        loadContext.setPropertyNames(propertyNameList);
        if (this.showFolderInResultList()) {
            types = new int[4];
            types[3] = 8193;
        } else {
            types = new int[]{4096, 16384, 12288};
        }
        loadContext.setObjectTypes(types);
        OwSort sort = this.m_DocumentListView.getSort();
        loadContext.setSorting(sort);
        int maxChildSize = this.getMaxChildSize();
        loadContext.setMaxSize((long)maxChildSize);
        int versionSelectDefault = 1;
        loadContext.setVersionSelection(versionSelectDefault);
        OwSearchNode filterCriteria = this.m_DocumentListView.getFilterSearch();
        loadContext.setFilter(filterCriteria);
        return loadContext;
    }

    private void clearObjectListContent(OwObject parentObject) throws Exception {
        if (this.usePaging) {
            this.m_DocumentListView.setObjectIterable(null, parentObject);
        } else {
            this.m_DocumentListView.setObjectList(null, parentObject);
        }
    }

    private void setObjectListContent(OwLoadContext loadContext) throws Exception {
        if (this.usePaging && this.m_SubFolderObject instanceof OwPageableObject) {
            OwIterable iterable = ((OwPageableObject)this.m_SubFolderObject).getChildren(loadContext);
            this.m_DocumentListView.setObjectIterable(iterable, this.m_SubFolderObject);
        } else {
            OwObjectCollection documentList = this.m_SubFolderObject.getChilds(loadContext.getObjectTypes(), loadContext.getPropertyNames(), loadContext.getSorting(), (int)loadContext.getMaxSize(), loadContext.getVersionSelection(), loadContext.getFilter());
            this.m_DocumentListView.setObjectList(documentList, this.m_SubFolderObject);
        }
    }

    protected Collection<OwFieldDefinition> collectFilterProperties(Collection columnInfoList_p) throws Exception {
        if (!this.isClientFilterEnabled() && !this.m_SubFolderObject.canFilterChilds()) {
            return Collections.emptyList();
        }
        return this.operatorHelper.collectFilterProperties(this.m_SubFolderObject, (OwFieldDefinitionProvider)((OwMainAppContext)this.getContext()).getNetwork(), columnInfoList_p);
    }

    protected boolean checkValidSearchCriteria() {
        return true;
    }

    public void onClientRefreshContextUpdate(int iReason_p, Object param_p) throws Exception {
        switch (iReason_p) {
            case 1: 
            case 3: 
            case 11: {
                this.update((OwEventTarget)this, 4, param_p);
            }
        }
    }

    public void onObjectListViewFilterChange(OwSearchNode filterNode_p, OwObject parent_p) throws Exception {
        if (this.usePaging && this.m_SubFolderObject instanceof OwPageableObject) {
            if (null != filterNode_p) {
                OwLoadContext loadContext = this.getLoadContext();
                loadContext.setFilter(filterNode_p);
                OwIterable iterable = ((OwPageableObject)this.m_SubFolderObject).getChildren(loadContext);
                this.m_DocumentListView.setObjectIterable(iterable, this.m_SubFolderObject);
            }
        } else {
            OwObjectCollection col = this.m_DocumentListView.getObjectList();
            OwFilterObjectCollection filterCol = null;
            filterCol = col instanceof OwFilterObjectCollection ? (OwFilterObjectCollection)col : new OwFilterObjectCollection(col);
            if (filterNode_p != null) {
                try {
                    filterCol.setFilter(filterNode_p);
                    this.m_DocumentListView.setObjectList((OwObjectCollection)filterCol, parent_p);
                }
                catch (OwFilterRuntimeException ex) {
                    this.m_DocumentListView.setObjectList(null, parent_p);
                    LOG.error((Object)ex.getMessage(), (Throwable)((Object)ex));
                    throw new OwInvalidOperationException(this.getContext().localize("plug.owrecord.OwRecordDocument.processFilterEx", "Could not process defined filter."), (Throwable)((Object)ex));
                }
            } else {
                this.m_DocumentListView.setObjectList(filterCol.getNativeCollection(), parent_p);
                filterCol.clear();
            }
        }
    }

    public boolean onObjectListViewItemClick(OwObject obj_p) throws Exception {
        return false;
    }

    public void onObjectListViewSelect(OwObject object_p, OwObject parent_p) throws Exception {
    }

    public void onObjectListViewSort(OwSort newSort_p, String strSortProperty_p) throws Exception {
        if (this.usePaging && this.m_SubFolderObject instanceof OwPageableObject) {
            OwLoadContext loadContext = this.getLoadContext();
            OwIterable iterable = ((OwPageableObject)this.m_SubFolderObject).getChildren(loadContext);
            this.m_DocumentListView.setObjectIterable(iterable, this.m_SubFolderObject);
        } else {
            OwObjectCollection list = this.m_DocumentListView.getObjectList();
            if (null != list) {
                list.sort(this.m_DocumentListView.getSort());
                this.m_DocumentListView.setObjectList(list, this.m_SubFolderObject);
            }
        }
    }

    protected OwXMLUtil getDocumentFunctionPluginsNode() throws Exception {
        return new OwXMLUtilPlaceholderFilter(this.getConfigNode().getSubNode(CONFIG_NODE_DOCUMENTFUNCTIONPLUGINS), (OwAttributeBag)((OwMainAppContext)this.getContext()).getConfiguration());
    }

    protected OwXMLUtil getRecordFunctionPluginsNode() throws Exception {
        return new OwXMLUtilPlaceholderFilter(this.getConfigNode().getSubNode(CONFIG_NODE_RECORDFUNCTIONPLUGINS), (OwAttributeBag)((OwMainAppContext)this.getContext()).getConfiguration());
    }

    protected OwXMLUtil getDocumentFunctionsNode() throws Exception {
        Node xmlNode = this.getConfigNode().getSubNode(CONFIG_NODE_ENABLEDDOCUMENTFUNCTIONS);
        return xmlNode == null ? null : new OwXMLUtilPlaceholderFilter(xmlNode, (OwAttributeBag)((OwMainAppContext)this.getContext()).getConfiguration());
    }

    protected boolean getIsPluginsEnabled() throws Exception {
        return this.getDocumentFunctionPluginsNode().getSafeBooleanAttributeValue(PLUGIN_LIST_ENABLED_ATTRIBUTE, false) || this.getRecordFunctionPluginsNode().getSafeBooleanAttributeValue(PLUGIN_LIST_ENABLED_ATTRIBUTE, false);
    }

    protected OwSort getFolderSortCriteria() {
        return this.m_FolderSortCriteria;
    }

    private void setFolderSortCriteria() {
        List properties = this.getConfigNode().getSafeUtilList("FolderSortCriteria", "property");
        LinkedList<OwSort.OwSortCriteria> sortCriterias = new LinkedList<OwSort.OwSortCriteria>();
        HashSet<String> duplicateDedectionSet = new HashSet<String>(properties.size());
        for (OwXMLUtil prop : properties) {
            String sortCriteria = prop.getSafeTextValue(null);
            if (sortCriteria == null) {
                StringBuffer buf = new StringBuffer();
                buf.append("owplugins.xml - master plugin with id=");
                buf.append(this.getPluginID());
                buf.append(": tag <FolderSortCriteria> is configured wrongly:");
                buf.append(" one <property> tag contains no value.");
                buf.append(" This tag was ignored");
                LOG.warn((Object)buf.toString());
                continue;
            }
            if (duplicateDedectionSet.contains(sortCriteria)) {
                StringBuffer buf = new StringBuffer();
                buf.append("owplugins.xml - master plugin with id=");
                buf.append(this.getPluginID());
                buf.append(": tag <FolderSortCriteria> is configured wrongly:");
                buf.append(" one <property> tag contains a value=");
                buf.append(sortCriteria);
                buf.append(" that was defined before.");
                buf.append(" This tag was ignored");
                LOG.warn((Object)buf.toString());
                continue;
            }
            duplicateDedectionSet.add(sortCriteria);
            boolean sortAscending = prop.getSafeBooleanAttributeValue("sortascending", true);
            sortCriterias.add(new OwSort.OwSortCriteria(sortCriteria, sortAscending));
        }
        this.m_FolderSortCriteria = new OwSort(sortCriterias.size(), true);
        for (int i = sortCriterias.size() - 1; i >= 0; --i) {
            this.m_FolderSortCriteria.addCriteria((OwSort.OwSortCriteria)sortCriterias.get(i));
        }
    }

    private void setColumnSortCriteria() throws Exception {
        List properties = (List)this.getSafeSetting(SETTINGS_PARAM_SORT, null);
        if (properties != null) {
            LinkedList sortCriterias = new LinkedList();
            HashSet<OwSort.OwSortCriteria> duplicateDedectionSet = new HashSet<OwSort.OwSortCriteria>(properties.size());
            this.m_ColumnSortCriteria = this.m_DocumentListView.getSort();
            if (this.m_ColumnSortCriteria == null) {
                this.m_ColumnSortCriteria = new OwSort(sortCriterias.size(), true);
            }
            for (OwSort.OwSortCriteria sortCriteria : properties) {
                if (sortCriteria == null) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("owplugins.xml - master plugin with id=");
                    buf.append(this.getPluginID());
                    buf.append(": tag <ColumnSortCriteria> is configured wrongly:");
                    buf.append(" one <property> tag contains no value.");
                    buf.append(" This tag was ignored");
                    LOG.warn((Object)buf.toString());
                    continue;
                }
                if (duplicateDedectionSet.contains(sortCriteria)) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("owplugins.xml - master plugin with id=");
                    buf.append(this.getPluginID());
                    buf.append(": tag <ColumnSortCriteria> is configured wrongly:");
                    buf.append(" one <property> tag contains a value=");
                    buf.append(sortCriteria.getPropertyName());
                    buf.append(" that was defined before.");
                    buf.append(" This tag was ignored");
                    LOG.warn((Object)buf.toString());
                    continue;
                }
                duplicateDedectionSet.add(sortCriteria);
                boolean sortAscending = sortCriteria.getAscFlag();
                if (this.m_ColumnSortCriteria.getCriteria(sortCriteria.getPropertyName()) != null) continue;
                this.m_ColumnSortCriteria.addCriteria(new OwSort.OwSortCriteria(sortCriteria.getPropertyName(), sortAscending));
            }
        }
    }

    protected List getRulesList() throws Exception {
        if (this.m_rulesList == null) {
            OwMainAppContext mainAppContext = (OwMainAppContext)this.getContext();
            OwNetwork fieldProvider = mainAppContext.getNetwork();
            OwXMLUtil configNode = this.getConfigNode();
            OwPriorityRuleFactory rulesFactory = OwPriorityRuleFactory.getInstance();
            this.m_rulesList = rulesFactory.createRulesList(configNode, (OwFieldDefinitionProvider)fieldProvider);
        }
        return this.m_rulesList;
    }

    public String onObjectListViewGetRowClassName(int iIndex_p, OwObject obj_p) {
        try {
            List ruleList = this.getRulesList();
            for (OwPriorityRule rule : ruleList) {
                if (!rule.appliesTo(obj_p)) continue;
                return rule.getStylClass();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not load record document priority rules !", (Throwable)e);
        }
        return null;
    }

    protected boolean showFolderInResultList() {
        return this.showFolder;
    }

    public String getTreeViewId() {
        return this.m_ResultTreeView.getClientSideId();
    }

    public OwDynamicLayoutSettings getLayoutSettings() {
        return this.m_layoutSettings;
    }

    protected OwRecordFilterOperatorHelper createFilterOperatorHelper() {
        return new OwRecordFilterOperatorHelper();
    }

    public boolean isClientFilterEnabled() {
        return this.clientFilterEnabled;
    }

    public boolean isMaxSizeEnabled() {
        boolean maxSizeEnabled = true;
        try {
            Node maxMaxSizeMax;
            OwRecordDocument documentM = this;
            OwXMLUtil configNode = documentM.getConfigNode().getSubUtil("MaxSizeMax");
            if (configNode != null && (maxMaxSizeMax = configNode.getNode()) != null) {
                boolean show;
                maxSizeEnabled = show = OwXMLDOMUtil.getSafeBooleanAttributeValue((Node)maxMaxSizeMax, (String)"show", (boolean)true);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"isMaxSizeEnabled()", (Throwable)e);
        }
        return maxSizeEnabled;
    }
}

