/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owrecord;

import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.app.OwSearchCriteriaView;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.plug.owrecord.OwRecordDocument;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwLayout;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class OwRecordSearchTemplateView
extends OwLayout {
    public static final int SEARCH_CRITERIA_REGION = 1;
    public static final int MENU_REGION = 2;
    public static final int MAX_SIZE_REGION = 3;
    public static final int DEBUG_SEARCH_DUMP_REGION = 4;
    public static final String MAX_RESULT_LIST_KEY = "reslistsize";
    protected int m_iMaxSizeMax;
    protected OwSearchCriteriaView m_SearchCriteriaView;
    protected OwSearchTemplate m_searchtemplate;
    protected OwSubMenuView m_MenuView;
    protected int m_iSubmitBtnIndex;
    protected int m_searchListSize;

    public OwSearchCriteriaView getCriteriaView() {
        return this.m_SearchCriteriaView;
    }

    protected void init() throws Exception {
        super.init();
        this.m_SearchCriteriaView = new OwSearchCriteriaView();
        this.m_SearchCriteriaView.setExternalFormTarget(this.getFormTarget());
        this.addView((OwView)this.m_SearchCriteriaView, 1, null);
        this.m_MenuView = new OwSubMenuView();
        this.addView((OwView)this.m_MenuView, 2, null);
        this.m_iSubmitBtnIndex = this.m_MenuView.addFormMenuItem((OwEventTarget)this, this.getContext().localize("owrecord.OwRecordSearchTemplateView.search", "Search"), "DoSearch", null, this.getFormName());
        this.m_MenuView.addFormMenuItem((OwEventTarget)this, this.getContext().localize("owrecord.OwRecordSearchTemplateView.reset", "Reset"), "DoReset", null, this.getFormName());
        this.m_iMaxSizeMax = ((OwMasterDocument)this.getDocument()).getConfigNode().getSafeIntegerValue("MaxSizeMax", 200);
        int m_iMaxChild = ((OwRecordDocument)this.getDocument()).getMaxChildSize();
        this.m_searchListSize = Math.min(this.m_iMaxSizeMax, m_iMaxChild);
        ((OwRecordDocument)this.getDocument()).setMaxChildSize(this.m_searchListSize);
    }

    public void onUpdate(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
        switch (iCode_p) {
            case 4: 
            case 5: 
            case 8: {
                OwSearchTemplate searchtemplate = ((OwRecordDocument)this.getDocument()).getSearchTemplate();
                if (searchtemplate != null) {
                    if (searchtemplate == this.m_searchtemplate) break;
                    this.m_searchtemplate = searchtemplate;
                    List criterias = searchtemplate.getSearch(false).getCriteriaList(1);
                    this.m_SearchCriteriaView.setCriteriaList(criterias);
                    this.m_SearchCriteriaView.setHTMLFormular(searchtemplate.getHtmlLayout());
                    this.m_SearchCriteriaView.setJspFormular(searchtemplate.getJspLayoutPage());
                    this.m_SearchCriteriaView.setFieldProvider((OwFieldProvider)this.m_searchtemplate);
                    ((OwRecordDocument)this.getDocument()).enableSearchTemplateView(criterias.size() > 0);
                    break;
                }
                this.m_searchtemplate = null;
                this.m_SearchCriteriaView.setCriteriaList(null);
                this.m_SearchCriteriaView.setHTMLFormular(null);
                this.m_SearchCriteriaView.setFieldProvider(null);
            }
        }
    }

    public void onDoReset(HttpServletRequest request_p, Object oReason_p) throws Exception {
        OwSearchTemplate searchtemplate = ((OwRecordDocument)this.getDocument()).getSearchTemplate();
        if (searchtemplate != null) {
            OwSearchNode currentSearch = searchtemplate.getSearch(true);
            currentSearch.reset();
            this.m_SearchCriteriaView.setCriteriaList(currentSearch.getCriteriaList(1));
            this.m_SearchCriteriaView.setHTMLFormular(searchtemplate.getHtmlLayout());
            this.m_SearchCriteriaView.setJspFormular(searchtemplate.getJspLayoutPage());
            this.getDocument().update((OwEventTarget)this, 4, null);
        }
    }

    public void onDoSearch(HttpServletRequest request_p, Object oReason_p) throws Exception {
        if (!this.m_SearchCriteriaView.onSubmitSearch(request_p)) {
            return;
        }
        if (((OwRecordDocument)this.getDocument()).supportLock() && ((OwRecordDocument)this.getDocument()).getCurrentRootFolder().canLock()) {
            ((OwRecordDocument)this.getDocument()).getCurrentRootFolder().setLock(true);
        }
        this.getDocument().update((OwEventTarget)this, 4, null);
    }

    protected void onRender(Writer w_p) throws Exception {
        if (this.m_searchtemplate != null) {
            w_p.write("<form name='" + this.getFormName() + "' method='post' action='" + this.m_MenuView.getNavigationFormAction(this.m_iSubmitBtnIndex) + "'>");
            if (this.m_SearchCriteriaView != null) {
                this.m_SearchCriteriaView.renderRegion(w_p, 9);
            }
            this.serverSideDesignInclude("owrecord/OwRecordSearchTemplateView.jsp", w_p);
            w_p.write("</form>");
            this.getContext().registerKeyFormEvent(13, 0, this.m_MenuView.getNavigationFormAction(this.m_iSubmitBtnIndex), this.getFormName(), this.getContext().localize("owrecord.OwRecordSearchTemplateView.search", "Suchen"));
        }
    }

    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 4: {
                if (this.m_searchtemplate == null) break;
                this.m_searchtemplate.getSearch(false).dump(w_p);
                break;
            }
            case 3: {
                w_p.write("<input type=\"text\" class=\"OwInputControl OwInputControlString OwInputControl_ow_MaxNoSearch\" size=\"4\" name=\"");
                w_p.write(MAX_RESULT_LIST_KEY);
                w_p.write("\" id=\"");
                w_p.write(MAX_RESULT_LIST_KEY);
                w_p.write("\" value=\"");
                w_p.write(String.valueOf(this.m_searchListSize));
                w_p.write("\">");
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        this.m_SearchCriteriaView.updateExternalFormTarget(request_p, fSave_p);
        String sMaxSize = request_p.getParameter(MAX_RESULT_LIST_KEY);
        if (null != sMaxSize) {
            try {
                this.m_searchListSize = Math.min(this.m_searchListSize, Integer.parseInt(sMaxSize));
                if (Integer.parseInt(sMaxSize) > this.m_searchListSize || Integer.parseInt(sMaxSize) < 0) {
                    ((OwRecordDocument)this.getDocument()).setMaxChildSize(this.m_searchListSize);
                    throw new OwInvalidOperationException(this.getContext().localize1("plug.owrecord.OwRecordSearchTemplateView.maxsizeexceeded", "The maximal number of documents is limited to %1", String.valueOf(this.m_iMaxSizeMax)));
                }
                ((OwRecordDocument)this.getDocument()).setMaxChildSize(this.m_searchListSize);
                this.m_searchListSize = Integer.parseInt(sMaxSize);
            }
            catch (NumberFormatException e) {
                throw new OwInvalidOperationException(this.getContext().localize1("plug.owrecord.OwRecordSearchTemplateView.maxsizeexceeded", "The maximal number of documents is limited to %1", String.valueOf(this.m_searchListSize)), (Throwable)e);
            }
        }
        return true;
    }

    public boolean isMaxResultEnabled() {
        OwRecordDocument document = (OwRecordDocument)this.getDocument();
        boolean maxSizeEnabled = document.isMaxSizeEnabled();
        return maxSizeEnabled;
    }

    public int getiMaxSizeMax() {
        return this.m_iMaxSizeMax;
    }

    public void setiMaxSizeMax(int m_iMaxSizeMax) {
        this.m_iMaxSizeMax = m_iMaxSizeMax;
    }
}

