/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owrecord;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.exceptions.OwLockDeniedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.plug.owrecord.OwRecordDocument;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class OwRecordSetView
extends OwView {
    private static final char SERIALIZE_PARAM_DELIMITER = ';';
    private static final char SERIALIZE_ENTRY_DELIMITER = '\n';
    public static final String PLUGIN_SETTING_RECENT_OBJECT_LIST = "recentrecordlist";
    protected static final String DISPLAY_NAME_NODE_NAME = "DisplayName";
    protected static final String DMS_ID_NODE_NAME = "DmsID";
    protected static final String OBJECT_ENTRY_NODE_NAME = "object";
    protected static final String BASE_NODE_NODE_NAME = "OwRecordSetView";
    public static final String QUERY_KEY_OBJECT_HASHCODE = "id";
    public static final String QUERY_KEY_OPEN_OBJECT = "OpenObject";
    protected List m_recentobjectlist = new ArrayList();
    protected int m_iMaxRecentRecordSize = 4;

    protected void init() throws Exception {
        super.init();
        this.m_iMaxRecentRecordSize = ((OwMasterDocument)this.getDocument()).getConfigNode().getSafeIntegerValue("MaxRecentRecordSize", 4);
        this.load();
    }

    public void onUpdate(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
        switch (iCode_p) {
            case 4: 
            case 5: {
                OwObject newObject = ((OwRecordDocument)this.getDocument()).getCurrentRootFolder();
                String strSubFolderPath = ((OwRecordDocument)this.getDocument()).getCurrentSubFolderPath();
                if (null == newObject) break;
                this.addObject(newObject, strSubFolderPath);
            }
        }
    }

    public OwObjectSetEntry findObjectEntry(OwObject object_p) throws Exception {
        for (OwObjectSetEntry nextEntry : this.m_recentobjectlist) {
            if (!nextEntry.m_strDmsID.equals(object_p.getDMSID())) continue;
            return nextEntry;
        }
        return null;
    }

    public void removeObjectEntry(OwObject object_p) throws Exception {
        Iterator it = this.m_recentobjectlist.iterator();
        while (it.hasNext()) {
            OwObjectSetEntry nextEntry = (OwObjectSetEntry)it.next();
            if (!nextEntry.m_strDmsID.equals(object_p.getDMSID())) continue;
            it.remove();
            return;
        }
    }

    public void addObject(OwObject object_p, String strSubFolderPath_p) throws Exception {
        String strDmsID = object_p.getDMSID();
        OwObjectSetEntry entry = this.findObjectEntry(object_p);
        if (null == entry) {
            OwObjectSetEntry newEntry = new OwObjectSetEntry((OwRepository)((OwMainAppContext)this.getContext()).getNetwork());
            newEntry.m_strDmsID = strDmsID;
            newEntry.m_strName = object_p.getName();
            newEntry.m_strSubFolderPath = strSubFolderPath_p;
            newEntry.m_iType = object_p.getType();
            this.addRecentEntry(newEntry);
            if (this.m_recentobjectlist.size() > this.m_iMaxRecentRecordSize) {
                this.m_recentobjectlist.remove(0);
            }
            this.save();
        } else {
            entry.m_strSubFolderPath = strSubFolderPath_p;
        }
    }

    protected void addRecentEntry(OwObjectSetEntry newEntry_p) {
        int entryType = newEntry_p.getType();
        if (entryType != 8207 && entryType != 8206) {
            this.m_recentobjectlist.add(newEntry_p);
        }
    }

    protected void save() throws Exception {
        StringBuffer serializedEntries = new StringBuffer();
        for (int i = 0; i < this.m_recentobjectlist.size(); ++i) {
            OwObjectSetEntry nextEntry = (OwObjectSetEntry)this.m_recentobjectlist.get(i);
            nextEntry.save(serializedEntries);
            serializedEntries.append('\n');
        }
        OwAttributeBagWriteable bag = this.getDocument().getPersistentAttributeBagWriteable();
        bag.setAttribute(PLUGIN_SETTING_RECENT_OBJECT_LIST, (Object)serializedEntries.toString());
        bag.save();
    }

    protected void load() throws Exception {
        OwAttributeBagWriteable bag = this.getDocument().getPersistentAttributeBagWriteable();
        String serializedEntries = (String)bag.getSafeAttribute(PLUGIN_SETTING_RECENT_OBJECT_LIST, (Object)"");
        this.m_recentobjectlist.clear();
        if (serializedEntries != null && !serializedEntries.equals("")) {
            StringTokenizer entrytokenizer = new StringTokenizer(serializedEntries, String.valueOf('\n'));
            while (entrytokenizer.hasMoreTokens()) {
                try {
                    OwObjectSetEntry entry = new OwObjectSetEntry(entrytokenizer.nextToken(), (OwRepository)((OwMainAppContext)this.getContext()).getNetwork());
                    this.addRecentEntry(entry);
                }
                catch (Exception e) {}
            }
        }
    }

    public void onOpenObject(HttpServletRequest request_p) throws Exception {
        int iHashCode = Integer.parseInt(request_p.getParameter(QUERY_KEY_OBJECT_HASHCODE));
        Iterator it = this.m_recentobjectlist.iterator();
        while (it.hasNext()) {
            OwObjectSetEntry entry = (OwObjectSetEntry)it.next();
            if (entry.hashCode() != iHashCode) continue;
            try {
                ((OwRecordDocument)this.getDocument()).openFolder(entry.getInstance(), entry.m_strSubFolderPath);
            }
            catch (OwLockDeniedException e) {
                throw e;
            }
            catch (Exception e) {
                it.remove();
                this.save();
                throw new OwObjectNotFoundException(this.getContext().localize("plug.owrecord.OwRecordSetView.objectnotfound", "The object could not be found."), (Throwable)e);
            }
        }
    }

    public List getRecentObjectList() {
        return this.m_recentobjectlist;
    }

    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("owrecord/OwRecordSetView.jsp", w_p);
    }

    public static class OwObjectSetEntry
    implements OwObjectReference {
        private OwRepository m_repository;
        protected String m_strName;
        protected int m_iType;
        protected String m_strDmsID;
        protected String m_sMimeType;
        protected String m_strSubFolderPath;

        public OwObjectSetEntry(OwRepository repository_p) throws Exception {
            this.m_repository = repository_p;
        }

        public OwObjectSetEntry(String sSerializedEntry_p, OwRepository repository_p) {
            StringTokenizer paramtokenizer = new StringTokenizer(sSerializedEntry_p, String.valueOf(';'));
            this.m_strDmsID = paramtokenizer.nextToken();
            this.m_sMimeType = paramtokenizer.nextToken();
            this.m_iType = Integer.parseInt(paramtokenizer.nextToken());
            this.m_strName = paramtokenizer.nextToken();
            this.m_repository = repository_p;
        }

        public OwObject getInstance() throws Exception {
            return this.m_repository.getObjectFromDMSID(this.m_strDmsID, true);
        }

        public String getResourceID() throws Exception {
            throw new OwObjectNotFoundException("OwRecordSetView$OwObjectSetEntry.getResourceID: Not implemented or Not supported.");
        }

        public void save(StringBuffer buf_p) throws Exception {
            buf_p.append(this.getDMSID());
            buf_p.append(';');
            buf_p.append(this.getMIMEType());
            buf_p.append(';');
            buf_p.append(String.valueOf(this.getType()));
            buf_p.append(';');
            buf_p.append(this.getName());
            buf_p.append('\n');
        }

        public String getName() {
            return this.m_strName;
        }

        public String getID() {
            return this.m_strName;
        }

        public int getType() {
            return this.m_iType;
        }

        public String getDMSID() throws Exception {
            return this.m_strDmsID;
        }

        public int getPageCount() throws Exception {
            return 0;
        }

        public String getMIMEType() throws Exception {
            return this.m_sMimeType;
        }

        public String getMIMEParameter() throws Exception {
            return "";
        }

        public boolean hasContent(int iContext_p) throws Exception {
            return false;
        }

        public String getSubFolderPath() {
            return this.m_strSubFolderPath;
        }
    }
}

