/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owrecord;

import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwEcmUtil;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterView;
import com.wewebu.ow.server.app.OwScript;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectTreeView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectTreeViewEXTJS;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.plug.owrecord.OwRecordContentView;
import com.wewebu.ow.server.plug.owrecord.OwRecordDocument;
import com.wewebu.ow.server.plug.owrecord.OwRecordPreviewPropertyView;
import com.wewebu.ow.server.plug.owrecord.OwRecordRecordFunctionDnDView;
import com.wewebu.ow.server.plug.owrecord.OwRecordRecordFunctionView;
import com.wewebu.ow.server.plug.owrecord.OwRecordSearchTemplateView;
import com.wewebu.ow.server.plug.owrecord.OwRecordSetView;
import com.wewebu.ow.server.plug.owrecord.OwRecordSubLayout;
import com.wewebu.ow.server.plug.owrecord.OwRecordTreeView;
import com.wewebu.ow.server.plug.owrecord.log.OwLog;
import com.wewebu.ow.server.ui.OwTreeView;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class OwRecordView
extends OwMasterView {
    private static final String UPDATE_AJAX_EVENT_NAME = "Update";
    private static final Logger LOG = OwLog.getLogger(OwRecordView.class);
    public static final String PLUGIN_PARAM_STARTUP_FOLDER = "StartupFolder";
    private OwRecordSubLayout m_Layout;
    private OwRecordContentView m_documentList;
    private OwTreeView m_objectTreeView;
    private OwRecordRecordFunctionView m_recordFunctionsView;
    private OwRecordRecordFunctionDnDView m_recordFunctionsDnDView;
    private boolean postPoneInit = true;

    protected void init() throws Exception {
        List docfunctionsList;
        LinkedHashSet docfunctions;
        super.init();
        this.m_Layout = this.createRecordSubLayout();
        this.addView((OwView)this.m_Layout, null);
        if (((OwRecordDocument)this.getDocument()).getIsPluginsEnabled()) {
            this.m_recordFunctionsDnDView = this.createRecordRecordFunctionDnDView();
            this.m_recordFunctionsView = this.createRecordRecordFunctionView();
            this.m_Layout.addView(this.m_recordFunctionsDnDView, 4, null);
            this.m_Layout.addView(this.m_recordFunctionsView, 1, null);
        }
        this.m_objectTreeView = this.createObjectTreeView();
        ((OwRecordDocument)this.getDocument()).setResultTreeView(this.m_objectTreeView);
        OwRecordTreeView navigationViewTree = new OwRecordTreeView(this.m_objectTreeView, 1);
        this.m_Layout.addView(navigationViewTree, 0, null);
        OwRecordTreeView navigationViewRegister = new OwRecordTreeView(this.m_objectTreeView, 2);
        this.m_Layout.addView(navigationViewRegister, 27, null);
        navigationViewTree.addView((OwView)this.m_objectTreeView, null);
        LinkedList<OwDocumentFunction> filteredDocumentFunctions = null;
        OwXMLUtil documentFunctionsNode = ((OwRecordDocument)this.getDocument()).getDocumentFunctionsNode();
        if (documentFunctionsNode != null && documentFunctionsNode.getSafeBooleanAttributeValue("enable", false) && (docfunctions = new LinkedHashSet(docfunctionsList = documentFunctionsNode.getSafeStringList())).size() != 0) {
            filteredDocumentFunctions = new LinkedList<OwDocumentFunction>();
            for (String id : docfunctions) {
                if (!((OwMainAppContext)this.getContext()).getConfiguration().isDocumentFunctionAllowed(id)) continue;
                OwDocumentFunction func = ((OwMainAppContext)this.getContext()).getConfiguration().getDocumentFunction(id);
                filteredDocumentFunctions.add(func);
            }
        }
        this.m_documentList = this.createRecordContentView();
        if (filteredDocumentFunctions != null && documentFunctionsNode.getSafeBooleanAttributeValue("enable", false)) {
            this.m_documentList.setDocumentFunctionPluginList(filteredDocumentFunctions);
        }
        if (documentFunctionsNode != null && !documentFunctionsNode.getSafeBooleanAttributeValue("enable", false)) {
            this.m_documentList.setDocumentFunctionPluginList(new LinkedList());
        }
        this.m_Layout.addView((OwView)this.m_documentList, 2, null);
        if (this.getConfigNode().getSafeBooleanValue("RecentRecordList", true)) {
            OwRecordSetView recentRecordSetView = this.createRecordSetView();
            this.m_Layout.addView(recentRecordSetView, 3, null);
        }
        OwRecordSearchTemplateView stv = this.createRecordSearchTemplateView();
        this.m_Layout.addView((OwView)stv, 25, null);
        navigationViewTree.setExternalFormTarget(stv.getFormTarget());
        OwRecordPreviewPropertyView recordPreviewPropertyView = this.createRecordPreviewPropertyView();
        recordPreviewPropertyView.setDynamicSplitUsed(this.isDynamicSplitUsed());
        this.m_Layout.addView((OwView)recordPreviewPropertyView, 26, null);
        this.addAjaxUpdateZone(this.m_objectTreeView, "OwRecordPreviewPropertyView");
        if (!this.isInitPostponed()) {
            this.loadStartUpFolder();
        }
    }

    protected void loadStartUpFolder() throws Exception {
        String startupFolderConfiguration = this.getConfigNode().getSafeTextValue(PLUGIN_PARAM_STARTUP_FOLDER, null);
        if (startupFolderConfiguration != null) {
            StringBuffer buffer = new StringBuffer(startupFolderConfiguration);
            String userName = this.getContext().getUserInfo().getUserName();
            OwString.replaceAll((StringBuffer)buffer, (String)"{username}", (String)userName);
            String startupFolderPath = buffer.toString();
            OwObject startupFolder = null;
            try {
                startupFolder = OwEcmUtil.createObjectFromString((OwMainAppContext)((OwMainAppContext)this.getContext()), (String)startupFolderPath);
            }
            catch (OwObjectNotFoundException e1) {
                LOG.error((Object)"Invalid startup folder configuration.", (Throwable)e1);
                buffer = new StringBuffer(startupFolderConfiguration);
                OwString.replaceAll((StringBuffer)buffer, (String)"{username}", (String)"");
                OwString.replaceAll((StringBuffer)buffer, (String)"//", (String)"/");
                startupFolderPath = buffer.toString();
                try {
                    startupFolder = OwEcmUtil.createObjectFromString((OwMainAppContext)((OwMainAppContext)this.getContext()), (String)startupFolderPath);
                }
                catch (OwObjectNotFoundException e2) {
                    LOG.error((Object)"Invalid startup folder configuration.Could not proceed with ", (Throwable)e2);
                }
            }
            ((OwRecordDocument)this.getDocument()).openFolder(startupFolder, null);
        }
    }

    protected void onActivate(int iIndex_p, Object oReason_p) throws Exception {
        if (this.isInitPostponed()) {
            if (null == ((OwRecordDocument)this.getDocument()).getCurrentRootFolder()) {
                this.loadStartUpFolder();
            }
            this.setPostPoneInit(false);
        }
        super.onActivate(iIndex_p, oReason_p);
    }

    private OwRecordRecordFunctionDnDView createRecordRecordFunctionDnDView() {
        return new OwRecordRecordFunctionDnDView();
    }

    private boolean isDynamicSplitUsed() {
        return this.getConfigNode().getSafeBooleanValue("UseDynamicSplit", false);
    }

    protected OwTreeView createObjectTreeView() throws OwConfigurationException {
        OwRecordObjectTreeView result = null;
        OwXMLUtil treeViewConf = null;
        boolean isDynamicSplitUsed = this.isDynamicSplitUsed();
        try {
            treeViewConf = this.getConfigNode().getSubUtil("TreeView");
        }
        catch (Exception e) {
            result = new OwRecordObjectTreeView();
            result.setMaxChildSize(((OwRecordDocument)this.getDocument()).getMaxChildSize());
            result.setIsDynamicSplitUsed(isDynamicSplitUsed);
        }
        if (treeViewConf != null) {
            String className = treeViewConf.getSafeStringAttributeValue("classname", OwRecordObjectTreeView.class.getName());
            try {
                if (className.equals(OwRecordObjectTreeView.class.getName())) {
                    result = new OwRecordObjectTreeView();
                } else {
                    Class<?> treeViewClass = Class.forName(className);
                    result = (OwTreeView)treeViewClass.newInstance();
                }
                if (result instanceof OwObjectTreeView) {
                    ((OwObjectTreeView)result).setMaxChildSize(((OwRecordDocument)this.getDocument()).getMaxChildSize());
                    ((OwObjectTreeView)result).setIsDynamicSplitUsed(isDynamicSplitUsed);
                }
                if (result instanceof OwObjectTreeViewEXTJS) {
                    OwObjectTreeViewEXTJS ajaxTree = (OwObjectTreeViewEXTJS)result;
                    boolean expandOnSelect = treeViewConf.getSafeBooleanValue("ExpandOnSelect", false);
                    ajaxTree.setExternalUpdateURL(this.getAjaxEventURL(UPDATE_AJAX_EVENT_NAME, null));
                    if (this.m_recordFunctionsDnDView != null && null != this.m_recordFunctionsDnDView.getDnD()) {
                        ajaxTree.setDnDAppletURL(this.m_recordFunctionsDnDView.getAjaxEventURL("UpdateDnDAppletRegion", null));
                    }
                    ajaxTree.setExpandOnSelect(expandOnSelect);
                    if (((OwRecordDocument)this.getDocument()).getIsPluginsEnabled() && this.m_recordFunctionsView != null) {
                        ajaxTree.addComponentUpdateURL("OwRegion_menu", this.m_Layout.getAjaxEventURL("UpdateMenuRegion", null));
                        ajaxTree.addComponentUpdateURL("OwRegion_hotkey", this.m_Layout.getAjaxEventURL("UpdateHotkeyRegion", null));
                    }
                    ajaxTree.addComponentUpdateURL("OwRegion_searchtemplate", this.m_Layout.getAjaxEventURL("UpdateSearchTemplatesRegion", null));
                    this.addAjaxUpdateZone((OwTreeView)ajaxTree, "OwMainLayout_ERROR_container");
                    this.addAjaxUpdateZone((OwTreeView)ajaxTree, "OwMainLayout_MESSAGE_container");
                    this.addAjaxUpdateZone((OwTreeView)ajaxTree, "owkeyinfo");
                    this.addAjaxUpdateZone((OwTreeView)ajaxTree, "registeredKeysScripts");
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot configure class: " + className), (Throwable)e);
                throw new OwConfigurationException(this.getContext().localize("owrecord.OwRecordView.cannotConfigureTreeclass", "Cannot configure tree view class"), (Throwable)e);
            }
        }
        if (result == null) {
            result = new OwRecordObjectTreeView();
            result.setMaxChildSize(((OwRecordDocument)this.getDocument()).getMaxChildSize());
        }
        result.setChildrenSort(((OwRecordDocument)this.getDocument()).getFolderSortCriteria());
        return result;
    }

    private void addAjaxUpdateZone(OwTreeView ajaxTree_p, String containerID_p) {
        if (ajaxTree_p instanceof OwObjectTreeViewEXTJS) {
            OwObjectTreeViewEXTJS ajaxTree = (OwObjectTreeViewEXTJS)ajaxTree_p;
            String previewPropertiesUpdateURL = ((OwMainAppContext)this.getContext()).getAjaxUpdateURL(containerID_p);
            if (previewPropertiesUpdateURL != null) {
                ajaxTree.addComponentUpdateURL(containerID_p, previewPropertiesUpdateURL);
            }
        }
    }

    protected OwRecordContentView createRecordContentView() {
        return new OwRecordContentView();
    }

    protected OwRecordSearchTemplateView createRecordSearchTemplateView() {
        return new OwRecordSearchTemplateView();
    }

    protected OwRecordPreviewPropertyView createRecordPreviewPropertyView() {
        return new OwRecordPreviewPropertyView();
    }

    protected OwRecordSetView createRecordSetView() {
        return new OwRecordSetView();
    }

    protected OwRecordRecordFunctionView createRecordRecordFunctionView() {
        return new OwRecordRecordFunctionView();
    }

    protected OwRecordSubLayout createRecordSubLayout() {
        return new OwRecordSubLayout();
    }

    public void onAjaxUpdate(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        PrintWriter writer = response_p.getWriter();
        String nodeId = request_p.getParameter("owNodeId");
        if (nodeId != null) {
            ((OwMainAppContext)this.getContext()).setError(null);
            ((OwMainAppContext)this.getContext()).resetMessages();
            this.m_objectTreeView.navigateToId(nodeId);
            this.m_documentList.render(writer);
        } else {
            response_p.setStatus(405);
            writer.write("Cannot navigate!");
        }
        writer.close();
    }

    public void setPostPoneInit(boolean postPone_p) {
        this.postPoneInit = postPone_p;
    }

    public boolean isInitPostponed() {
        return this.postPoneInit;
    }

    public class OwRecordObjectTreeView
    extends OwObjectTreeView {
        protected String getSelectedTreeItemStyle() {
            return "OwRecordTreeViewTextSelected";
        }

        protected String getTreeItemStyle() {
            return "OwRecordTreeViewText";
        }

        protected boolean useFormEventUrls() {
            try {
                OwSearchTemplate searchtemplate = ((OwRecordDocument)this.getDocument()).getSearchTemplate();
                if (searchtemplate != null) {
                    return ((OwRecordDocument)this.getDocument()).isSearchTemplateViewEnabled();
                }
                return false;
            }
            catch (Exception e) {
                return super.useFormEventUrls();
            }
        }

        public void navigate(Object obj_p, String strPath_p) throws Exception {
            super.navigate(obj_p, strPath_p);
            if (this.getDisplayMode() == 1 && this.m_root != this.m_selectedNode) {
                this.m_focusNode = this.m_selectedNode;
                this.m_selectedNode.toggleExpand();
                if (!this.m_selectedNode.isCollapsed() && this.m_eventlistner != null) {
                    this.m_eventlistner.onTreeViewNavigateFolder(this.m_selectedNode);
                }
            }
        }

        protected void onRender(Writer w_p) throws Exception {
            if (!this.isEmpty() && this.getDisplayMode() == 1) {
                w_p.write("<div id=\"OwTreeView_");
                w_p.write(String.valueOf(((Object)((Object)this)).hashCode()));
                w_p.write("\" class=\"OwTreeView\">");
            }
            super.onRender(w_p);
            if (!this.isEmpty() && this.getDisplayMode() == 1) {
                w_p.write("</div>");
            }
            if (this.getDisplayMode() == 1 && this.m_root != this.m_selectedNode) {
                OwScript script_p = new OwScript("scrollElementToView('OwTreeViewNode_" + String.valueOf(this.m_selectedNode.hashCode()) + "','OwTreeView_" + String.valueOf(((Object)((Object)this)).hashCode()) + "');", 90);
                ((OwMainAppContext)this.getContext()).addFinalScript(script_p);
            }
        }

        public void onClickPlusMinus(HttpServletRequest request_p) throws Exception {
            super.onClickPlusMinus(request_p);
        }

        public void onClickLabel(HttpServletRequest request_p) throws Exception {
            super.onClickLabel(request_p);
        }
    }
}

