/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owaddmultidocuments;

import com.wewebu.ow.server.app.OwDocumentImportItem;
import com.wewebu.ow.server.app.OwDocumentImporter;
import com.wewebu.ow.server.app.OwDocumentImporterCallback;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectClassProcessor;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectClassView;
import com.wewebu.ow.server.ecm.OwLocation;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectSkeleton;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwVirtualFolderObject;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwDocument;
import com.wewebu.ow.server.ui.OwEventTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.wd.ui.conf.OwPropertyListConfiguration;
import org.alfresco.wd.ui.conf.prop.OwPropertyInfo;
import org.apache.log4j.Logger;

public class OwAddMultiDocumentsDocument
extends OwDocument
implements OwDocumentImporterCallback,
OwObjectClassView.OwObjectClassViewListner,
OwLocation {
    private static final Logger LOG = OwLog.getLogger(OwAddMultiDocumentsDocument.class);
    private OwObjectSkeleton m_skeletonObject;
    private List m_importedDocumentsList;
    protected OwResource m_resource;
    protected OwObject m_parentFolder;
    protected List<OwPropertyInfo> m_propertyInfos;
    private boolean showProcessView;
    private boolean undefinedObjectClass;
    private String strClassName;
    private OwObjectClassProcessor objectClassProcessor;
    protected String strUserSelectedClassName;
    private OwPropertyListConfiguration propertyListConfiguration;

    public OwAddMultiDocumentsDocument(OwResource resource_p, OwObject parentFolder_p) {
        this.m_resource = resource_p;
        this.m_parentFolder = parentFolder_p;
        this.m_importedDocumentsList = new ArrayList();
        this.showProcessView = false;
        this.undefinedObjectClass = false;
        this.m_propertyInfos = new LinkedList<OwPropertyInfo>();
    }

    public OwResource getResource() {
        return this.m_resource;
    }

    public Collection<OwPropertyInfo> getPropertyInfos() {
        return this.m_propertyInfos;
    }

    public void setObjectClass(OwObjectClass objectClass_p) throws Exception {
        OwMainAppContext context = (OwMainAppContext)this.getContext();
        OwObjectClass clazz = this.preProcessObjectClass(objectClass_p);
        this.m_skeletonObject = this.createSkeletonObject(clazz, context);
        if (this.m_skeletonObject == null) {
            String msg = "OwAddMultiDocumentsDocument.setObjectClass: Fatal error, network returned null for object class named=" + objectClass_p.getClassName();
            LOG.fatal((Object)msg);
            throw new OwInvalidOperationException(msg);
        }
        OwVirtualFolderObject parentVirtualFolder = null;
        try {
            parentVirtualFolder = (OwVirtualFolderObject)this.m_parentFolder;
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        if (parentVirtualFolder != null) {
            try {
                parentVirtualFolder.setFiledObjectProperties(objectClass_p, this.m_skeletonObject.getProperties(null));
            }
            catch (Exception e) {
                if (context.getDragAndDropUploadDir() != null) {
                    context.clearDragDropUploadDir();
                }
                throw e;
            }
            this.m_propertyInfos = new LinkedList<OwPropertyInfo>();
            OwStandardPropertyCollection tempFilledProperties = new OwStandardPropertyCollection();
            parentVirtualFolder.setFiledObjectProperties(objectClass_p, (OwPropertyCollection)tempFilledProperties);
            for (String propName : this.m_skeletonObject.getProperties(null).keySet()) {
                if (!tempFilledProperties.containsKey((Object)propName)) continue;
                this.m_propertyInfos.add(new OwPropertyInfo(propName, Boolean.TRUE.booleanValue()));
            }
        }
        if (this.getUserSelectedClassName() != null && !this.getUserSelectedClassName().equals(this.m_skeletonObject.getObjectClass().getClassName())) {
            this.setUserSelectedClassName(this.m_skeletonObject.getObjectClass().getClassName());
        }
        if (this.getImportedDocumentsCount() > 0) {
            this.update((OwEventTarget)this, 5, null);
        }
    }

    protected OwObjectSkeleton createSkeletonObject(OwObjectClass objectClass_p, OwMainAppContext context_p) throws Exception {
        return context_p.getNetwork().createObjectSkeleton(objectClass_p, this.m_resource);
    }

    public OwObjectSkeleton getSkeletonObject(boolean fRenew_p) throws Exception {
        if (fRenew_p) {
            this.m_skeletonObject.refreshProperties();
            OwVirtualFolderObject parentVirtualFolder = null;
            if (this.m_parentFolder != null) {
                try {
                    parentVirtualFolder = (OwVirtualFolderObject)this.m_parentFolder;
                    parentVirtualFolder.setFiledObjectProperties(this.m_skeletonObject.getObjectClass(), this.m_skeletonObject.getProperties(null));
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return this.m_skeletonObject;
    }

    public OwDocumentImportItem getImportedDocument(int idx_p) {
        return ((OwDocumentImportEntry)this.m_importedDocumentsList.get(idx_p)).getItem();
    }

    public int getImportedDocumentsCount() {
        return this.m_importedDocumentsList.size();
    }

    public void releaseImportedDocument(OwDocumentImportItem importedDocument_p) throws Exception {
        int removeItemIndex = -1;
        for (int i = 0; i < this.m_importedDocumentsList.size(); ++i) {
            OwDocumentImportItem item = ((OwDocumentImportEntry)this.m_importedDocumentsList.get(i)).getItem();
            if (!item.getContentMimeType(0).equals(importedDocument_p.getContentMimeType(0)) || !item.getProposedDocumentName().equals(importedDocument_p.getProposedDocumentName())) continue;
            removeItemIndex = i;
            break;
        }
        if (removeItemIndex != -1) {
            ((OwDocumentImportEntry)this.m_importedDocumentsList.get(removeItemIndex)).getItem().release();
            this.m_importedDocumentsList.remove(removeItemIndex);
        }
    }

    public void releaseImportedDocuments() throws Exception {
        for (int i = 0; i < this.m_importedDocumentsList.size(); ++i) {
            ((OwDocumentImportEntry)this.m_importedDocumentsList.get(i)).getItem().release();
        }
        this.m_importedDocumentsList.clear();
    }

    public void onDocumentImported(OwDocumentImporter importer_p, OwDocumentImportItem importedDocument_p) throws Exception {
        if (importedDocument_p == null) {
            throw new NullPointerException("OwAddMultiDocumentsDocument.onDocumentImported: the DocumentImportItem should not be null");
        }
        this.m_importedDocumentsList.add(new OwDocumentImportEntry(importedDocument_p, importer_p));
        if (!this.showProcessView()) {
            this.setShowProcessViewFlag(importer_p != null ? importer_p.hasPostProcessView(1) : false);
        }
        if (!this.hasUndefinedObjectClass()) {
            this.setUndefinedObjectClassFlag(importedDocument_p.getObjectClassName() == null);
        }
        if (this.m_skeletonObject != null && this.getImportedDocumentsCount() == 1) {
            try {
                if (importedDocument_p.getObjectClassName() != null) {
                    this.setObjectClass(((OwMainAppContext)this.getContext()).getNetwork().getObjectClass(importedDocument_p.getObjectClassName(), this.getResource()));
                } else {
                    this.setObjectClass(this.m_skeletonObject.getObjectClass());
                }
            }
            catch (Exception e) {
                LOG.error((Object)"OwAddMultiDocumentsDocument.onDocumentImported: faild to reset object class", (Throwable)e);
            }
        }
    }

    public OwDocumentImporter getDocumentImporter(OwDocumentImportItem item_p) {
        if (item_p != null) {
            for (int i = 0; i < this.m_importedDocumentsList.size(); ++i) {
                OwDocumentImportEntry entry = (OwDocumentImportEntry)this.m_importedDocumentsList.get(i);
                if (entry.getItem() != item_p) continue;
                return this.getDocumentImporter(i);
            }
        }
        return null;
    }

    public OwDocumentImporter getDocumentImporter(int i_p) {
        return ((OwDocumentImportEntry)this.m_importedDocumentsList.get(i_p)).getImporter();
    }

    public boolean showProcessView() {
        return this.showProcessView;
    }

    public boolean hasUndefinedObjectClass() {
        return this.undefinedObjectClass;
    }

    protected void setUndefinedObjectClassFlag(boolean value_p) {
        this.undefinedObjectClass = value_p;
    }

    protected void setShowProcessViewFlag(boolean value_p) {
        this.showProcessView = value_p;
    }

    public String getClassName() {
        return this.strClassName;
    }

    public void setClassName(String objectClassname_p) {
        this.strClassName = objectClassname_p;
    }

    public String getUserSelectedClassName() {
        return this.strUserSelectedClassName;
    }

    protected void setUserSelectedClassName(String userSelectedObjectClass_p) {
        this.strUserSelectedClassName = userSelectedObjectClass_p;
    }

    public boolean isValidObjecClass(String objectClass_p) {
        try {
            OwMainAppContext context = (OwMainAppContext)this.getContext();
            context.getNetwork().getObjectClass(objectClass_p, this.getResource());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void onObjectClassViewSelectClass(OwObjectClass classDescription_p, String strPath_p) throws Exception {
        this.setUserSelectedClassName(classDescription_p.getClassName());
        this.setObjectClass(classDescription_p);
    }

    protected OwObjectClass preProcessObjectClass(OwObjectClass objCls_p) throws OwException {
        if (this.getObjectClassProcessor() != null) {
            return this.getObjectClassProcessor().process(objCls_p, (OwLocation)this, this.getContext());
        }
        return objCls_p;
    }

    public void setObjectClassProcessor(OwObjectClassProcessor processor) {
        this.objectClassProcessor = processor;
    }

    public OwObjectClassProcessor getObjectClassProcessor() {
        return this.objectClassProcessor;
    }

    public OwObject getParent() {
        return this.m_parentFolder;
    }

    public OwPropertyListConfiguration getPropertyListConfiguration() {
        return this.propertyListConfiguration;
    }

    public void setPropertyListConfiguration(OwPropertyListConfiguration propertyListConfiguration) {
        this.propertyListConfiguration = propertyListConfiguration;
    }

    public void detach() {
        super.detach();
        if (this.propertyListConfiguration != null) {
            this.propertyListConfiguration = null;
        }
    }

    private static class OwDocumentImportEntry {
        private OwDocumentImportItem item;
        private OwDocumentImporter importer;

        public OwDocumentImportEntry(OwDocumentImportItem item_p, OwDocumentImporter importer_p) {
            this.item = item_p;
            this.importer = importer_p;
        }

        public OwDocumentImportItem getItem() {
            return this.item;
        }

        public OwDocumentImporter getImporter() {
            return this.importer;
        }
    }
}

