/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdoccopy;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwClipboard;
import com.wewebu.ow.server.app.OwClipboardContentOwObject;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwRecordFunction;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owdoccopy.OwClipboardMoveOperation;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OwRecordFunctionMove
extends OwRecordFunction {
    private Set m_supportedObjectTypes = new HashSet();
    private Set<?> m_supportedObjectClasses;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        super.init(node_p, context_p);
        this.m_supportedObjectTypes = this.getSupportedObjectTypesFromDescriptor("pasteitemobjecttypes");
        this.m_supportedObjectClasses = this.getSupportedObjectClassesFromDescriptor("pasteitemobjectclasses");
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owmove/move.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owmove/move_24.png");
    }

    public boolean isEnabled(OwObject rootObject_p, OwObject folderObject_p, int iContext_p) throws Exception {
        if (!super.isEnabled(rootObject_p, folderObject_p, iContext_p)) {
            return false;
        }
        if (folderObject_p == null) {
            return false;
        }
        OwClipboard clipboard = this.getContext().getClipboard();
        if (1 != clipboard.getContentType()) {
            return false;
        }
        for (OwClipboardContentOwObject item : clipboard.getContent()) {
            if (!this.m_supportedObjectTypes.contains(item.getObject().getType())) {
                return false;
            }
            if (this.m_supportedObjectClasses != null && !this.m_supportedObjectClasses.contains(item.getObject().getClassName())) {
                return false;
            }
            if (folderObject_p.canMove(item.getObject(), item.getParent(), iContext_p)) continue;
            return false;
        }
        return true;
    }

    public void onClickEvent(OwObject rootObject_p, final OwObject folderObject_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(rootObject_p, folderObject_p, 2)) {
            this.addHistoryEvent(rootObject_p, folderObject_p, 3, 5);
            throw new OwInvalidOperationException(new OwString("plug.owdoccopy.OwRecordFunctionMove.invalidobject", "Item cannot be moved."));
        }
        OwClipboard clipboard = this.getContext().getClipboard();
        OwClipboardMoveOperation clipboardOperation = null;
        try {
            clipboardOperation = new OwClipboardMoveOperation(clipboard, null){

                @Override
                protected void processClipboardElement(OwClipboardContentOwObject element, Map propertyMap) throws Exception {
                    folderObject_p.move(element.getObject(), element.getParent());
                }
            };
            clipboardOperation.execute();
        }
        catch (Exception e) {
            this.addHistoryEvent(rootObject_p, folderObject_p, 3, 2);
            throw e;
        }
        this.addHistoryEvent(rootObject_p, folderObject_p, 3, 1);
        if (null != refreshCtx_p) {
            if (null != clipboardOperation) {
                clipboardOperation.sendUpdates(refreshCtx_p);
            }
            refreshCtx_p.onClientRefreshContextUpdate(4, null);
        }
    }
}

