/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdocprops;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwJspFormConfigurator;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectPropertyFormularView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectPropertyView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectLinkRelation;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.plug.owdocprops.OwEditPropertiesDialog;
import com.wewebu.ow.server.plug.owdocprops.OwEditPropertiesDialogBuilder;
import com.wewebu.ow.server.plug.owdocprops.OwEditPropertiesModifiabilityHandler;
import com.wewebu.ow.server.plug.owutil.OwConfigUtils;
import com.wewebu.ow.server.plug.owutil.OwObjectUtils;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.wd.ui.conf.OwPropertyListConfiguration;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwEditDocumentPropertiesFunction
extends OwDocumentFunction
implements OwDialog.OwDialogListener {
    private static final Logger LOG = OwLog.getLogger(OwEditDocumentPropertiesFunction.class);
    public static final String ELEM_PROP_VIEW = "PropertiesView";
    public static final String ELEM_SYS_PROP_VIEW = "SystemPropertiesView";
    public static final String ELEM_VERSIONS_VIEW = "VersionsView";
    public static final String ELEM_HISTORY_VIEW = "HistoryView";
    public static final String ELEM_FILED_VIEW = "FiledInView";
    public static final String ELEM_ACL_VIEW = "AccessRightsView";
    public static final String ELEM_LINKS_VIEW = "LinksView";
    public static final String ELEM_AUTO_OPEN = "AutoOpen";
    public static final String ELEM_MOD_HANDLER = "ModifiabilityHandler";
    private OwJspFormConfigurator m_owJspFormConfigurator;
    private OwPropertyListConfiguration propertyListConfiguration;
    private OwEditPropertiesModifiabilityHandler modifiablityHandler;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        String className;
        OwXMLUtil modConf;
        super.init(node_p, context_p);
        this.m_owJspFormConfigurator = new OwJspFormConfigurator(node_p);
        OwXMLUtil util = this.getConfigNode().getSubUtil("EditPropertyList");
        if (util != null) {
            this.propertyListConfiguration = new OwPropertyListConfiguration(this.getPluginID());
            this.propertyListConfiguration.build(util);
        }
        if ((modConf = this.getConfigNode().getSubUtil(ELEM_MOD_HANDLER)) != null && (className = modConf.getSafeStringAttributeValue("class", "com.wewebu.ow.server.plug.owdocprops.OwExpressionModifiabilityHandler")) != null) {
            Class<?> cls;
            try {
                cls = Class.forName(className);
            }
            catch (ClassNotFoundException cnfEx) {
                throw new OwConfigurationException(this.getContext().localize1("owdocprops.OwEditDocumentPropertiesFunction.init.err.modifabilityHandler.class", "Unable to find handler with class %1.", className), (Throwable)cnfEx);
            }
            this.modifiablityHandler = (OwEditPropertiesModifiabilityHandler)cls.newInstance();
            this.modifiablityHandler.init((OwAppContext)this.getContext(), modConf);
        }
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owdocprops/edit_properties.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdocprops/edit_properties_24.png");
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(oObject_p, oParent_p, 2)) {
            LOG.debug((Object)"OwEditDocumentProperties.onClickEvent(): the edit function is not enabled for the given object !");
            throw new OwInvalidOperationException(new OwString("owdocprops.edit.properties.function.invalid.invalid.object", "Item can not be edited!"));
        }
        LinkedList<OwObject> objects = new LinkedList<OwObject>();
        objects.add(oObject_p);
        this.onMultiselectClickEvent(objects, oParent_p, refreshCtx_p);
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        LinkedList<OwObject> enabledObjects = new LinkedList<OwObject>();
        for (OwObject objectToEdit : objects_p) {
            if (!this.isEnabled(objectToEdit, oParent_p, 2)) continue;
            enabledObjects.add(objectToEdit);
        }
        if (enabledObjects.isEmpty()) {
            LOG.error((Object)"OwEditDocumentProperties.onMultiselectClickEvent(): Invalid object collection!The enabled objects collection is empty!");
            throw new OwInvalidOperationException(new OwString("owdocprops.edit.properties.function.invalid.object.collection", "Invalid object collection!"));
        }
        List batchIndexProperties = this.getConfigNode().getSafeStringList("EditBatchPropertyList");
        int iViewMask = this.calculateViewMask(this.getConfigNode());
        int iReadOnlyViewMask = this.calculateReadOnlyViewMask(this.getConfigNode());
        OwSearchTemplate historySearchTemplate = null;
        List historyViewColumnInfo = null;
        if ((iViewMask & 0x10) == 16) {
            String strHistoryViewSearchTemplate = this.getConfigNode().getSafeTextValue("HistoryViewSearchTemplate", null);
            if (null != strHistoryViewSearchTemplate) {
                historySearchTemplate = (OwSearchTemplate)this.getContext().getNetwork().getApplicationObject(3, strHistoryViewSearchTemplate, false, false);
                historySearchTemplate.init((OwFieldDefinitionProvider)this.getContext().getHistoryManager());
            } else {
                historyViewColumnInfo = (List)this.getSafeSetting("HistoryViewColumnInfo", null);
                if (historyViewColumnInfo == null) {
                    String msg = "OwEditDocumentProperties.onMultiselectClickEvent: Please specify either &lt;HistoryViewSearchTemplate&gt; ... or &lt;settingsset&gt; &lt;HistoryViewColumnInfo&gt; in the plugin descriptor, PluginId = " + this.getPluginID();
                    LOG.fatal((Object)msg);
                    throw new OwConfigurationException(msg);
                }
            }
        }
        Collection<Object> objects = enabledObjects;
        if (this.getConfigNode().getSafeBooleanValue("AlwaysUseLatestVersion", false)) {
            objects = OwObjectUtils.getLatesVersionObjects(enabledObjects);
        }
        OwXMLUtil linksViewConfig = this.getConfigNode().getSubUtil(ELEM_LINKS_VIEW);
        OwObjectLinkRelation split = OwObjectLinkRelation.BOTH;
        List linkClassNames = Collections.EMPTY_LIST;
        boolean displayTypedList = true;
        if (linksViewConfig != null) {
            displayTypedList = linksViewConfig.getSafeBooleanAttributeValue("typeList", true);
            String direction = linksViewConfig.getSafeStringAttributeValue("direction", "BOTH");
            try {
                split = OwObjectLinkRelation.valueOf((String)direction);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)("Invalid direction attribute value in confiuration of document function with ID=" + this.getPluginID()), (Throwable)e);
            }
            linkClassNames = linksViewConfig.getSafeStringList("linkclasses");
        }
        OwEditPropertiesDialog dlg = this.createPropertiesDialog(objects, oParent_p, refreshCtx_p, this.getConfigNode().getSafeIntegerValue("MaxChildSize", 50), (List)this.getSafeSetting("VersionViewColumnInfo", null), historySearchTemplate, historyViewColumnInfo, batchIndexProperties, split, displayTypedList, linkClassNames);
        dlg.setJspConfigurator(this.m_owJspFormConfigurator);
        dlg.setPropertyListConfiguration(this.getPropertyListConfiguration());
        dlg.setViewMask(iViewMask);
        dlg.setReadOnlyViewMask(iReadOnlyViewMask);
        dlg.setHelp(this.getHelpPath());
        dlg.setTitle(this.getContext().localize("owdocprops.OwEditDocumentProperties.helptitle", "Dokument Eigenschaften bearbeiten"));
        dlg.setInfoIcon(this.getBigIcon());
        OwXMLUtil previewConfiguration = this.getConfigNode().getSubUtil("Preview");
        dlg.setPreviewConfiguration(previewConfiguration);
        dlg.setModifiabilityHandler(this.modifiablityHandler);
        this.getContext().openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
        this.addHistoryEvent(objects, oParent_p, 2, 1);
    }

    protected OwEditPropertiesDialog createPropertiesDialog(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p, int iMaxElementSize_p, Collection versionColumnInfo_p, OwSearchTemplate historyViewSearchTemplate_p, Collection historyViewColumnInfo_p, Collection batchIndexProperties_p, OwObjectLinkRelation relationSplit_p, boolean displayTypedList_p, Collection<String> linkClassNames_p) throws Exception {
        OwEditPropertiesDialogBuilder builder = this.createDialogBuilder();
        builder.items(objects_p).index(0).parentObject(oParent_p);
        builder.maxElementSize(iMaxElementSize_p).versionColumnInfo(versionColumnInfo_p);
        builder.historyViewSearchTemplate(historyViewSearchTemplate_p).historyViewColumnInfo(historyViewColumnInfo_p);
        builder.batchIndexProperties(batchIndexProperties_p).relationSplit(relationSplit_p);
        builder.displayLinksByType(displayTypedList_p).linkClassNames(linkClassNames_p);
        return builder.build();
    }

    protected OwEditPropertiesDialogBuilder createDialogBuilder() {
        return new OwEditPropertiesDialogBuilder();
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
    }

    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
        switch (code_p) {
            case 15: {
                if (caller_p instanceof OwObjectPropertyView) {
                    OwObjectPropertyView realCaller = (OwObjectPropertyView)caller_p;
                    OwObject objectRef = realCaller.getObjectRef();
                    this.historizeModifiedPropsEvent(objectRef);
                    break;
                }
                if (!(caller_p instanceof OwObjectPropertyFormularView)) break;
                OwObjectPropertyFormularView realCaller = (OwObjectPropertyFormularView)caller_p;
                OwObject objectRef = realCaller.getObjectRef();
                this.historizeModifiedPropsEvent(objectRef);
            }
        }
    }

    private void historizeModifiedPropsEvent(OwObject objectRef_p) throws Exception {
        LinkedList<OwObject> objectColection = new LinkedList<OwObject>();
        if (objectRef_p != null) {
            objectColection.add(objectRef_p);
            OwObjectCollection parents = objectRef_p.getParents();
            OwObject parent = parents != null && parents.size() > 0 ? (OwObject)parents.get(0) : null;
            this.addHistoryEvent(objectRef_p, parent, 3, 1);
        }
    }

    protected OwPropertyListConfiguration getPropertyListConfiguration() {
        return this.propertyListConfiguration;
    }

    protected int calculateViewMask(OwXMLUtil configNode) throws Exception {
        int mask = 0;
        mask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)configNode, (String)ELEM_PROP_VIEW, (int)1);
        mask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)configNode, (String)ELEM_SYS_PROP_VIEW, (int)2);
        mask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)configNode, (String)ELEM_VERSIONS_VIEW, (int)8);
        mask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)configNode, (String)ELEM_HISTORY_VIEW, (int)16);
        mask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)configNode, (String)ELEM_LINKS_VIEW, (String)"show", (int)OwEditPropertiesDialog.VIEW_MASK_LINKS, (boolean)false);
        mask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)configNode, (String)ELEM_FILED_VIEW, (int)32);
        mask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)configNode, (String)ELEM_ACL_VIEW, (int)4);
        mask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)configNode, (String)"DocumentFunctionsView", (int)64);
        mask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)configNode, (String)"EnablePasteMetadata", (int)128);
        mask |= OwConfigUtils.computeViewMaskFromConfig((OwXMLUtil)configNode, (String)"EnableSaveAll", (int)4096);
        OwXMLUtil historyNode = configNode.getSubUtil(ELEM_HISTORY_VIEW);
        if (historyNode != null) {
            mask |= historyNode.getSafeBooleanAttributeValue("objecthistory", true) ? 1024 : 0;
            mask |= historyNode.getSafeBooleanAttributeValue("casehistory", true) ? 2048 : 0;
        } else {
            mask |= 0x400;
            mask |= 0x800;
        }
        mask |= this.getConfigNode().getSafeBooleanValue(ELEM_AUTO_OPEN, false) ? 512 : 0;
        return mask |= OwXMLDOMUtil.getSafeBooleanAttributeValue((Node)this.getConfigNode().getSubNode(ELEM_AUTO_OPEN), (String)"previewmode", (boolean)false) ? 256 : 0;
    }

    protected int calculateReadOnlyViewMask(OwXMLUtil confNode) throws OwException {
        int mask = 0;
        mask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig((OwXMLUtil)confNode, (String)ELEM_PROP_VIEW, (int)1);
        mask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig((OwXMLUtil)confNode, (String)ELEM_SYS_PROP_VIEW, (int)2);
        mask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig((OwXMLUtil)confNode, (String)ELEM_VERSIONS_VIEW, (int)8);
        mask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig((OwXMLUtil)confNode, (String)ELEM_HISTORY_VIEW, (int)16);
        mask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig((OwXMLUtil)confNode, (String)ELEM_FILED_VIEW, (int)32);
        return mask |= OwConfigUtils.computeReadOnlyViewMaskFromConfig((OwXMLUtil)confNode, (String)ELEM_ACL_VIEW, (int)4);
    }
}

