/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owhelp;

import com.wewebu.ow.server.app.OwInfoView;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterView;
import com.wewebu.ow.server.conf.OwBaseConfiguration;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class OwHelpView
extends OwMasterView
implements OwInfoView {
    Vector m_vecHelps = new Vector();
    String m_strLink;
    protected static final String QUERY_STRING_KEY_HELPFILEPATH = "helpfile";

    protected void init() throws Exception {
        super.init();
        for (int i = 0; i < OwBaseConfiguration.getPluginTypeDefinitions().length; ++i) {
            this.setOwHelpCollection(OwBaseConfiguration.getPluginTypeDefinitions()[i].getType(), OwBaseConfiguration.getPluginTypeDefinitions()[i].getDisplayName(this.getContext().getLocale()) + ":");
        }
    }

    public void setOwHelpCollection(String strPluginType_p, String strDisplayName_p) throws Exception {
        List mainPluginsList = this.getConfiguration().getAllowedPlugins(strPluginType_p);
        if (mainPluginsList != null) {
            OwHelpCollection mainHelps = null;
            for (int i = 0; i < mainPluginsList.size(); ++i) {
                OwXMLUtil pluginDescriptor = (OwXMLUtil)mainPluginsList.get(i);
                String strHelpPath = pluginDescriptor.getSafeTextValue("helppath", null);
                if (strHelpPath == null) continue;
                if (mainHelps == null) {
                    mainHelps = new OwHelpCollection();
                }
                mainHelps.m_vecPath.add(strHelpPath);
                mainHelps.m_vecName.add(this.getConfiguration().getLocalizedPluginTitle(pluginDescriptor));
            }
            if (mainHelps != null) {
                mainHelps.m_strDisplayName = strDisplayName_p;
                this.m_vecHelps.add(mainHelps);
            }
        }
    }

    public void onOpenHelpLink(HttpServletRequest request_p) throws Exception {
        this.m_strLink = request_p.getParameter(QUERY_STRING_KEY_HELPFILEPATH);
    }

    protected void onRender(Writer w_p) throws Exception {
        w_p.write("<div id=\"OwSubLayout_Div\" class=\"OwHelpView\">");
        w_p.write("<div id=\"OwSubLayout_MAIN\"><div class=\"OwHelpView_Chapters\">");
        this.renderChapters(w_p);
        w_p.write("</div>");
        w_p.write("<div class=\"OwHelpView_Text\">");
        this.renderHelpText(w_p);
        w_p.write("</div>");
        w_p.write("</div></div>");
    }

    protected void renderChapters(Writer w_p) throws Exception {
        Iterator it = this.m_vecHelps.iterator();
        w_p.write("<table class='OwChapter'>");
        while (it.hasNext()) {
            OwHelpCollection helpEntry = (OwHelpCollection)it.next();
            this.renderChapterIndex(w_p, helpEntry);
        }
        w_p.write("</table>");
    }

    public void setHelpJsp(String sLink_p) {
        this.m_strLink = "help_" + this.getContext().getLocale() + "/" + sLink_p;
    }

    protected void renderHelpText(Writer w_p) throws Exception {
        if (this.m_strLink != null) {
            this.serverSideInclude(this.m_strLink, w_p);
        } else {
            w_p.write(this.getContext().localize("app.OwHelpDialog.nohelpavailable", "No help available."));
        }
    }

    protected void renderChapterIndex(Writer w_p, OwHelpCollection helpEntry_p) throws Exception {
        w_p.write("<tr>");
        w_p.write("<th class='nowrap'>" + helpEntry_p.m_strDisplayName + "&nbsp;&nbsp;</th>");
        w_p.write("<td>");
        for (int i = 0; i < helpEntry_p.m_vecName.size(); ++i) {
            w_p.write(this.getLink(helpEntry_p.m_vecPath.elementAt(i).toString(), helpEntry_p.m_vecName.elementAt(i).toString(), "OwChapter"));
            if (i >= helpEntry_p.m_vecName.size() - 1) continue;
            w_p.write("<span> | </span>");
        }
        w_p.write("</td>");
        w_p.write("<td>&nbsp;</td>");
        w_p.write("</tr>");
    }

    public String getLink(String strHelpPath_p, String strName_p, String strClass_p) {
        String url = this.getEventURL("OpenHelpLink", "helpfile=help_" + this.getContext().getLocale() + "/" + strHelpPath_p);
        return "<a href='" + url + "' class='" + strClass_p + "'>" + strName_p + "</a>";
    }

    protected void onActivate(int iIndex_p, Object oReason_p) throws Exception {
        try {
            String sLastMasterPluginId = ((OwMainAppContext)this.getContext()).getCurrentMasterPluginID();
            if (!sLastMasterPluginId.equals(this.getPluginID())) {
                this.m_strLink = null;
                String strContextHelpPath = ((OwMainAppContext)this.getContext()).getConfiguration().getPlugin(sLastMasterPluginId).getSafeTextValue("helppath", null);
                if (strContextHelpPath != null) {
                    this.m_strLink = "help_" + this.getContext().getLocale() + "/" + strContextHelpPath;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onActivate(iIndex_p, oReason_p);
    }

    public class OwHelpCollection {
        Vector m_vecPath = new Vector();
        Vector m_vecName = new Vector();
        String m_strDisplayName;
    }
}

