/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owlink;

import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.dmsdialogs.views.OwSplitObjectListDocument;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectLink;
import com.wewebu.ow.server.ecm.OwObjectLinkRelation;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.exceptions.OwRuntimeException;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.plug.std.log.OwLog;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class OwReferencedObjectSplitDocument
extends OwSplitObjectListDocument {
    private static final Logger LOG = OwLog.getLogger(OwReferencedObjectSplitDocument.class);
    private OwObjectLinkRelation[] relations;

    public OwReferencedObjectSplitDocument(String[] splits, Collection<OwFieldColumnInfo>[] columnInfos, List<OwDocumentFunction> documentFunctions) {
        super(splits, (Collection[])columnInfos, documentFunctions);
    }

    public OwObjectCollection getSplit(int index) {
        OwObjectCollection col = super.getSplit(index);
        OwStandardObjectCollection retCol = null;
        if (col != null) {
            retCol = new OwStandardObjectCollection();
            OwObjectLinkRelation relation = this.getRelations()[index];
            for (OwObjectLink link : col) {
                OwObject retObj = this.getOwObject(link, relation);
                if (retObj == null) continue;
                retCol.add((Object)retObj);
            }
        }
        return retCol;
    }

    public void setRelations(OwObjectLinkRelation[] relations) {
        this.relations = relations;
    }

    public OwObjectLinkRelation[] getRelations() {
        return this.relations;
    }

    protected OwObject getOwObject(OwObjectLink link, OwObjectLinkRelation relation) {
        try {
            switch (relation) {
                case OUTBOUND: {
                    return link.getTarget().getInstance();
                }
            }
            return link.getSource().getInstance();
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("Faild to get instance from ");
            if (relation == OwObjectLinkRelation.OUTBOUND) {
                msg.append("target");
            } else {
                msg.append("source");
            }
            msg.append(" of link object");
            LOG.error((Object)msg, (Throwable)e);
            throw new OwProcessingRuntimeException(msg.toString(), e);
        }
    }

    protected static class OwProcessingRuntimeException
    extends OwRuntimeException {
        public OwProcessingRuntimeException(String message_p, Throwable cause_p) {
            super(message_p, cause_p);
        }

        public String getModulName() {
            return "plug.std";
        }
    }
}

