/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owsettings;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwSettings;
import com.wewebu.ow.server.app.OwSettingsProperty;
import com.wewebu.ow.server.app.OwSettingsPropertyControl;
import com.wewebu.ow.server.app.OwSettingsSet;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.plug.owsettings.OwSettingsDocument;
import com.wewebu.ow.server.plug.std.log.OwLog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwLayout;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwHTMLHelper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwSettingsSetView
extends OwLayout {
    private static final Logger LOG = OwLog.getLogger(OwSettingsSetView.class);
    protected static final String HELP_PATH = "helppath";
    protected List m_UserItemList = new ArrayList();
    public static final int BUTTON_REGION = 1;
    public static final int MAIN_REGION = 2;
    public static final int ERRORS_REGION = 3;
    protected OwSettingsSet m_settingsSet;
    protected OwSubMenuView m_MenuView;
    protected OwSettings m_Settings;
    protected boolean m_fAdmin;

    protected void init() throws Exception {
        super.init();
        this.m_Settings = ((OwMainAppContext)this.getContext()).getSettings();
        this.m_MenuView = new OwSubMenuView();
        this.addView((OwView)this.m_MenuView, 1, null);
        int defaultButton = this.m_MenuView.addFormMenuItem((OwEventTarget)this, this.getContext().localize("owsettings.OwSettingsSetView.apply", "Save"), "Apply", null);
        this.m_MenuView.setDefaultMenuItem(defaultButton);
        this.m_MenuView.addMenuItem((OwEventTarget)this, this.getContext().localize("owsettings.OwSettingsSetView.standard", "Default Values"), "Reset", null);
        this.m_fAdmin = ((OwMainAppContext)this.getContext()).isAllowed(6, "owcaneditsitesettings");
    }

    protected void onRender(Writer w_p) throws Exception {
        this.renderRegion(w_p, 3);
        this.renderRegion(w_p, 2);
        w_p.write("<div class=\"OwButtonBar\">");
        this.renderRegion(w_p, 1);
        w_p.write("</div>");
    }

    protected String usesFormWithAttributes() {
        return "";
    }

    protected void renderMainRegion(Writer w_p) throws Exception {
        if (this.m_settingsSet.hasUserEditableProperties()) {
            w_p.write("<fieldset>");
            String userSettings = this.getContext().localize("owsettings.OwSettingsSetView.usersettitle", "User Settings");
            w_p.write("<legend accesskey=\"" + userSettings.charAt(0) + "\">" + "<span class=\"OwSettingsSetView_subtitle\">" + userSettings + "</span>" + "</legend>");
            w_p.write("<div class=\"OwPropertyBlockLayout\">");
            this.renderSettingsSet(w_p, true);
            w_p.write("</div>");
            w_p.write("</fieldset>");
        }
        if (this.m_fAdmin && this.m_settingsSet.hasAppEditableProperties()) {
            w_p.write("<fieldset>");
            String siteSettings = this.getContext().localize("owsettings.OwSettingsSetView.appsettitle", "Site Settings");
            w_p.write("<legend accesskey=\"" + siteSettings.charAt(0) + "\">" + "<span class=\"OwSettingsSetView_subtitle\">" + siteSettings + "</span>" + "</legend>");
            w_p.write("<div class=\"OwPropertyBlockLayout\">");
            this.renderSettingsSet(w_p, false);
            w_p.write("</div>");
            w_p.write("</fieldset>");
        }
    }

    protected void renderSettingsSet(Writer w_p, boolean fUser_p) throws Exception {
        Iterator it = this.m_settingsSet.getProperties().values().iterator();
        boolean fOdd = false;
        while (it.hasNext()) {
            OwSettingsProperty property = (OwSettingsProperty)it.next();
            if (!property.isEditable() || property.isUser() != fUser_p) continue;
            boolean bl = fOdd = !fOdd;
            if (fOdd) {
                w_p.write("<div class=\"OwBlockOdd OwPropertyBlock\">");
            } else {
                w_p.write("<div class=\"OwBlockEven OwPropertyBlock\">");
            }
            w_p.write("<div class=\"OwPropertyLabel\">");
            ((OwSettingsPropertyControl)property).insertLabel(w_p);
            w_p.write("</div>\n");
            w_p.write("<div class=\"OwPropertyValue\">\n");
            w_p.write("<div class=\"OwPropertyControl\">");
            ((OwSettingsPropertyControl)property).insertFormField(w_p);
            w_p.write("</div>\n");
            String sHelpPath = ((OwSettingsPropertyControl)property).getHelpPath();
            if (null != sHelpPath) {
                w_p.write("<div class=\"OwPropertyHelpPath\">");
                w_p.write("<a title=\"");
                String helpTooltip = this.getContext().localize("plug.OwSettingsSetView.helpbtntooltip", "Help");
                w_p.write(helpTooltip);
                w_p.write("\" href=\"");
                w_p.write(this.getEventURL("OpenHelp", "helppath=" + sHelpPath));
                w_p.write("\"><img src=\"");
                w_p.write(this.getContext().getDesignURL());
                w_p.write("/images/helpicon.png\"");
                w_p.write(" alt=\"");
                w_p.write(helpTooltip);
                w_p.write("\" title=\"");
                w_p.write(helpTooltip);
                w_p.write("\"/></a>");
                w_p.write("</div>\n");
            }
            w_p.write("<div class=\"OwPropertyError\" style=\"max-width:270px;\">");
            if (((OwSettingsPropertyControl)property).hasError()) {
                w_p.write(((OwSettingsPropertyControl)property).getPropertyError());
            }
            w_p.write("</div>\n");
            w_p.write("</div>");
            w_p.write("</div>");
        }
    }

    public void onOpenHelp(HttpServletRequest request_p) throws Exception {
        String sHelpPath = request_p.getParameter(HELP_PATH);
        ((OwMainAppContext)this.getContext()).openHelp(sHelpPath);
    }

    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 3: {
                this.renderErrorsRegion(w_p);
                break;
            }
            case 2: {
                this.renderMainRegion(w_p);
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    protected void renderErrorsRegion(Writer w_p) throws IOException {
        Iterator it = this.m_settingsSet.getProperties().values().iterator();
        LinkedList<OwSettingsProperty> errors = new LinkedList<OwSettingsProperty>();
        while (it.hasNext()) {
            OwSettingsProperty property = (OwSettingsProperty)it.next();
            if (!(property instanceof OwSettingsPropertyControl) || !((OwSettingsPropertyControl)property).hasError()) continue;
            errors.add(property);
        }
        if (errors.size() > 0) {
            StringBuffer errorsBuffer = new StringBuffer();
            errorsBuffer.append("<div name=\"Errors\" class=\"OwAllFieldErrors\">");
            for (int i = 0; i < errors.size(); ++i) {
                OwSettingsPropertyControl propertyControl = (OwSettingsPropertyControl)errors.get(i);
                if (i == 0) {
                    if (errors.size() > 1) {
                        errorsBuffer.append(this.getContext().localize("owsettings.OwSettingsSetView.errors", "Errors:"));
                        errorsBuffer.append("<br/>");
                    }
                } else {
                    errorsBuffer.append("<br/>");
                }
                errorsBuffer.append(this.getContext().localize1("app.OwFieldManager.errorForField", "Error for %1:", propertyControl.getDisplayName()));
                errorsBuffer.append("&nbsp;");
                StringWriter writer = new StringWriter();
                OwHTMLHelper.writeSecureHTML((Writer)writer, (String)propertyControl.getPropertyError());
                errorsBuffer.append(writer.toString());
            }
            errorsBuffer.append("</div>");
            w_p.write(errorsBuffer.toString());
        }
    }

    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        for (OwSettingsProperty property : this.m_settingsSet.getProperties().values()) {
            if (!property.isEditable() || !property.isUser() && !this.m_fAdmin) continue;
            ((OwSettingsPropertyControl)property).updateExternalFormTarget(request_p, fSave_p);
        }
        return true;
    }

    protected void onActivate(int iIndex_p, Object oReason_p) throws Exception {
        this.m_settingsSet = (OwSettingsSet)oReason_p;
        for (OwSettingsProperty property : this.m_settingsSet.getProperties().values()) {
            if (!property.isEditable()) continue;
            ((OwSettingsPropertyControl)property).setExternalFormTarget((OwEventTarget)this);
        }
    }

    public void onApply(HttpServletRequest request_p, Object oReason_p) throws Exception {
        Iterator it = this.m_settingsSet.getProperties().values().iterator();
        boolean errorsEncopuntered = false;
        StringBuffer errorCollector = new StringBuffer();
        while (it.hasNext()) {
            OwSettingsPropertyControl property = (OwSettingsPropertyControl)it.next();
            if (!property.isEditable() || !property.isUser() && !this.m_fAdmin) continue;
            property.updateExternalFormTarget(request_p, true);
            if (!property.hasError()) continue;
            if (!errorsEncopuntered) {
                errorsEncopuntered = true;
            }
            if (errorCollector.length() > 0) {
                errorCollector.append("; ");
            }
            errorCollector.append("For property: " + property.getDisplayName() + " ->");
            errorCollector.append(property.getPropertyError());
        }
        if (errorsEncopuntered) {
            LOG.error((Object)("The following errors occured: " + errorCollector.toString()));
            this.getContext().broadcast((OwEventTarget)this, 10);
        } else {
            ((OwSettingsDocument)this.getDocument()).safeUserSettings();
            if (this.m_fAdmin) {
                ((OwSettingsDocument)this.getDocument()).safeSiteSettings();
            }
            this.getContext().broadcast((OwEventTarget)this, 10);
            ((OwMainAppContext)this.getContext()).postMessage(this.getContext().localize("owsettings.OwSettingsSetView.settingssaved", "Settings have been saved. Please log out and log in again to make these changes effective."));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Settings saved successfully");
            }
        }
    }

    public void onReset(HttpServletRequest request_p, Object oReason_p) throws Exception {
        for (OwSettingsProperty property : this.m_settingsSet.getProperties().values()) {
            property.setDefault();
        }
        ((OwMainAppContext)this.getContext()).postMessage(this.getContext().localize("owsettings.OwSettingsSetView.settingsreset", "Settings have been reset."));
    }
}

